/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.storage;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.TickHandler;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.economy.BankAccount;
import com.pixelmonmod.pixelmon.api.economy.BankAccountManager;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.PartyStorage;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageManager;
import com.pixelmonmod.pixelmon.api.storage.StorageSaveAdapter;
import com.pixelmonmod.pixelmon.api.storage.StorageSaveScheduler;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage.pc.ClientInitializePCPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class PixelmonStorageManager
implements StorageManager,
BankAccountManager {
    protected final Map<UUID, PlayerPartyStorage> parties = Maps.newConcurrentMap();
    protected final Map<UUID, PCStorage> pcs = Maps.newConcurrentMap();
    protected final List<UUID> playersWithSyncedPCs = Lists.newArrayList();
    protected StorageSaveScheduler scheduler;
    protected StorageSaveAdapter adapter;

    public PixelmonStorageManager(StorageSaveScheduler scheduler, StorageSaveAdapter adapter) {
        this.scheduler = scheduler;
        this.adapter = adapter;
    }

    @Override
    public StorageSaveScheduler getSaveScheduler() {
        return this.scheduler;
    }

    @Override
    public StorageSaveAdapter getSaveAdapter() {
        return this.adapter;
    }

    public void setSaveScheduler(StorageSaveScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setSaveAdapter(StorageSaveAdapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public PlayerPartyStorage getParty(UUID uuid) {
        PlayerPartyStorage partyStorage = this.parties.computeIfAbsent(uuid, ___ -> {
            PlayerPartyStorage load = this.getSaveAdapter().load(uuid, PlayerPartyStorage.class);
            load.tryUpdatePlayerName();
            return load;
        });
        if (partyStorage.countAll() == 0 && !partyStorage.starterPicked && PixelmonConfigProxy.getGeneral().isStarterOnJoin() && partyStorage.getPlayer() != null) {
            TickHandler.registerStarterList(partyStorage.getPlayer());
        }
        return partyStorage;
    }

    @Override
    public PCStorage getPCForPlayer(UUID uuid) {
        ServerPlayerEntity player;
        PCStorage pc = this.pcs.get(uuid);
        if (pc == null) {
            pc = this.getSaveAdapter().load(uuid, PCStorage.class);
            if (pc == null) {
                pc = new PCStorage(uuid);
            }
            this.pcs.put(uuid, pc);
            ServerPlayerEntity playerOwner = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(pc.uuid);
            if (playerOwner != null) {
                pc.setPlayer(playerOwner.func_110124_au(), playerOwner.func_200200_C_().getString());
            }
            for (ServerPlayerEntity player2 : pc.getPlayersToUpdate()) {
                NetworkHelper.sendPacket(new ClientInitializePCPacket(pc), player2);
            }
        }
        if (!this.playersWithSyncedPCs.contains(uuid) && (player = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(uuid)) != null) {
            this.initializePCForPlayer(player, pc);
            this.playersWithSyncedPCs.add(uuid);
        }
        return pc;
    }

    @Override
    public Iterable<PokemonStorage> getAllCachedStorages() {
        ArrayList allStorages = Lists.newArrayListWithCapacity((int)(this.parties.size() + this.pcs.size()));
        allStorages.addAll(this.parties.values());
        allStorages.addAll(this.pcs.values());
        return allStorages;
    }

    @Override
    public void onStorageSaved(PokemonStorage storage) {
        if ((storage instanceof PartyStorage || storage instanceof PCStorage) && ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(storage.uuid) == null) {
            if (storage instanceof PartyStorage) {
                this.parties.remove(storage.uuid);
            } else {
                this.pcs.remove(storage.uuid);
            }
        }
    }

    @Override
    public void clearAll() {
        this.pcs.clear();
        this.parties.clear();
    }

    @Override
    public Optional<? extends BankAccount> getBankAccount(UUID uuid) {
        return Optional.of(this.getParty(uuid));
    }

    @Override
    public Optional<? extends BankAccount> getBankAccount(ServerPlayerEntity player) {
        return this.getBankAccount(player.func_110124_au());
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.getPlayer() instanceof ServerPlayerEntity)) {
            return;
        }
        if (this.parties.containsKey(event.getPlayer().func_110124_au())) {
            this.parties.get(event.getPlayer().func_110124_au()).tryUpdatePlayerName();
        } else {
            this.getParty(event.getPlayer().func_110124_au());
        }
        if (this.pcs.containsKey(event.getPlayer().func_110124_au())) {
            PCStorage pc = this.pcs.get(event.getPlayer().func_110124_au());
            pc.setPlayer(event.getPlayer().func_110124_au(), event.getPlayer().func_200200_C_().getString());
            NetworkHelper.sendPacket(new ClientInitializePCPacket(pc), (ServerPlayerEntity)event.getPlayer());
        } else {
            this.getPCForPlayer(event.getPlayer().func_110124_au());
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        this.playersWithSyncedPCs.remove(event.getPlayer().func_110124_au());
    }
}

