/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.conditions;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.config.BetterSpawnerConfig;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.conditions.TriggerLocation;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;

public class LocationType {
    public static final List<LocationType> LOCATION_TYPES = new ArrayList<LocationType>();
    public final String name;
    public Predicate<BlockState> baseBlockCondition = state -> true;
    public Predicate<BlockState> surroundingBlockCondition = state -> state.func_177230_c() == Blocks.field_150350_a;
    public Predicate<Set<Block>> neededNearbyBlockCondition = block -> true;
    public Consumer<SpawnLocation> mutator = spawnLocation -> {};
    public Boolean seesSky = null;
    public static LocationType LAND = new LocationType("Land").setSeesSky(true).setBaseBlockCondition(state -> BetterSpawnerConfig.getLandBlocks().contains(state.func_177230_c())).setSurroundingBlockCondition(state -> BetterSpawnerConfig.getAirBlocks().contains(state.func_177230_c()));
    public static LocationType UNDERGROUND = new LocationType("Underground").setSeesSky(false).setBaseBlockCondition(LocationType.LAND.baseBlockCondition).setSurroundingBlockCondition(LocationType.LAND.surroundingBlockCondition);
    public static LocationType WATER = new LocationType("Water").setSeesSky(true).setBaseBlockCondition(state -> BetterSpawnerConfig.getWaterBlocks().contains(state.func_177230_c())).setSurroundingBlockCondition(state -> BetterSpawnerConfig.getWaterBlocks().contains(state.func_177230_c()));
    public static LocationType SURFACE_WATER = new LocationType("Surface Water").setSeesSky(true).setBaseBlockCondition(LocationType.WATER.baseBlockCondition).setSurroundingBlockCondition(state -> LocationType.WATER.surroundingBlockCondition.test((BlockState)state) || LocationType.LAND.surroundingBlockCondition.test((BlockState)state)).setLocationMutator(spawnLocation -> {
        int y = spawnLocation.location.pos.func_177956_o();
        BlockPos.Mutable highest = new BlockPos.Mutable(spawnLocation.location.pos.func_177958_n(), spawnLocation.location.pos.func_177956_o(), spawnLocation.location.pos.func_177952_p());
        while (spawnLocation.location.world.func_180495_p((BlockPos)highest).func_185904_a().func_76224_d()) {
            highest.func_185336_p(++y);
        }
        spawnLocation.location.pos.func_185336_p(highest.func_177956_o());
    });
    public static LocationType LAVA = new LocationType("Lava").setBaseBlockCondition(state -> BetterSpawnerConfig.getLavaBlocks().contains(state.func_177230_c())).setSurroundingBlockCondition(state -> BetterSpawnerConfig.getLavaBlocks().contains(state.func_177230_c()));
    public static LocationType SURFACE_LAVA = new LocationType("Surface Lava").setSeesSky(true).setBaseBlockCondition(LocationType.LAVA.baseBlockCondition).setSurroundingBlockCondition(state -> LocationType.LAVA.surroundingBlockCondition.test((BlockState)state) || LocationType.LAND.surroundingBlockCondition.test((BlockState)state)).setLocationMutator(spawnLocation -> {
        int y = spawnLocation.location.pos.func_177956_o();
        BlockPos.Mutable highest = new BlockPos.Mutable(spawnLocation.location.pos.func_177958_n(), spawnLocation.location.pos.func_177956_o(), spawnLocation.location.pos.func_177952_p());
        while (spawnLocation.location.world.func_180495_p((BlockPos)highest).func_185904_a().func_76224_d()) {
            highest.func_185336_p(++y);
        }
        spawnLocation.location.pos.func_185336_p(highest.func_177956_o());
    });
    public static LocationType UNDERGROUND_LAVA = new LocationType("Underground Lava").setSeesSky(false).setBaseBlockCondition(LocationType.LAVA.baseBlockCondition).setSurroundingBlockCondition(LocationType.LAVA.surroundingBlockCondition);
    public static LocationType LIQUID = new LocationType("Liquid").setBaseBlockCondition(LocationType.WATER.baseBlockCondition.or(LocationType.LAVA.baseBlockCondition)).setSurroundingBlockCondition(LocationType.WATER.baseBlockCondition.or(LocationType.LAVA.baseBlockCondition));
    public static LocationType UNDERGROUND_LIQUID = new LocationType("Underground Liquid").setSeesSky(false).setBaseBlockCondition(LocationType.LIQUID.baseBlockCondition).setSurroundingBlockCondition(LocationType.LIQUID.surroundingBlockCondition);
    public static LocationType SURFACE_LIQUID = new LocationType("Surface Liquid").setSeesSky(true).setBaseBlockCondition(LocationType.LIQUID.baseBlockCondition).setSurroundingBlockCondition(state -> LocationType.LIQUID.surroundingBlockCondition.test((BlockState)state) || LocationType.LAND.surroundingBlockCondition.test((BlockState)state)).setLocationMutator(spawnLocation -> {
        int y = spawnLocation.location.pos.func_177956_o();
        BlockPos.Mutable highest = new BlockPos.Mutable(spawnLocation.location.pos.func_177958_n(), spawnLocation.location.pos.func_177956_o(), spawnLocation.location.pos.func_177952_p());
        while (spawnLocation.location.world.func_180495_p((BlockPos)highest).func_185904_a().func_76224_d()) {
            highest.func_185336_p(++y);
        }
        spawnLocation.location.pos.func_185336_p(highest.func_177956_o());
    });
    public static LocationType SEAFLOOR = new LocationType("Seafloor").setSeesSky(true).setBaseBlockCondition(LocationType.LAND.baseBlockCondition).setSurroundingBlockCondition(LocationType.WATER.surroundingBlockCondition);
    public static LocationType LAVA_FLOOR = new LocationType("Lava Floor").setSeesSky(true).setBaseBlockCondition(LocationType.LAND.baseBlockCondition).setSurroundingBlockCondition(LocationType.LAVA.surroundingBlockCondition);
    public static LocationType LIQUID_FLOOR = new LocationType("Liquid Floor").setSeesSky(true).setBaseBlockCondition(LocationType.LAND.baseBlockCondition).setSurroundingBlockCondition(LocationType.LIQUID.surroundingBlockCondition);
    public static LocationType UNDERGROUND_WATER = new LocationType("Underground Water").setSeesSky(false).setBaseBlockCondition(LocationType.WATER.baseBlockCondition).setSurroundingBlockCondition(LocationType.WATER.surroundingBlockCondition);
    public static LocationType AIR = new LocationType("Air").setSeesSky(true).setBaseBlockCondition(state -> LocationType.LAND.baseBlockCondition.test((BlockState)state) || LocationType.WATER.baseBlockCondition.test((BlockState)state)).setSurroundingBlockCondition(state -> LocationType.LAND.surroundingBlockCondition.test((BlockState)state) || LocationType.WATER.surroundingBlockCondition.test((BlockState)state)).setLocationMutator(spawnLocation -> {
        BlockState state;
        BlockPos.Mutable highest = new BlockPos.Mutable(spawnLocation.location.pos.func_177958_n(), spawnLocation.location.pos.func_177956_o(), spawnLocation.location.pos.func_177952_p());
        highest.func_185336_p(230);
        while (highest.func_177956_o() > 0 && !(state = spawnLocation.location.world.func_180495_p((BlockPos)highest)).func_185904_a().func_76224_d() && !state.func_185904_a().func_76220_a()) {
            highest.func_185336_p(highest.func_177956_o() - 1);
        }
        if (highest.func_177956_o() == 0) {
            return;
        }
        if (highest.func_177956_o() < 230) {
            spawnLocation.location.pos.func_185336_p(highest.func_177956_o() + RandomHelper.getRandomNumberBetween(8, 20));
        }
    });
    public static LocationType TREE_TOP = new LocationType("Tree Top").setBaseBlockCondition(state -> BetterSpawnerConfig.getTreeTopBlocks().contains(state.func_177230_c())).setSurroundingBlockCondition(state -> BetterSpawnerConfig.getAirBlocks().contains(state.func_177230_c())).setSeesSky(true);
    public static LocationType MANMADE = new LocationType("Manmade").setBaseBlockCondition(state -> BetterSpawnerConfig.getStructureBlocks().contains(state.func_177230_c())).setSurroundingBlockCondition(state -> BetterSpawnerConfig.getAirBlocks().contains(state.func_177230_c())).setSeesSky(true);
    public static LocationType INDOORS = new LocationType("Indoors").setBaseBlockCondition(state -> BetterSpawnerConfig.getStructureBlocks().contains(state.func_177230_c())).setSurroundingBlockCondition(state -> BetterSpawnerConfig.getAirBlocks().contains(state.func_177230_c())).setSeesSky(false);
    public static LocationType ROCK_SMASH = new TriggerLocation("Rock Smash");
    public static LocationType HEADBUTT = new TriggerLocation("Headbutt");
    public static LocationType SWEET_SCENT = new TriggerLocation("Sweet Scent");
    public static LocationType FORAGE = new TriggerLocation("Forage");
    public static LocationType CURRY_NONE = new TriggerLocation("Curry None");
    public static LocationType CURRY_SWEET = new TriggerLocation("Curry Sweet");
    public static LocationType CURRY_SOUR = new TriggerLocation("Curry Sour");
    public static LocationType CURRY_BITTER = new TriggerLocation("Curry Bitter");
    public static LocationType CURRY_DRY = new TriggerLocation("Curry Dry");
    public static LocationType CURRY_SPICY = new TriggerLocation("Curry Spicy");
    public static TriggerLocation OLD_ROD = new TriggerLocation("Old Rod");
    public static TriggerLocation GOOD_ROD = new TriggerLocation("Good Rod");
    public static TriggerLocation SUPER_ROD = new TriggerLocation("Super Rod");
    public static TriggerLocation OAS_ROD = new TriggerLocation("Oas Rod");
    public static TriggerLocation OK_ROD_QUALITY = new TriggerLocation("OK Rod Quality");
    public static TriggerLocation SO_SO_ROD_QUALITY = new TriggerLocation("So-So Rod Quality");
    public static TriggerLocation GOOD_ROD_QUALITY = new TriggerLocation("Good Rod Quality");
    public static TriggerLocation GREAT_ROD_QUALITY = new TriggerLocation("Great Rod Quality");
    public static TriggerLocation RARE_ROD_QUALITY = new TriggerLocation("Rare Rod Quality");
    public static TriggerLocation PRO_ROD_QUALITY = new TriggerLocation("Pro Rod Quality");
    public static TriggerLocation SUPREME_ROD_QUALITY = new TriggerLocation("Supreme Rod Quality");
    public static TriggerLocation OLD_ROD_LAVA = new TriggerLocation("Old Rod Lava");
    public static TriggerLocation GOOD_ROD_LAVA = new TriggerLocation("Good Rod Lava");
    public static TriggerLocation SUPER_ROD_LAVA = new TriggerLocation("Super Rod Lava");
    public static TriggerLocation GRASS = new TriggerLocation("Grass");
    public static TriggerLocation CAVE_ROCK = new TriggerLocation("Cave Rock");
    public static TriggerLocation DOUBLE_GRASS = new TriggerLocation("Tall Grass");
    public static TriggerLocation SEAWEED = new TriggerLocation("Seawed");

    public LocationType(String name) {
        this.name = name;
    }

    public LocationType setBaseBlockCondition(Predicate<BlockState> baseBlockCondition) {
        this.baseBlockCondition = baseBlockCondition;
        return this;
    }

    public LocationType setSurroundingBlockCondition(Predicate<BlockState> surroundingBlockCondition) {
        this.surroundingBlockCondition = surroundingBlockCondition;
        return this;
    }

    public LocationType setNeededNearbyBlockCondition(Predicate<Set<Block>> neededNearbyBlockCondition) {
        this.neededNearbyBlockCondition = neededNearbyBlockCondition;
        return this;
    }

    public LocationType setSeesSky(Boolean seesSky) {
        this.seesSky = seesSky;
        return this;
    }

    public LocationType setLocationMutator(Consumer<SpawnLocation> mutator) {
        this.mutator = mutator;
        return this;
    }

    public String toString() {
        return this.name;
    }

    public static LocationType of(String name) {
        for (LocationType type : LOCATION_TYPES) {
            if (!type.name.equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }

    public static List<LocationType> getPotentialTypes(BlockState state) {
        ArrayList types = Lists.newArrayListWithCapacity((int)(LOCATION_TYPES.size() / 2));
        for (LocationType type : LOCATION_TYPES) {
            if (state == null || !type.baseBlockCondition.test(state)) continue;
            types.add(type);
        }
        return types;
    }

    static {
        LOCATION_TYPES.add(LAND);
        LOCATION_TYPES.add(UNDERGROUND);
        LOCATION_TYPES.add(WATER);
        LOCATION_TYPES.add(SURFACE_WATER);
        LOCATION_TYPES.add(SEAFLOOR);
        LOCATION_TYPES.add(UNDERGROUND_WATER);
        LOCATION_TYPES.add(AIR);
        LOCATION_TYPES.add(LAVA);
        LOCATION_TYPES.add(SURFACE_LAVA);
        LOCATION_TYPES.add(UNDERGROUND_LAVA);
        LOCATION_TYPES.add(ROCK_SMASH);
        LOCATION_TYPES.add(HEADBUTT);
        LOCATION_TYPES.add(SWEET_SCENT);
        LOCATION_TYPES.add(TREE_TOP);
        LOCATION_TYPES.add(MANMADE);
        LOCATION_TYPES.add(INDOORS);
        LOCATION_TYPES.add(LIQUID);
        LOCATION_TYPES.add(UNDERGROUND_LIQUID);
        LOCATION_TYPES.add(SURFACE_LIQUID);
        LOCATION_TYPES.add(LAVA_FLOOR);
        LOCATION_TYPES.add(LIQUID_FLOOR);
        LOCATION_TYPES.add(FORAGE);
        LOCATION_TYPES.add(CURRY_NONE);
        LOCATION_TYPES.add(CURRY_BITTER);
        LOCATION_TYPES.add(CURRY_DRY);
        LOCATION_TYPES.add(CURRY_SOUR);
        LOCATION_TYPES.add(CURRY_SPICY);
        LOCATION_TYPES.add(CURRY_SWEET);
        LOCATION_TYPES.add(OLD_ROD);
        LOCATION_TYPES.add(GOOD_ROD);
        LOCATION_TYPES.add(SUPER_ROD);
        LOCATION_TYPES.add(OAS_ROD);
        LOCATION_TYPES.add(OLD_ROD_LAVA);
        LOCATION_TYPES.add(GOOD_ROD_LAVA);
        LOCATION_TYPES.add(SUPER_ROD_LAVA);
        LOCATION_TYPES.add(OK_ROD_QUALITY);
        LOCATION_TYPES.add(SO_SO_ROD_QUALITY);
        LOCATION_TYPES.add(GOOD_ROD_QUALITY);
        LOCATION_TYPES.add(GREAT_ROD_QUALITY);
        LOCATION_TYPES.add(RARE_ROD_QUALITY);
        LOCATION_TYPES.add(PRO_ROD_QUALITY);
        LOCATION_TYPES.add(SUPREME_ROD_QUALITY);
        LOCATION_TYPES.add(GRASS);
        LOCATION_TYPES.add(CAVE_ROCK);
        LOCATION_TYPES.add(DOUBLE_GRASS);
        LOCATION_TYPES.add(SEAWEED);
    }
}

