/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.archetypes.group;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.Range;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.lang.reflect.Type;
import net.minecraft.entity.Entity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class GroupSpawnSettings {
    private PokemonSpecification spec;
    private float chance;
    private Range amountRange;
    private Vector3i spawnRangeMinimum;
    private Vector3i spawnRangeMaximum;

    public GroupSpawnSettings(PokemonSpecification spec, float chance, Range amountRange, Vector3i spawnRangeMinimum, Vector3i spawnRangeMaximum) {
        this.spec = spec;
        this.chance = chance;
        this.amountRange = amountRange;
        this.spawnRangeMinimum = spawnRangeMinimum;
        this.spawnRangeMaximum = spawnRangeMaximum;
    }

    public boolean shouldSpawn() {
        return RandomHelper.getRandomChance(this.chance);
    }

    public int getRandomAmount() {
        return this.amountRange.getRandomValue();
    }

    public PixelmonEntity spawnPokemon(World level, BlockPos center, SpawnLocationType spawnLocationType, int flockId) {
        boolean shiny;
        BlockPos spawn = this.getRandomLocation(level, center, spawnLocationType);
        Pokemon pokemon = this.spec.create();
        boolean bl = shiny = PixelmonConfigProxy.getSpawning().getShinyRate((RegistryKey<World>)level.func_234923_W_()) > 0.0f && RandomHelper.getRandomChance(1.0f / PixelmonConfigProxy.getSpawning().getShinyRate((RegistryKey<World>)level.func_234923_W_()));
        if (shiny) {
            pokemon.setShiny();
        }
        PixelmonEntity entity = new PixelmonEntity(level, pokemon);
        entity.setSpawnLocation(spawnLocationType);
        entity.func_70107_b(spawn.func_177958_n(), spawn.func_177956_o(), spawn.func_177952_p());
        entity.setGroupId(flockId);
        entity.resetAI();
        level.func_217376_c((Entity)entity);
        return entity;
    }

    private BlockPos getRandomLocation(World level, BlockPos center, SpawnLocationType spawnLocationType) {
        BlockPos maxPos;
        BlockPos minPos = center.func_177971_a(this.spawnRangeMinimum);
        if (minPos == (maxPos = center.func_177971_a(this.spawnRangeMaximum))) {
            return center;
        }
        for (int attempts = 0; attempts < 50; ++attempts) {
            BlockPos newPosition = this.selectRandom(minPos, maxPos);
            BlockPos yAdjusted = spawnLocationType.getSpawnLocation(level, newPosition);
            if (yAdjusted.func_177956_o() < minPos.func_177956_o() || yAdjusted.func_177956_o() > maxPos.func_177956_o()) continue;
            return yAdjusted;
        }
        return center;
    }

    private BlockPos selectRandom(BlockPos minPos, BlockPos maxPos) {
        int randomX = RandomHelper.getRandomNumberBetween(minPos.func_177958_n(), maxPos.func_177958_n());
        int randomY = RandomHelper.getRandomNumberBetween(minPos.func_177956_o(), maxPos.func_177956_o());
        int randomZ = RandomHelper.getRandomNumberBetween(minPos.func_177952_p(), maxPos.func_177952_p());
        return new BlockPos(randomX, randomY, randomZ);
    }

    public static final class TypeAdapter
    implements JsonSerializer<GroupSpawnSettings>,
    JsonDeserializer<GroupSpawnSettings> {
        public GroupSpawnSettings deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            PokemonSpecification spec = PokemonSpecificationProxy.create(object.get("spec").getAsString());
            float chance = object.get("chance").getAsFloat();
            Range amountRange = (Range)context.deserialize((JsonElement)object.getAsJsonObject("amount"), Range.class);
            Vector3i spawnRangeMinimum = (Vector3i)context.deserialize((JsonElement)object.getAsJsonObject("spawn_range_minimum"), Vector3i.class);
            Vector3i spawnRangeMaximum = (Vector3i)context.deserialize((JsonElement)object.getAsJsonObject("spawn_range_maximum"), Vector3i.class);
            return new GroupSpawnSettings(spec, chance, amountRange, spawnRangeMinimum, spawnRangeMaximum);
        }

        public JsonElement serialize(GroupSpawnSettings src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.addProperty("spec", src.spec.toString());
            object.addProperty("chance", (Number)Float.valueOf(src.chance));
            object.add("amount", context.serialize((Object)src.amountRange));
            object.add("spawn_range_minimum", context.serialize((Object)src.spawnRangeMinimum));
            object.add("spawn_range_maximum", context.serialize((Object)src.spawnRangeMaximum));
            return object;
        }
    }
}

