/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.archetypes.algorithms.checkspawns;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.calculators.CheckSpawns;
import com.pixelmonmod.pixelmon.api.spawning.conditions.LocationType;
import com.pixelmonmod.pixelmon.api.spawning.util.SpatialData;
import com.pixelmonmod.pixelmon.api.spawning.util.SpawningHeightmap;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.api.world.MutableLocation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class GenericTriggerCheckSpawns
implements CheckSpawns {
    public String node;
    public LocationType locationType;

    public GenericTriggerCheckSpawns(LocationType locationType, String node) {
        this.locationType = locationType;
        this.node = node;
    }

    @Override
    public String getPermissionNode() {
        return this.node;
    }

    @Override
    public void checkSpawns(AbstractSpawner spawner, CommandSource sender, List<String> arguments) {
        ServerPlayerEntity target = null;
        if (!(sender.func_197022_f() instanceof ServerPlayerEntity)) {
            PlayerList playerList = ServerLifecycleHooks.getCurrentServer().func_184103_al();
            for (String argument : arguments) {
                if (!spawner.name.equals(argument) && (target = playerList.func_152612_a(argument)) != null) break;
            }
            if (target == null) {
                sender.func_197030_a((ITextComponent)TextHelper.translate(TextFormatting.RED, "spawning.error.mustbeplayer"), false);
                return;
            }
        }
        if (target == null) {
            target = (ServerPlayerEntity)sender.func_197022_f();
        }
        SpatialData data = spawner.calculateSpatialData((World)target.func_71121_q(), target.func_233580_cy_(), 6, true, s -> true);
        SpawnLocation spawnLocation = new SpawnLocation((Entity)target, new MutableLocation((World)target.func_71121_q(), target.func_233580_cy_()), Sets.newHashSet((Object[])new LocationType[]{this.locationType}), data.baseBlock, data.uniqueSurroundingBlocks, target.func_71121_q().func_226691_t_(target.func_233580_cy_()), SpawningHeightmap.canSeeSky(target.func_233580_cy_(), (World)target.func_71121_q()), 6, 1);
        ServerLifecycleHooks.getCurrentServer().execute(() -> {
            List<SpawnInfo> spawns = spawner.getSuitableSpawns(spawnLocation);
            HashMap<SpawnLocation, List<SpawnInfo>> possibleSpawns = new HashMap<SpawnLocation, List<SpawnInfo>>();
            possibleSpawns.put(spawnLocation, spawns);
            Map<String, Double> percentages = spawner.selectionAlgorithm.getPercentages(spawner, possibleSpawns);
            List<IFormattableTextComponent> messages = this.generateMessages(percentages, arguments);
            messages.add(0, TextHelper.translate(TextFormatting.AQUA, "spawning.checkspawns.possiblespawns"));
            for (IFormattableTextComponent message : messages) {
                sender.func_197030_a((ITextComponent)message, false);
            }
        });
    }
}

