/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.spawning.CreateSpawnerEvent;
import com.pixelmonmod.pixelmon.api.spawning.RarityTweak;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.SpawnSet;
import com.pixelmonmod.pixelmon.api.spawning.SpawnerCondition;
import com.pixelmonmod.pixelmon.api.spawning.SpawningTweak;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.algorithms.selection.LocationWeightedAlgorithm;
import com.pixelmonmod.pixelmon.api.spawning.calculators.CheckSpawns;
import com.pixelmonmod.pixelmon.api.spawning.calculators.SelectionAlgorithm;
import com.pixelmonmod.pixelmon.api.spawning.conditions.RarityMultiplier;
import com.pixelmonmod.pixelmon.api.spawning.conditions.SpawnCondition;
import com.pixelmonmod.pixelmon.api.spawning.util.SpatialData;
import com.pixelmonmod.pixelmon.api.util.helpers.CollectionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.world.BlockCollection;
import com.pixelmonmod.pixelmon.spawning.SpawnedTracker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class AbstractSpawner {
    public final String name;
    public final SpawnedTracker spawnedTracker = new SpawnedTracker(this);
    public SelectionAlgorithm selectionAlgorithm = new LocationWeightedAlgorithm();
    public CheckSpawns checkSpawns = CheckSpawns.getDefault();
    public List<SpawningTweak> tweaks = new ArrayList<SpawningTweak>();
    public List<SpawnerCondition> conditions = new ArrayList<SpawnerCondition>();
    public List<RarityTweak> rarityTweaks = new ArrayList<RarityTweak>();
    public List<RarityMultiplier> rarityMultipliers = new ArrayList<RarityMultiplier>();
    public volatile boolean isBusy = false;
    public long lastSpawnTime;
    public List<SpawnSet> spawnSets = new ArrayList<SpawnSet>();
    public transient HashMap<ResourceLocation, List<SpawnInfo>> cacheSets = null;

    public AbstractSpawner(String name) {
        this.name = name;
    }

    public boolean shouldDoSpawning() {
        return !this.isBusy;
    }

    public List<SpawnInfo> getSuitableSpawns(SpawnLocation spawnLocation) {
        if (this.cacheSets == null) {
            ArrayList suitableSpawns = Lists.newArrayList();
            for (int i = 0; i < this.spawnSets.size(); ++i) {
                SpawnSet spawnSet = this.spawnSets.get(i);
                for (int j = 0; j < spawnSet.spawnInfos.size(); ++j) {
                    SpawnInfo info = spawnSet.spawnInfos.get(j);
                    if (!(info.rarity >= 0.0f) && info.percentage == null || !info.fits(this, spawnLocation)) continue;
                    suitableSpawns.add(info);
                }
            }
            return suitableSpawns;
        }
        if (!this.cacheSets.containsKey(spawnLocation.biome.getRegistryName())) {
            return Collections.emptyList();
        }
        ArrayList<SpawnInfo> suitableSpawns = new ArrayList<SpawnInfo>();
        List<SpawnInfo> spawnInfos = this.cacheSets.get(spawnLocation.biome.getRegistryName());
        for (int i = 0; i < spawnInfos.size(); ++i) {
            SpawnInfo spawnInfo = spawnInfos.get(i);
            if (!spawnInfo.fits(this, spawnLocation)) continue;
            suitableSpawns.add(spawnInfo);
        }
        return suitableSpawns;
    }

    public boolean fits(SpawnInfo spawnInfo, SpawnLocation spawnLocation) {
        for (int i = 0; i < this.conditions.size(); ++i) {
            SpawnerCondition condition = this.conditions.get(i);
            if (condition.fits(this, spawnInfo, spawnLocation)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public SpawnInfo getWeightedSpawnInfo(SpawnLocation spawnLocation) {
        List<SpawnInfo> suitableSpawns = this.getSuitableSpawns(spawnLocation);
        if (suitableSpawns.isEmpty()) {
            return null;
        }
        return this.selectionAlgorithm.choose(this, spawnLocation, suitableSpawns);
    }

    public SpatialData calculateSpatialData(World world, BlockPos centre, int max, boolean includeDownwards, Predicate<Block> condition) {
        int[] nArray;
        BlockState state = world.func_180495_p(centre);
        if (!condition.test(state.func_177230_c())) {
            return new SpatialData(0, world.func_180495_p(centre.func_177977_b()).func_177230_c(), Sets.newHashSet((Object[])new Block[]{state.func_177230_c()}));
        }
        int r = 1;
        int[] xs = new int[]{-1, 1};
        if (includeDownwards) {
            int[] nArray2 = new int[2];
            nArray2[0] = -1;
            nArray = nArray2;
            nArray2[1] = 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 1;
        }
        int[] ys = nArray;
        int[] zs = new int[]{-1, 1};
        int radius = r;
        block0: while (radius <= max) {
            for (int xMul : xs) {
                for (int zMul : zs) {
                    for (int yMul : ys) {
                        state = world.func_180495_p(centre.func_177982_a(xMul * r, yMul * r, zMul * r));
                        if (condition.test(state.func_177230_c())) continue;
                        r = radius;
                        break block0;
                    }
                }
            }
            r = radius++;
        }
        BlockPos.Mutable pos = new BlockPos.Mutable(0, 0, 0);
        HashSet uniqueSurroundingBlocks = Sets.newHashSet();
        for (int xOffset = -r; xOffset <= r; ++xOffset) {
            for (int yOffset = -r; yOffset <= r; ++yOffset) {
                for (int zOffset = -r; zOffset <= r; ++zOffset) {
                    int x = xOffset + centre.func_177958_n();
                    int y = yOffset + centre.func_177956_o();
                    int z = zOffset + centre.func_177952_p();
                    Block block = world.func_180495_p((BlockPos)pos.func_181079_c(x, y, z)).func_177230_c();
                    uniqueSurroundingBlocks.add(block);
                }
            }
        }
        return new SpatialData(r, world.func_180495_p(centre.func_177977_b()).func_177230_c(), uniqueSurroundingBlocks);
    }

    public CompletableFuture<BlockCollection> getTrackedBlockCollection(Entity entity, float horizontalTrackFactor, float verticalTrackFactor, int horizontalSliceRadius, int verticalSliceRadius, int minDistFromCentre, int maxDistFromCentre) {
        if (entity == null) {
            return CompletableFuture.completedFuture(null);
        }
        if (ServerLifecycleHooks.getCurrentServer().func_213162_bc()) {
            return CompletableFuture.completedFuture(this.getThreadSafeBlockCollection(entity, horizontalTrackFactor, verticalTrackFactor, horizontalSliceRadius, verticalSliceRadius, minDistFromCentre, maxDistFromCentre));
        }
        return CompletableFuture.supplyAsync(() -> this.getThreadSafeBlockCollection(entity, horizontalTrackFactor, verticalTrackFactor, horizontalSliceRadius, verticalSliceRadius, minDistFromCentre, maxDistFromCentre), (Executor)ServerLifecycleHooks.getCurrentServer());
    }

    private BlockCollection getThreadSafeBlockCollection(Entity entity, float horizontalTrackFactor, float verticalTrackFactor, int horizontalSliceRadius, int verticalSliceRadius, int minDistFromCentre, int maxDistFromCentre) {
        BlockPos centre = entity.func_233580_cy_().func_177963_a((double)horizontalTrackFactor * entity.func_213322_ci().field_72450_a, (double)verticalTrackFactor * entity.func_213322_ci().field_72448_b, (double)horizontalTrackFactor * entity.func_213322_ci().field_72449_c);
        float theta = RandomHelper.getRandomNumberBetween(0.0f, (float)Math.PI * 2);
        int r = RandomHelper.getRandomNumberBetween(minDistFromCentre, maxDistFromCentre);
        int xDisplacement = (int)((double)r * Math.cos(theta));
        int zDisplacement = (int)((double)r * Math.sin(theta));
        centre = centre.func_177982_a(xDisplacement, 0, zDisplacement);
        return new BlockCollection(entity, entity.field_70170_p, centre.func_177958_n() - horizontalSliceRadius, centre.func_177958_n() + horizontalSliceRadius, centre.func_177956_o() - verticalSliceRadius, centre.func_177956_o() + verticalSliceRadius, centre.func_177952_p() - horizontalSliceRadius, centre.func_177952_p() + horizontalSliceRadius);
    }

    public boolean hasTweak(Class<? extends SpawningTweak> clazz) {
        return CollectionHelper.containsA(this.tweaks, clazz);
    }

    @Nullable
    public <T extends SpawningTweak> T getTweak(Class<T> clazz) {
        return (T)((SpawningTweak)CollectionHelper.getFirst(this.tweaks, clazz));
    }

    public boolean hasCondition(Class<? extends SpawnerCondition> clazz) {
        return CollectionHelper.containsA(this.conditions, clazz);
    }

    @Nullable
    public <T extends SpawnerCondition> T getCondition(Class<T> clazz) {
        return (T)((SpawnerCondition)CollectionHelper.getFirst(this.conditions, clazz));
    }

    public static class SpawnerBuilder<T extends AbstractSpawner> {
        public HashMap<ResourceLocation, List<SpawnInfo>> cacheMap = new HashMap();
        public List<SpawnSet> spawnSets = new ArrayList<SpawnSet>();
        public SelectionAlgorithm selectionAlgorithm = new LocationWeightedAlgorithm();
        public CheckSpawns checkSpawns = CheckSpawns.getDefault();
        public List<SpawningTweak> tweaks = new ArrayList<SpawningTweak>();
        public List<SpawnerCondition> conditions = new ArrayList<SpawnerCondition>();
        public List<RarityMultiplier> rarityMultipliers = new ArrayList<RarityMultiplier>();

        public <E extends SpawnerBuilder<T>> E addSpawnSets(SpawnSet ... spawnSets) {
            this.spawnSets.addAll(Arrays.asList(spawnSets));
            return (E)((SpawnerBuilder)this.getThis());
        }

        public <E extends SpawnerBuilder<T>> E addSpawnSets(Collection<SpawnSet> spawnSets) {
            this.spawnSets.addAll(spawnSets);
            return (E)((SpawnerBuilder)this.getThis());
        }

        public <E extends SpawnerBuilder<T>> E setSpawnSets(SpawnSet ... spawnSets) {
            this.spawnSets.clear();
            return this.addSpawnSets(spawnSets);
        }

        public <E extends SpawnerBuilder<T>> E setSpawnSets(List<SpawnSet> spawnSets) {
            this.spawnSets = spawnSets;
            return (E)((SpawnerBuilder)this.getThis());
        }

        public <E extends SpawnerBuilder<T>> E setupCache() {
            this.cacheMap.clear();
            for (SpawnSet set : this.spawnSets) {
                for (SpawnInfo info : set) {
                    Set conditionBiomes;
                    ArrayList biomes = Lists.newArrayList((Iterable)ForgeRegistries.BIOMES.getKeys());
                    Set<Object> set2 = conditionBiomes = info.condition != null && info.condition.biomes != null && !info.condition.biomes.isEmpty() ? info.condition.biomes : Collections.emptySet();
                    if (!conditionBiomes.isEmpty()) {
                        biomes = Lists.newArrayList(conditionBiomes);
                    }
                    if (info.condition != null && info.condition.biomes != null && !info.condition.biomes.isEmpty()) {
                        for (ResourceLocation biome : info.condition.biomes) {
                            if (biomes.contains(biome)) continue;
                            biomes.add(biome);
                        }
                    }
                    if (info.compositeCondition != null && info.compositeCondition.conditions != null) {
                        for (SpawnCondition condition : info.compositeCondition.conditions) {
                            if (condition.biomes == null || condition.biomes.isEmpty()) continue;
                            for (ResourceLocation biome : condition.biomes) {
                                if (biomes.contains(biome)) continue;
                                biomes.add(biome);
                            }
                        }
                    }
                    for (ResourceLocation biome : biomes) {
                        this.cacheMap.computeIfAbsent(biome, unused -> Lists.newArrayList()).add(info);
                    }
                }
            }
            return (E)((SpawnerBuilder)this.getThis());
        }

        public <E extends SpawnerBuilder<T>> E setSelectionAlgorithm(SelectionAlgorithm selectionAlgorithm) {
            this.selectionAlgorithm = selectionAlgorithm;
            return (E)((SpawnerBuilder)this.getThis());
        }

        public <E extends SpawnerBuilder<T>> E setCheckSpawns(CheckSpawns checkSpawns) {
            this.checkSpawns = checkSpawns;
            return (E)((SpawnerBuilder)this.getThis());
        }

        public <E extends SpawnerBuilder<T>> E addTweak(SpawningTweak tweak) {
            this.tweaks.add(tweak);
            return (E)((SpawnerBuilder)this.getThis());
        }

        public <E extends SpawnerBuilder<T>> E setTweaks(List<SpawningTweak> tweaks) {
            this.tweaks = tweaks;
            return (E)((SpawnerBuilder)this.getThis());
        }

        public <E extends SpawnerBuilder<T>> E addCondition(SpawnerCondition condition) {
            this.conditions.add(condition);
            return (E)((SpawnerBuilder)this.getThis());
        }

        public <E extends SpawnerBuilder<T>> E setConditions(List<SpawnerCondition> conditions) {
            this.conditions = conditions;
            return (E)((SpawnerBuilder)this.getThis());
        }

        public <E extends SpawnerBuilder<T>> E addRarityMultiplier(RarityMultiplier rarityMultiplier) {
            this.rarityMultipliers.add(rarityMultiplier);
            return (E)((SpawnerBuilder)this.getThis());
        }

        public <E extends SpawnerBuilder<T>> E setRarityMultipliers(List<RarityMultiplier> rarityMultipliers) {
            this.rarityMultipliers = rarityMultipliers;
            return (E)((SpawnerBuilder)this.getThis());
        }

        public T apply(T spawner) {
            ((AbstractSpawner)spawner).spawnSets = this.spawnSets;
            ((AbstractSpawner)spawner).selectionAlgorithm = this.selectionAlgorithm;
            ((AbstractSpawner)spawner).checkSpawns = this.checkSpawns;
            ((AbstractSpawner)spawner).tweaks = new ArrayList<SpawningTweak>(this.tweaks);
            ((AbstractSpawner)spawner).conditions = this.conditions;
            ((AbstractSpawner)spawner).rarityMultipliers = this.rarityMultipliers;
            if (this.cacheMap != null && !this.cacheMap.isEmpty()) {
                ((AbstractSpawner)spawner).cacheSets = this.cacheMap;
            }
            Pixelmon.EVENT_BUS.post((Event)new CreateSpawnerEvent((AbstractSpawner)spawner, this));
            return spawner;
        }

        protected <E> E getThis() {
            return (E)this;
        }
    }
}

