/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.replacement.detection;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.replacement.detection.AbstractDetectionLogic;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import java.util.Set;
import net.minecraft.entity.EntityType;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class SimpleDetectionLogic
extends AbstractDetectionLogic {
    protected Set<EntityType<?>> types = Sets.newHashSet();

    public SimpleDetectionLogic() {
        super("simple");
    }

    public SimpleDetectionLogic(String id) {
        super(id);
    }

    @Override
    public boolean shouldReplaceSpawn(EntityJoinWorldEvent event) {
        return this.types.contains(event.getEntity().func_200600_R());
    }

    @Override
    public void read(Gson context, JsonElement element) {
        JsonObject object = element.getAsJsonObject();
        if (object.has("replaced_mobs")) {
            for (JsonElement replacedMob : object.getAsJsonArray("replaced_mobs")) {
                String asString = replacedMob.getAsString();
                EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(ResourceLocationHelper.of(asString));
                if (entityType != null) {
                    this.types.add(entityType);
                    continue;
                }
                Pixelmon.LOGGER.error("Unknown entity type: `" + asString + "`");
            }
        }
    }
}

