/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.conditions;

import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.conditions.EvoCondition;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.ArrayList;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class PartyCondition
extends EvoCondition {
    public ArrayList<PokemonSpecification> withPokemon = new ArrayList();
    public ArrayList<Element> withTypes = new ArrayList();
    public ArrayList<String> withForms = new ArrayList();
    public ArrayList<String> withPalettes = new ArrayList();

    public PartyCondition() {
        super("party");
    }

    public PartyCondition(PokemonSpecification ... with) {
        this();
        for (PokemonSpecification pokemon : with) {
            if (pokemon == null) continue;
            this.withPokemon.add(pokemon);
        }
    }

    public PartyCondition(Element ... types) {
        this();
        for (Element type : types) {
            if (types == null) continue;
            this.withTypes.add(type);
        }
    }

    public PartyCondition(String ... forms) {
        this();
        for (String form : forms) {
            this.withForms.add(form.toLowerCase(Locale.ROOT));
        }
        for (String palette : forms) {
            this.withPalettes.add(palette.toLowerCase(Locale.ROOT));
        }
    }

    @Override
    public boolean passes(PixelmonEntity pixelmon) {
        block7: {
            PlayerPartyStorage storage = pixelmon.getPlayerParty();
            if (storage == null) break block7;
            for (Pokemon pokemon : storage.getTeam()) {
                block9: {
                    block8: {
                        Species partyPokemon = pokemon.getSpecies();
                        for (PokemonSpecification spec : this.withPokemon) {
                            if (!spec.create(true).isPokemon(partyPokemon)) continue;
                            return true;
                        }
                        Stats bs = pokemon.getForm();
                        if (partyPokemon != null && (this.withTypes.contains(bs.getTypes().get(0)) || bs.getTypes().size() > 1 && this.withTypes.contains(bs.getTypes().get(1)))) {
                            return true;
                        }
                        if (this.withForms.stream().anyMatch(pokemon.getForm().getLocalizedName()::equalsIgnoreCase)) break block8;
                        if (!this.withForms.stream().anyMatch(pokemon.getForm().getName()::equalsIgnoreCase)) break block9;
                    }
                    return true;
                }
                for (String palette : this.withPalettes) {
                    if (!pokemon.getPalette().is(palette)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public IFormattableTextComponent getDescription() {
        if (!this.withPokemon.isEmpty()) {
            IFormattableTextComponent pokeNames = TextHelper.join(this.withPokemon.stream().map(s -> s.create().getTranslatedName()).collect(Collectors.toList()), (ITextComponent)TextHelper.OR_DELIMITER);
            return PixelmonCommandUtils.format("pixelmon.evolution.conditions.party.pokemon", pokeNames);
        }
        if (!this.withTypes.isEmpty()) {
            IFormattableTextComponent types = TextHelper.join(this.withTypes.stream().map(ITranslatable::getTranslatedName).collect(Collectors.toList()), (ITextComponent)TextHelper.OR_DELIMITER);
            return PixelmonCommandUtils.format("pixelmon.evolution.conditions.party.types", types);
        }
        if (!this.withForms.isEmpty()) {
            IFormattableTextComponent forms = TextHelper.joinStrings(this.withForms, TextHelper.OR_DELIMITER);
            return PixelmonCommandUtils.format("pixelmon.evolution.conditions.party.forms", forms);
        }
        if (!this.withPalettes.isEmpty()) {
            IFormattableTextComponent forms = TextHelper.joinStrings(this.withPalettes, TextHelper.OR_DELIMITER);
            return PixelmonCommandUtils.format("pixelmon.evolution.conditions.party.forms", forms);
        }
        return new StringTextComponent("");
    }
}

