/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.stats;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.HyperTrainEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.IStatStore;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.BitSet;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.eventbus.api.Event;

public class IVStore
implements IStatStore {
    public static final int MAX_IVS = 31;
    private Pokemon pokemon = null;
    private int hp = -1;
    private int attack = -1;
    private int defense = -1;
    private int specialAttack = -1;
    private int specialDefense = -1;
    private int speed = -1;
    private BitSet hyperTrained = new BitSet(6);

    public IVStore() {
    }

    public IVStore(int ... ivs) {
        this.hp = ivs[0];
        this.attack = ivs[1];
        this.defense = ivs[2];
        this.specialAttack = ivs[3];
        this.specialDefense = ivs[4];
        this.speed = ivs[5];
    }

    public IVStore withPokemon(Pokemon pokemon) {
        this.pokemon = pokemon;
        return this;
    }

    @Override
    public int getStat(BattleStatsType type) {
        switch (type) {
            case ATTACK: {
                return this.attack;
            }
            case DEFENSE: {
                return this.defense;
            }
            case HP: {
                return this.hp;
            }
            case SPECIAL_ATTACK: {
                return this.specialAttack;
            }
            case SPECIAL_DEFENSE: {
                return this.specialDefense;
            }
            case SPEED: {
                return this.speed;
            }
        }
        return -1;
    }

    @Override
    public void setStat(BattleStatsType type, int value) {
        value = MathHelper.func_76125_a((int)value, (int)0, (int)31);
        switch (type) {
            case ATTACK: {
                this.attack = value;
                break;
            }
            case DEFENSE: {
                this.defense = value;
                break;
            }
            case HP: {
                this.hp = value;
                break;
            }
            case SPECIAL_ATTACK: {
                this.specialAttack = value;
                break;
            }
            case SPECIAL_DEFENSE: {
                this.specialDefense = value;
                break;
            }
            case SPEED: {
                this.speed = value;
                break;
            }
            default: {
                return;
            }
        }
        if (this.pokemon != null) {
            this.pokemon.getStats().recalculateStats();
        }
        this.markDirty();
    }

    public void markDirty() {
        if (this.pokemon != null) {
            this.pokemon.markDirty(EnumUpdateType.IVs, EnumUpdateType.Stats);
        }
    }

    public static IVStore createRandomNewIVs() {
        IVStore iv = new IVStore();
        iv.specialDefense = RandomHelper.getRandomNumberBetween(0, 31);
        iv.specialAttack = RandomHelper.getRandomNumberBetween(0, 31);
        iv.speed = RandomHelper.getRandomNumberBetween(0, 31);
        iv.defense = RandomHelper.getRandomNumberBetween(0, 31);
        iv.attack = RandomHelper.getRandomNumberBetween(0, 31);
        iv.hp = RandomHelper.getRandomNumberBetween(0, 31);
        return iv;
    }

    public static IVStore createNewIVs3Perfect() {
        int[] ivs = new int[6];
        int[] maxIVs = RandomHelper.getRandomDistinctNumbersBetween(0, 5, 3);
        Arrays.sort(maxIVs);
        int maxIVCounter = 0;
        for (int i = 0; i < 6; ++i) {
            if (maxIVs[maxIVCounter] == i) {
                ivs[i] = 31;
                if (maxIVCounter >= maxIVs.length - 1) continue;
                ++maxIVCounter;
                continue;
            }
            ivs[i] = RandomHelper.getRandomNumberBetween(0, 31);
        }
        return new IVStore(ivs);
    }

    public boolean hasAnyIVBeenSet() {
        for (int value : this.getArray()) {
            if (value == -1) continue;
            return true;
        }
        return false;
    }

    public void clearUnsetIVs() {
        if (this.hp == -1) {
            this.hp = 0;
        }
        if (this.attack == -1) {
            this.attack = 0;
        }
        if (this.defense == -1) {
            this.defense = 0;
        }
        if (this.specialAttack == -1) {
            this.specialAttack = 0;
        }
        if (this.specialDefense == -1) {
            this.specialDefense = 0;
        }
        if (this.speed == -1) {
            this.speed = 0;
        }
    }

    public void writeToNBT(CompoundNBT nbt) {
        nbt.func_74774_a("IVHP", (byte)this.hp);
        nbt.func_74774_a("IVAttack", (byte)this.attack);
        nbt.func_74774_a("IVDefense", (byte)this.defense);
        nbt.func_74774_a("IVSpAtt", (byte)this.specialAttack);
        nbt.func_74774_a("IVSpDef", (byte)this.specialDefense);
        nbt.func_74774_a("IVSpeed", (byte)this.speed);
        BattleStatsType[] values = BattleStatsType.getEVIVStatValues();
        for (int i = 0; i < 6; ++i) {
            if (!this.hyperTrained.get(i)) continue;
            nbt.func_74757_a("IV_HT" + values[i].name(), true);
        }
    }

    public void readFromNBT(CompoundNBT nbt) {
        this.hp = nbt.func_74771_c("IVHP");
        this.attack = nbt.func_74771_c("IVAttack");
        this.defense = nbt.func_74771_c("IVDefense");
        this.specialAttack = nbt.func_74771_c("IVSpAtt");
        this.specialDefense = nbt.func_74771_c("IVSpDef");
        this.speed = nbt.func_74771_c("IVSpeed");
        BattleStatsType[] values = BattleStatsType.getEVIVStatValues();
        for (int i = 0; i < 6; ++i) {
            if (nbt.func_74767_n("IV_HT" + values[i].name())) {
                this.hyperTrained.set(i);
                continue;
            }
            this.hyperTrained.set(i, false);
        }
    }

    public void writeToByteBuffer(ByteBuf buf) {
        buf.writeByte(this.hp);
        buf.writeByte(this.attack);
        buf.writeByte(this.defense);
        buf.writeByte(this.specialAttack);
        buf.writeByte(this.specialDefense);
        buf.writeByte(this.speed);
        byte[] arr = this.hyperTrained.toByteArray();
        buf.writeByte(arr.length == 0 ? 0 : arr[0]);
    }

    public IVStore readFromByteBuffer(ByteBuf buf) {
        this.hp = buf.readByte();
        this.attack = buf.readByte();
        this.defense = buf.readByte();
        this.specialAttack = buf.readByte();
        this.specialDefense = buf.readByte();
        this.speed = buf.readByte();
        byte b = buf.readByte();
        this.hyperTrained = BitSet.valueOf(new byte[]{b});
        return this;
    }

    public double getPercentage(int decimalPlaces) {
        int total = 0;
        for (int value : this.getArray()) {
            total += value;
        }
        double percentage = (double)total / 186.0 * 100.0;
        return Math.floor(percentage * Math.pow(10.0, decimalPlaces)) / Math.pow(10.0, decimalPlaces);
    }

    public String getPercentageString(int decimalPlaces) {
        return String.format("%." + decimalPlaces + "f", this.getPercentage(decimalPlaces));
    }

    public String getShorthand(String separator) {
        return this.getStat(BattleStatsType.HP) + separator + this.getStat(BattleStatsType.ATTACK) + separator + this.getStat(BattleStatsType.DEFENSE) + separator + this.getStat(BattleStatsType.SPECIAL_ATTACK) + separator + this.getStat(BattleStatsType.SPECIAL_DEFENSE) + separator + this.getStat(BattleStatsType.SPEED);
    }

    public void copyIVs(IVStore ivs) {
        this.hp = ivs.hp;
        this.attack = ivs.attack;
        this.defense = ivs.defense;
        this.specialAttack = ivs.specialAttack;
        this.specialDefense = ivs.specialDefense;
        this.speed = ivs.speed;
    }

    public int[] getArray() {
        return new int[]{this.hp, this.attack, this.defense, this.specialAttack, this.specialDefense, this.speed};
    }

    public void maximizeIVs() {
        this.speed = 31;
        this.specialDefense = 31;
        this.specialAttack = 31;
        this.defense = 31;
        this.attack = 31;
        this.hp = 31;
        this.pokemon.getStats().recalculateStats();
        this.markDirty();
    }

    public void setHyperTrained(BattleStatsType stat, boolean hyperTrained) {
        if (!Pixelmon.EVENT_BUS.post((Event)new HyperTrainEvent(stat, hyperTrained, this.pokemon))) {
            if (stat == null) {
                this.hyperTrained.set(0, hyperTrained);
                this.hyperTrained.set(1, hyperTrained);
                this.hyperTrained.set(2, hyperTrained);
                this.hyperTrained.set(3, hyperTrained);
                this.hyperTrained.set(4, hyperTrained);
                this.hyperTrained.set(5, hyperTrained);
            } else {
                switch (stat) {
                    case HP: {
                        this.hyperTrained.set(0, hyperTrained);
                        break;
                    }
                    case ATTACK: {
                        this.hyperTrained.set(1, hyperTrained);
                        break;
                    }
                    case DEFENSE: {
                        this.hyperTrained.set(2, hyperTrained);
                        break;
                    }
                    case SPECIAL_ATTACK: {
                        this.hyperTrained.set(3, hyperTrained);
                        break;
                    }
                    case SPECIAL_DEFENSE: {
                        this.hyperTrained.set(4, hyperTrained);
                        break;
                    }
                    case SPEED: {
                        this.hyperTrained.set(5, hyperTrained);
                        break;
                    }
                }
            }
        }
    }

    public boolean isHyperTrained(BattleStatsType stat) {
        switch (stat) {
            case HP: {
                return this.hyperTrained.get(0);
            }
            case ATTACK: {
                return this.hyperTrained.get(1);
            }
            case DEFENSE: {
                return this.hyperTrained.get(2);
            }
            case SPECIAL_ATTACK: {
                return this.hyperTrained.get(3);
            }
            case SPECIAL_DEFENSE: {
                return this.hyperTrained.get(4);
            }
            case SPEED: {
                return this.hyperTrained.get(5);
            }
        }
        return false;
    }

    public void fillFromArray(int ... ivs) {
        if (ivs.length < 6) {
            return;
        }
        this.hp = ivs[0];
        this.attack = ivs[1];
        this.defense = ivs[2];
        this.specialAttack = ivs[3];
        this.specialDefense = ivs[4];
        this.speed = ivs[5];
        this.markDirty();
    }
}

