/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator;

import com.mojang.datafixers.util.Pair;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.ModelPredicate;
import com.pixelmonmod.pixelmon.api.util.ResourceWithFallback;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.models.ModelFactoryFactory;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelHolder;
import com.pixelmonmod.pixelmon.client.models.PixelmonSmdFactory;
import java.util.List;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModelLocator {
    private final ModelFactoryFactory factoryType;
    private final List<Pair<String, String>> pqc;
    private float xRotation = 0.0f;
    private float yRotation = 24.0f;
    private float zRotation = 0.0f;
    private float rotateAngleX = -1.5707964f;
    private float rotateAngleY = 0.0f;
    private float movementThreshold = 0.3f;
    private float animationIncrement = 1.0f;
    private float xOffset = 0.0f;
    private float yOffset = 0.0f;
    private float zOffset = 0.0f;
    private float transparency = 0.0f;
    private float transparency2 = 0.0f;
    private transient ResourceWithFallback[] pqcRL;
    @OnlyIn(value=Dist.CLIENT)
    private transient PixelmonModelHolder<?> modelHolder;
    private ModelPredicate predicate;

    public ModelLocator(ModelFactoryFactory factoryType, ModelPredicate predicate, List<Pair<String, String>> pqc) {
        this.factoryType = factoryType;
        this.predicate = predicate;
        this.pqc = pqc;
    }

    public void init() {
        this.pqcRL = new ResourceWithFallback[this.pqc.size()];
        for (int i = 0; i < this.pqc.size(); ++i) {
            this.pqcRL[i] = ResourceWithFallback.from(ResourceLocationHelper.of((String)this.pqc.get(i).getFirst()), ResourceLocationHelper.of((String)this.pqc.get(i).getSecond())).ensureTexture();
        }
        this.modelHolder = new PixelmonModelHolder(this.getFactory());
    }

    public ModelFactoryFactory getFactoryType() {
        return this.factoryType;
    }

    @OnlyIn(value=Dist.CLIENT)
    public PixelmonModelHolder<?> getModel() {
        if (this.modelHolder == null) {
            this.init();
        }
        return this.modelHolder;
    }

    public List<Pair<String, String>> getPQCs() {
        return this.pqc;
    }

    public PixelmonSmdFactory getFactory() {
        return this.factoryType.get(this.pqcRL).setValues(this.xRotation, this.yRotation, this.zRotation, this.rotateAngleX, this.rotateAngleY, this.movementThreshold, this.animationIncrement, this.xOffset, this.yOffset, this.zOffset, this.transparency, this.transparency2);
    }

    public void setXRotation(float xRotation) {
        this.xRotation = xRotation;
    }

    public void setYRotation(float yRotation) {
        this.yRotation = yRotation;
    }

    public void setZRotation(float zRotation) {
        this.zRotation = zRotation;
    }

    public void setRotateAngleX(float rotateAngleX) {
        this.rotateAngleX = rotateAngleX;
    }

    public void setRotateAngleY(float rotateAngleY) {
        this.rotateAngleY = rotateAngleY;
    }

    public void setMovementThreshold(float movementThreshold) {
        this.movementThreshold = movementThreshold;
    }

    public void setAnimationIncrement(float animationIncrement) {
        this.animationIncrement = animationIncrement;
    }

    public void setXOffset(float xOffset) {
        this.xOffset = xOffset;
    }

    public void setYOffset(float yOffset) {
        this.yOffset = yOffset;
    }

    public void setZOffset(float zOffset) {
        this.zOffset = zOffset;
    }

    public void setTransparency(float transparency) {
        this.transparency = transparency;
    }

    public void setTransparency2(float transparency2) {
        this.transparency2 = transparency2;
    }

    public ModelPredicate getPredicate() {
        return this.predicate;
    }

    public void setPredicate(ModelPredicate predicate) {
        this.predicate = predicate;
    }

    public boolean usingFallback() {
        for (ResourceWithFallback resourceWithFallback : this.pqcRL) {
            if (!resourceWithFallback.usingFallback()) continue;
            return true;
        }
        return false;
    }
}

