/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.species.palette;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.pixelmonmod.pixelmon.api.pokemon.species.DataCopier;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.ModelLocator;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.type.FlyingModelPredicate;
import com.pixelmonmod.pixelmon.api.util.ResourceWithFallback;
import com.pixelmonmod.pixelmon.client.particle.ParticleSystems;
import com.pixelmonmod.pixelmon.entities.pixelmon.particleEffects.PaletteParticles;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class PalettePropertiesTypeAdapter
implements JsonSerializer<PaletteProperties>,
JsonDeserializer<PaletteProperties> {
    public PaletteProperties deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        PaletteProperties palette = DataCopier.getPalette().map(PaletteProperties::clone).orElse(new PaletteProperties());
        palette.name = object.get("name").getAsString();
        palette.translationKey = object.has("translationKey") ? object.get("translationKey").getAsString() : "";
        if (object.has("modelLocator")) {
            palette.modelLocators = new ModelLocator[]{(ModelLocator)context.deserialize(object.get("modelLocator"), ModelLocator.class)};
        }
        if (object.has("modelLocators")) {
            palette.modelLocators = (ModelLocator[])context.deserialize(object.get("modelLocators"), ModelLocator[].class);
        }
        if (object.has("flyingModelLocator")) {
            ModelLocator modelLocator = (ModelLocator)context.deserialize(object.get("flyingModelLocator"), ModelLocator.class);
            modelLocator.setPredicate(new FlyingModelPredicate(10));
            ArrayList modelLocators = Lists.newArrayList((Object[])new ModelLocator[]{modelLocator});
            modelLocators.addAll(Arrays.asList(palette.modelLocators));
            palette.modelLocators = modelLocators.toArray(new ModelLocator[0]);
        }
        if (palette.modelLocators == null || palette.modelLocators.length == 0) {
            System.out.println("NULL MODEL LOCATOR " + palette.name + " " + DataCopier.getForm().get().getName());
        }
        if (object.has("sprite")) {
            palette.setSprite((ResourceWithFallback)context.deserialize(object.get("sprite"), ResourceWithFallback.class));
        }
        if (object.has("texture")) {
            palette.setTexture((ResourceWithFallback)context.deserialize(object.get("texture"), ResourceWithFallback.class));
        }
        if (object.has("emissive")) {
            palette.setEmissive((ResourceWithFallback)context.deserialize(object.get("emissive"), ResourceWithFallback.class));
        }
        if (object.has("particle")) {
            ParticleType type;
            ParticleSystems system;
            ResourceLocation particleLocation = (ResourceLocation)context.deserialize(object.get("particle"), ResourceLocation.class);
            PaletteParticles particles = particleLocation.func_110624_b().equalsIgnoreCase("arcanery") ? ((system = ParticleSystems.get(particleLocation)) != null ? new PaletteParticles(system) : null) : ((type = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(particleLocation)) != null ? new PaletteParticles(type) : null);
            palette.particle = particles;
        }
        if (object.has("sounds")) {
            palette.resetSounds();
            for (JsonElement sounds : object.get("sounds").getAsJsonArray()) {
                palette.addSound(SoundRegistration.get(sounds.getAsString()));
            }
        }
        DataCopier.setPalette(palette);
        return palette;
    }

    public JsonElement serialize(PaletteProperties src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        object.addProperty("name", src.getName());
        object.addProperty("translationKey", src.getTranslationKey());
        object.add("modelLocators", context.serialize((Object)src.getModelLocators()));
        object.add("sprite", context.serialize((Object)src.sprite));
        object.add("texture", context.serialize((Object)src.texture));
        object.addProperty("particle", src.getParticleString());
        return object;
    }
}

