/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.species.gender;

import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.GenderProperties;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import java.util.Locale;

public enum Gender implements ITranslatable
{
    MALE,
    FEMALE,
    NONE;

    private static final Gender[] VALUES;

    public boolean hasPalette(Stats stats, String palette) {
        if (stats == null) {
            return false;
        }
        GenderProperties genderProperties = stats.getGenderProperties(this);
        return genderProperties != null && genderProperties.getPalette(palette) != null;
    }

    @Override
    public String getTranslationKey() {
        return "pixelmon.gender.form." + this.name().toLowerCase(Locale.ROOT);
    }

    public boolean isCompatible(Gender otherGender) {
        return this == MALE && otherGender == FEMALE || this == FEMALE && otherGender == MALE;
    }

    public static Gender getGender(short ord) {
        if (ord >= VALUES.length || ord < 0) {
            return MALE;
        }
        return VALUES[ord];
    }

    public static Gender getGender(String name) {
        for (Gender gender : Gender.values()) {
            if (!gender.name().toLowerCase(Locale.ROOT).startsWith(name.toLowerCase(Locale.ROOT))) continue;
            return gender;
        }
        return null;
    }

    public static Gender getRandomGender(Stats baseStats) {
        if (baseStats.getMalePercentage() < 0.0f) {
            return NONE;
        }
        if (RandomHelper.rand.nextDouble() * 100.0 < (double)baseStats.getMalePercentage()) {
            return MALE;
        }
        return FEMALE;
    }

    static {
        VALUES = Gender.values();
    }
}

