/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.species.abilities;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public class Abilities {
    private final Ability[] abilities;
    private final Ability[] hiddenAbilities;

    public Abilities(Ability[] abilities, Ability[] hiddenAbilities) {
        this.abilities = abilities;
        this.hiddenAbilities = hiddenAbilities;
    }

    public Ability[] getAbilities() {
        return Arrays.copyOf(this.abilities, this.abilities.length);
    }

    public Ability[] getHiddenAbilities() {
        return Arrays.copyOf(this.hiddenAbilities, this.hiddenAbilities.length);
    }

    public boolean hasHiddenAbilities() {
        return this.hiddenAbilities.length > 0;
    }

    public Ability[] getAll() {
        ArrayList abilities = Lists.newArrayList((Object[])this.abilities);
        abilities.addAll(Lists.newArrayList((Object[])this.hiddenAbilities));
        return abilities.toArray(new Ability[0]);
    }

    public Ability getRandomAbility() {
        return this.getRandomAbilityExcluding(new Ability[0]);
    }

    public Ability getRandomAbilityExcluding(Ability ... excluding) {
        return RandomHelper.getRandomElementExcluding(this.abilities, excluding);
    }

    public Ability getRandomHiddenAbility() {
        return this.getRandomHiddenAbilityExcluding(new Ability[0]);
    }

    public Ability getRandomHiddenAbilityExcluding(Ability ... excluding) {
        return RandomHelper.getRandomElementExcluding(this.hiddenAbilities, excluding);
    }

    public int getAbilitySlot(Ability check) {
        int counter = 0;
        for (Ability ability : this.abilities) {
            if (Objects.equals(ability, check)) {
                return counter;
            }
            ++counter;
        }
        return -1;
    }

    public int getHiddenAbilitySlot(Ability check) {
        int counter = 0;
        for (Ability ability : this.hiddenAbilities) {
            if (Objects.equals(ability, check)) {
                return counter;
            }
            ++counter;
        }
        return -1;
    }

    public Ability resolveAbility(int slot, boolean hidden) {
        Ability ability;
        if (hidden) {
            ability = slot >= 0 && slot < this.hiddenAbilities.length ? this.hiddenAbilities[slot] : this.getRandomHiddenAbility();
            if (ability == null) {
                ability = this.getRandomAbility();
            }
        } else {
            ability = slot >= 0 && slot < this.abilities.length ? this.abilities[slot] : this.getRandomAbility();
        }
        return ability;
    }

    public Ability resolveFromOldStyleSlot(int slot) {
        if (slot == 2) {
            return this.getRandomHiddenAbility();
        }
        if (slot == 0 || slot == 1) {
            return this.resolveAbility(slot, false);
        }
        return this.getRandomAbility();
    }

    public boolean isAbility(Ability ... abilities) {
        for (Ability a : this.abilities) {
            for (Ability b : abilities) {
                if (!Objects.equals(a, b)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isHiddenAbility(Ability ... abilities) {
        for (Ability a : this.hiddenAbilities) {
            for (Ability b : abilities) {
                if (!Objects.equals(a, b)) continue;
                return true;
            }
        }
        return false;
    }

    public Ability transferAbility(Stats form, Ability ability) {
        Abilities other = form.getAbilities();
        int slot = other.getAbilitySlot(ability);
        int haSlot = other.getHiddenAbilitySlot(ability);
        if (haSlot != -1) {
            return this.resolveAbility(haSlot, true);
        }
        if (slot != -1) {
            return this.resolveAbility(slot, false);
        }
        return this.getRandomAbility();
    }

    public Ability getAbilityByName(String name) {
        for (Ability ability : this.getAll()) {
            if (!ability.getName().equalsIgnoreCase(name)) continue;
            return ability;
        }
        return null;
    }
}

