/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.species;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ExperienceGroup;
import com.pixelmonmod.pixelmon.api.pokemon.species.DataCopier;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.abilities.Abilities;
import com.pixelmonmod.pixelmon.api.pokemon.species.aggression.AggressionChances;
import com.pixelmonmod.pixelmon.api.pokemon.species.dimensions.Dimensions;
import com.pixelmonmod.pixelmon.api.pokemon.species.evs.EVYields;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.GenderProperties;
import com.pixelmonmod.pixelmon.api.pokemon.species.gimmick.Gigantamax;
import com.pixelmonmod.pixelmon.api.pokemon.species.moves.Moves;
import com.pixelmonmod.pixelmon.api.pokemon.species.parameters.Movement;
import com.pixelmonmod.pixelmon.api.pokemon.species.spawn.SpawnData;
import com.pixelmonmod.pixelmon.api.pokemon.species.stat.ImmutableBattleStats;
import com.pixelmonmod.pixelmon.api.pokemon.species.tags.FormTags;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.Evolution;
import com.pixelmonmod.pixelmon.api.registries.EggGroupRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.JsonHelper;
import java.lang.reflect.Type;
import java.util.Locale;

public class StatsTypeAdapter
implements JsonSerializer<Stats>,
JsonDeserializer<Stats> {
    public Stats deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        Stats stats = DataCopier.getForm().map(Stats::clone).orElse(new Stats());
        if (object.has("name") && !object.get("name").isJsonNull()) {
            stats.name = object.get("name").getAsString();
        }
        if (object.has("experienceGroup")) {
            stats.experienceGroup = ExperienceGroup.valueOf(object.get("experienceGroup").getAsString());
        }
        if (object.has("dimensions")) {
            stats.dimensions = (Dimensions)context.deserialize(object.get("dimensions"), Dimensions.class);
        }
        if (object.has("moves")) {
            stats.moves = (Moves)context.deserialize(object.get("moves"), Moves.class);
        }
        if (object.has("abilities")) {
            stats.abilities = (Abilities)context.deserialize(object.get("abilities"), Abilities.class);
        }
        if (object.has("movement")) {
            stats.movement = (Movement)context.deserialize(object.get("movement"), Movement.class);
        }
        if (object.has("aggression")) {
            stats.aggression = (AggressionChances)context.deserialize(object.get("aggression"), AggressionChances.class);
        }
        if (object.has("battleStats")) {
            stats.battleStats = (ImmutableBattleStats)context.deserialize(object.get("battleStats"), ImmutableBattleStats.class);
        }
        if (object.has("tags")) {
            stats.tags = (FormTags)context.deserialize(object.get("tags"), FormTags.class);
        }
        if (object.has("spawn")) {
            stats.spawn = (SpawnData)context.deserialize(object.get("spawn"), SpawnData.class);
        }
        if (object.has("possibleGenders")) {
            stats.possibleGenders = JsonHelper.deserializeList(object.getAsJsonArray("possibleGenders"), elem -> Gender.valueOf(elem.getAsString()));
        }
        if (object.has("genderProperties")) {
            stats.genderProperties = JsonHelper.deserializeList(object.getAsJsonArray("genderProperties"), elem -> (GenderProperties)context.deserialize(elem, GenderProperties.class));
        }
        if (object.has("eggGroups")) {
            stats.eggGroups = JsonHelper.deserializeList(object.getAsJsonArray("eggGroups"), elem -> EggGroupRegistry.getEggGroup(elem.getAsString()).orElse(null));
        }
        if (object.has("types")) {
            stats.types = JsonHelper.deserializeList(object.getAsJsonArray("types"), elem -> Element.valueOf(elem.getAsString()));
        }
        if (object.has("evolutions")) {
            stats.evolutions = JsonHelper.deserializeList(object.getAsJsonArray("evolutions"), elem -> (Evolution)context.deserialize(elem, Evolution.class));
        }
        if (object.has("preEvolutions")) {
            stats.preEvolutions = JsonHelper.deserializeList(object.getAsJsonArray("preEvolutions"), elem -> PixelmonSpecies.fromName(elem.getAsString()));
        }
        if (object.has("defaultBaseForm")) {
            stats.defaultBaseForm = object.get("defaultBaseForm").getAsString();
        }
        if (object.has("megaItems")) {
            stats.megaItems = JsonHelper.deserializeList(object.getAsJsonArray("megaItems"), JsonElement::getAsString);
        }
        if (object.has("megas")) {
            stats.megas = JsonHelper.deserializeList(object.getAsJsonArray("megas"), JsonElement::getAsString);
        }
        stats.gigantamax = object.has("gigantamax") ? (Gigantamax)context.deserialize(object.get("gigantamax"), Gigantamax.class) : new Gigantamax();
        if (object.has("eggCycles")) {
            stats.eggCycles = object.get("eggCycles").getAsInt();
        }
        if (object.has("weight")) {
            stats.weight = object.get("weight").getAsFloat();
        }
        if (object.has("catchRate")) {
            stats.catchRate = object.get("catchRate").getAsInt();
        }
        if (object.has("malePercentage")) {
            stats.malePercentage = object.get("malePercentage").getAsFloat();
        }
        if (object.has("evYields")) {
            stats.evYields = (EVYields)context.deserialize(object.get("evYields"), EVYields.class);
        }
        DataCopier.setForm(stats);
        return stats;
    }

    public JsonElement serialize(Stats stats, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        object.addProperty("name", stats.name);
        object.addProperty("translationKey", stats.translationKey);
        object.addProperty("experienceGroup", stats.experienceGroup.name());
        object.add("dimensions", context.serialize((Object)stats.dimensions));
        object.add("moves", context.serialize((Object)stats.moves));
        object.add("abilities", context.serialize((Object)stats.abilities));
        object.add("movement", context.serialize((Object)stats.movement));
        object.add("aggression", context.serialize((Object)stats.aggression));
        object.add("battleStats", context.serialize((Object)stats.battleStats));
        object.add("tags", context.serialize((Object)stats.tags));
        object.add("spawn", context.serialize((Object)stats.spawn));
        object.add("possibleGenders", (JsonElement)JsonHelper.serializeList(stats.possibleGenders, elem -> new JsonPrimitive(elem.name())));
        object.add("genderProperties", (JsonElement)JsonHelper.serializeList(stats.genderProperties, arg_0 -> ((JsonSerializationContext)context).serialize(arg_0)));
        object.add("eggGroups", (JsonElement)JsonHelper.serializeList(stats.eggGroups, elem -> new JsonPrimitive(elem.getKey().toLowerCase(Locale.ROOT))));
        object.add("types", (JsonElement)JsonHelper.serializeList(stats.types, elem -> new JsonPrimitive(elem.name())));
        object.add("evolutions", (JsonElement)JsonHelper.serializeList(stats.evolutions, arg_0 -> ((JsonSerializationContext)context).serialize(arg_0)));
        object.add("preEvolutions", (JsonElement)JsonHelper.serializeList(stats.preEvolutions, elem -> new JsonPrimitive(elem.toString())));
        object.addProperty("defaultBaseForm", stats.defaultBaseForm);
        object.add("megaItems", (JsonElement)JsonHelper.serializeList(stats.megaItems, JsonPrimitive::new));
        object.add("megas", (JsonElement)JsonHelper.serializeList(stats.megas, JsonPrimitive::new));
        object.add("gigantamax", context.serialize((Object)stats.gigantamax));
        object.addProperty("eggCycles", (Number)stats.eggCycles);
        object.addProperty("weight", (Number)Float.valueOf(stats.weight));
        object.addProperty("catchRate", (Number)stats.catchRate);
        object.addProperty("malePercentage", (Number)Float.valueOf(stats.malePercentage));
        return object;
    }
}

