/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ribbon;

import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.MutableRibbonData;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.RibbonRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.type.RibbonType;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Objects;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class Ribbon {
    protected final String type;
    protected final long receivedDate;
    protected final ITextComponent receiver;
    protected MutableRibbonData ribbonData;

    public Ribbon(String type, long receivedDate, ITextComponent receiver) {
        this.type = type;
        this.receivedDate = receivedDate;
        this.receiver = receiver;
    }

    public Ribbon(String type, long receivedDate, ITextComponent receiver, MutableRibbonData ribbonData) {
        this.type = type;
        this.receivedDate = receivedDate;
        this.receiver = receiver;
        this.ribbonData = ribbonData;
    }

    public RegistryValue<RibbonType> getType() {
        return RibbonRegistry.getRibbon(this.type);
    }

    public long getReceivedDate() {
        return this.receivedDate;
    }

    public ITextComponent getReceiver() {
        return this.receiver;
    }

    public MutableRibbonData getRibbonData() {
        return this.ribbonData;
    }

    public void refreshData(PixelmonEntity entity) {
        this.ribbonData = MutableRibbonData.fromType(this.getType().getValueUnsafe(), entity, this);
        entity.getPokemon().markDirty(EnumUpdateType.Ribbons);
    }

    public CompoundNBT serialize() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("type", (INBT)StringNBT.func_229705_a_((String)this.type));
        nbt.func_218657_a("received", (INBT)LongNBT.func_229698_a_((long)this.receivedDate));
        nbt.func_218657_a("receiver", (INBT)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)this.receiver)));
        return nbt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Ribbon)) {
            return false;
        }
        Ribbon ribbon = (Ribbon)o;
        return this.getReceivedDate() == ribbon.getReceivedDate() && Objects.equals(this.type, ribbon.type) && Objects.equals(this.getReceiver(), ribbon.getReceiver());
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.getReceivedDate(), this.getReceiver(), this.getRibbonData());
    }

    public static Ribbon fromNbt(CompoundNBT nbt) {
        return Ribbon.builder().type(RibbonRegistry.getRibbon(nbt.func_74779_i("type")).getValueUnsafe()).receivedDate(nbt.func_74763_f("received")).receiver((ITextComponent)ITextComponent.Serializer.func_240643_a_((String)nbt.func_74779_i("receiver"))).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Ribbon ribbon) {
        return new Builder().type(ribbon.type).receivedDate(ribbon.receivedDate).receiver(ribbon.receiver);
    }

    public static class Builder {
        protected String type;
        protected long receivedDate;
        protected ITextComponent receiver;
        protected MutableRibbonData ribbonData;

        protected Builder() {
        }

        public Builder type(RibbonType type) {
            this.type = type.id();
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder receivedDate(long receivedDate) {
            this.receivedDate = receivedDate;
            return this;
        }

        public Builder receiver(ServerPlayerEntity player) {
            if (player == null) {
                this.receiver = StringTextComponent.field_240750_d_;
                return this;
            }
            this.receiver = player.func_200200_C_();
            return this;
        }

        public Builder receiver(ITextComponent receiver) {
            this.receiver = receiver;
            return this;
        }

        public Builder ribbonData(MutableRibbonData ribbonData) {
            this.ribbonData = ribbonData;
            return this;
        }

        public Ribbon build() {
            if (this.ribbonData != null) {
                return new Ribbon(this.type, this.receivedDate, this.receiver, this.ribbonData);
            }
            return new Ribbon(this.type, this.receivedDate, this.receiver);
        }
    }
}

