/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.export;

import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.api.pokemon.export.PokemonConverterProxy;
import com.pixelmonmod.pixelmon.api.pokemon.export.impl.ShowdownConverter;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class PokemonConverterRegistry {
    private static final Map<String, PokemonConverterProxy> REGISTERED_TYPES = Maps.newHashMap();
    private static PokemonConverterProxy DEFAULT = null;
    public static final PokemonConverterProxy SHOWDOWN_CONVERTER = PokemonConverterRegistry.registerConverter("showdown", new ShowdownConverter());

    public static <T extends PokemonConverterProxy> T registerConverter(String id, T proxy) {
        REGISTERED_TYPES.put(id.toLowerCase(Locale.ROOT), proxy);
        return proxy;
    }

    public static Optional<PokemonConverterProxy> getConverter(String id) {
        return Optional.ofNullable(REGISTERED_TYPES.get(id.toLowerCase(Locale.ROOT)));
    }

    public static PokemonConverterProxy getDefault() {
        return DEFAULT;
    }

    public static void setDefault(PokemonConverterProxy converter) {
        DEFAULT = converter;
    }

    static {
        PokemonConverterRegistry.setDefault(SHOWDOWN_CONVERTER);
    }
}

