/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon;

import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import java.util.Locale;
import net.minecraft.util.IStringSerializable;

public enum Nature implements ITranslatable,
IStringSerializable
{
    HARDY(BattleStatsType.NONE, BattleStatsType.NONE),
    SERIOUS(BattleStatsType.NONE, BattleStatsType.NONE),
    DOCILE(BattleStatsType.NONE, BattleStatsType.NONE),
    BASHFUL(BattleStatsType.NONE, BattleStatsType.NONE),
    QUIRKY(BattleStatsType.NONE, BattleStatsType.NONE),
    LONELY(BattleStatsType.ATTACK, BattleStatsType.DEFENSE),
    BRAVE(BattleStatsType.ATTACK, BattleStatsType.SPEED),
    ADAMANT(BattleStatsType.ATTACK, BattleStatsType.SPECIAL_ATTACK),
    NAUGHTY(BattleStatsType.ATTACK, BattleStatsType.SPECIAL_DEFENSE),
    BOLD(BattleStatsType.DEFENSE, BattleStatsType.ATTACK),
    RELAXED(BattleStatsType.DEFENSE, BattleStatsType.SPEED),
    IMPISH(BattleStatsType.DEFENSE, BattleStatsType.SPECIAL_ATTACK),
    LAX(BattleStatsType.DEFENSE, BattleStatsType.SPECIAL_DEFENSE),
    TIMID(BattleStatsType.SPEED, BattleStatsType.ATTACK),
    HASTY(BattleStatsType.SPEED, BattleStatsType.DEFENSE),
    JOLLY(BattleStatsType.SPEED, BattleStatsType.SPECIAL_ATTACK),
    NAIVE(BattleStatsType.SPEED, BattleStatsType.SPECIAL_DEFENSE),
    MODEST(BattleStatsType.SPECIAL_ATTACK, BattleStatsType.ATTACK),
    MILD(BattleStatsType.SPECIAL_ATTACK, BattleStatsType.DEFENSE),
    QUIET(BattleStatsType.SPECIAL_ATTACK, BattleStatsType.SPEED),
    RASH(BattleStatsType.SPECIAL_ATTACK, BattleStatsType.SPECIAL_DEFENSE),
    CALM(BattleStatsType.SPECIAL_DEFENSE, BattleStatsType.ATTACK),
    GENTLE(BattleStatsType.SPECIAL_DEFENSE, BattleStatsType.DEFENSE),
    SASSY(BattleStatsType.SPECIAL_DEFENSE, BattleStatsType.SPEED),
    CAREFUL(BattleStatsType.SPECIAL_DEFENSE, BattleStatsType.SPECIAL_ATTACK);

    private static final Nature[] VALUES;
    private final BattleStatsType increasedStat;
    private final BattleStatsType decreasedStat;

    private Nature(BattleStatsType increasedStat, BattleStatsType decreasedStat) {
        this.increasedStat = increasedStat;
        this.decreasedStat = decreasedStat;
    }

    public BattleStatsType getIncreasedStat() {
        return this.increasedStat;
    }

    public BattleStatsType getDecreasedStat() {
        return this.decreasedStat;
    }

    public static Nature getNatureFromIndex(int index) {
        if (index < 0 || index >= VALUES.length) {
            return null;
        }
        return Nature.values()[index];
    }

    public static Nature getRandomNature() {
        return RandomHelper.getRandomElementFromArray(VALUES);
    }

    public static boolean hasNature(String name) {
        try {
            Nature.valueOf(name.toUpperCase());
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static Nature natureFromString(String name) {
        try {
            return Nature.valueOf(name.toUpperCase());
        }
        catch (Exception e) {
            for (Nature nature : Nature.values()) {
                if (!name.equalsIgnoreCase(nature.toString()) && !name.equalsIgnoreCase(nature.getLocalizedName())) continue;
                return nature;
            }
            return null;
        }
    }

    @Override
    public String getTranslationKey() {
        return "enum.nature." + this.toString().toLowerCase(Locale.ROOT);
    }

    public String func_176610_l() {
        return this.name();
    }

    static {
        VALUES = Nature.values();
    }
}

