/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.npc.TeachMoveEvent;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.AirSaver;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenReplaceMoveScreenPacket;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class LearnMoveController {
    private static final ListMultimap<UUID, LearnMove> userMap = MultimapBuilder.hashKeys().arrayListValues().build();

    public static boolean canLearnMove(ServerPlayerEntity player, UUID pokemon, ImmutableAttack move) {
        if (userMap.containsKey((Object)player.func_110124_au())) {
            Iterator iterator = userMap.get((Object)player.func_110124_au()).iterator();
            while (iterator.hasNext()) {
                LearnMove learnMove = (LearnMove)iterator.next();
                if (Pixelmon.EVENT_BUS.post((Event)new TeachMoveEvent.CanLearnMove((PlayerEntity)player, StorageProxy.getParty(player).get(learnMove.pokemon), move))) {
                    return false;
                }
                if (!Objects.equals(learnMove.pokemon, pokemon) || !Objects.equals(learnMove.move, move)) continue;
                iterator.remove();
                return learnMove.condition == null || learnMove.condition.test(player);
            }
        }
        return false;
    }

    public static boolean hasCondition(ServerPlayerEntity player, UUID pokemon, ImmutableAttack move) {
        if (userMap.containsKey((Object)player.func_110124_au())) {
            List learnMoves = userMap.get((Object)player.func_110124_au());
            for (LearnMove learnMove : learnMoves) {
                if (!Objects.equals(learnMove.pokemon, pokemon) || !Objects.equals(learnMove.move, move) || learnMove.condition == null) continue;
                return true;
            }
        }
        return false;
    }

    public static void addLearnMove(ServerPlayerEntity player, UUID pokemon, ImmutableAttack move) {
        userMap.put((Object)player.func_110124_au(), (Object)new LearnMove(player.func_110124_au(), pokemon, move));
    }

    public static void addLearnMove(ServerPlayerEntity player, UUID pokemon, ImmutableAttack move, Predicate<ServerPlayerEntity> condition) {
        userMap.put((Object)player.func_110124_au(), (Object)new LearnMove(player.func_110124_au(), pokemon, move, condition));
    }

    public static void sendLearnMove(ServerPlayerEntity player, UUID pokemon, ImmutableAttack move) {
        LearnMoveController.addLearnMove(player, pokemon, move);
        NetworkHelper.sendPacket(player, new OpenReplaceMoveScreenPacket(pokemon, move));
    }

    public static void sendLearnMove(ServerPlayerEntity player, UUID pokemon, ImmutableAttack move, boolean checkEvo) {
        LearnMoveController.addLearnMove(player, pokemon, move);
        NetworkHelper.sendPacket(player, new OpenReplaceMoveScreenPacket(pokemon, move, checkEvo));
    }

    public static void sendLearnMove(ServerPlayerEntity player, UUID pokemon, ImmutableAttack move, Predicate<ServerPlayerEntity> condition) {
        LearnMoveController.addLearnMove(player, pokemon, move, condition);
        NetworkHelper.sendPacket(player, new OpenReplaceMoveScreenPacket(pokemon, move));
    }

    public static void clearLearnMoves(ServerPlayerEntity player) {
        userMap.removeAll((Object)player.func_110124_au());
    }

    public static void clearLearnMoves(UUID player) {
        userMap.removeAll((Object)player);
    }

    public static Predicate<ServerPlayerEntity> itemCostCondition(ItemStack cost) {
        return LearnMoveController.itemCostCondition(Sets.newHashSet((Object[])new ItemStack[]{cost}));
    }

    public static Predicate<ServerPlayerEntity> itemCostCondition(Collection<ItemStack> costs) {
        return player -> {
            HashSet taken = Sets.newHashSet();
            for (ItemStack cost : costs) {
                if (LearnMoveController.takeItem((NonNullList<ItemStack>)player.field_71071_by.field_70462_a, cost) || LearnMoveController.takeItem((NonNullList<ItemStack>)player.field_71071_by.field_184439_c, cost)) {
                    taken.add(cost);
                    continue;
                }
                taken.forEach(arg_0 -> ((PlayerInventory)player.field_71071_by).func_70441_a(arg_0));
                ChatHandler.sendFormattedChat((ICommandSource)player, TextFormatting.RED, "pixelmon.npc.cantpay", new Object[0]);
                return false;
            }
            return true;
        };
    }

    private static boolean takeItem(NonNullList<ItemStack> inv, ItemStack cost) {
        for (ItemStack stack : inv) {
            if (stack.func_190926_b() || !stack.func_77969_a(cost) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)cost) || stack.func_190916_E() < cost.func_190916_E()) continue;
            stack.func_190918_g(cost.func_190916_E());
            return true;
        }
        return false;
    }

    public static void tick(World world) {
        for (LearnMove value : userMap.values()) {
            value.tick(world);
        }
    }

    public static class LearnMove {
        protected UUID player;
        protected UUID pokemon;
        protected ImmutableAttack move;
        protected Predicate<ServerPlayerEntity> condition = null;
        protected final AirSaver airSaver;

        public LearnMove(UUID player, UUID pokemon, ImmutableAttack move) {
            this.player = player;
            this.pokemon = pokemon;
            this.move = move;
            this.airSaver = new AirSaver(ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(this.player));
        }

        public LearnMove(UUID player, UUID pokemon, ImmutableAttack move, Predicate<ServerPlayerEntity> condition) {
            this(player, pokemon, move);
            this.condition = condition;
        }

        public void tick(World world) {
            this.airSaver.tick();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LearnMove learnMove = (LearnMove)o;
            return this.player.equals(learnMove.player) && this.pokemon.equals(learnMove.pokemon) && this.move.equals(learnMove.move);
        }

        public int hashCode() {
            return Objects.hash(this.player, this.pokemon, this.move);
        }
    }
}

