/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon;

import java.util.function.Function;

public enum ExperienceGroup {
    ERRATIC(level -> {
        if (level <= 50) {
            return (100 - level) * (level * level * level) / 50;
        }
        if (level <= 68) {
            return (150 - level) * (level * level * level) / 100;
        }
        if (level <= 98) {
            return (191 - level) * (level * level * level) / 150;
        }
        if (level <= 100) {
            return (160 - level) * (level * level * level) / 100;
        }
        return 60 * (level * level * level) / 100;
    }),
    FAST(level -> (int)(0.8 * (double)level.intValue() * (double)level.intValue() * (double)level.intValue())),
    MEDIUM_FAST(level -> level * level * level),
    MEDIUM_SLOW(level -> level == 2 ? 9 : (int)(1.2 * (double)level.intValue() * (double)level.intValue() * (double)level.intValue() - (double)(15 * level * level) + (double)(100 * level) - 140.0)),
    SLOW(level -> (int)(1.25 * (double)level.intValue() * (double)level.intValue() * (double)level.intValue())),
    FLUCTUATING(level -> {
        if (level <= 15) {
            return (level + 73) * (level * level * level) / 150;
        }
        if (level <= 36) {
            return (level + 14) * (level * level * level) / 50;
        }
        return (level + 64) * (level * level * level) / 100;
    });

    private static final ExperienceGroup[] VALUES;
    private final Function<Integer, Integer> calc;

    private ExperienceGroup(Function<Integer, Integer> calc) {
        this.calc = calc;
    }

    public int getExpForLevel(int level) {
        return this.calc.apply(level);
    }

    public int getExpToLevel(int level) {
        int total = 0;
        for (int i = 1; i <= level; ++i) {
            total += this.getExpForLevel(i);
        }
        return total;
    }

    public static boolean hasExperienceGroup(String group) {
        for (ExperienceGroup g : VALUES) {
            if (!g.name().equalsIgnoreCase(group)) continue;
            return true;
        }
        return false;
    }

    public static ExperienceGroup getExperienceGroupFromString(String group) {
        for (ExperienceGroup g : VALUES) {
            if (!g.name().equalsIgnoreCase(group)) continue;
            return g;
        }
        return null;
    }

    static {
        VALUES = ExperienceGroup.values();
    }
}

