/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.events;

import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.projectiles.HookEntity;
import com.pixelmonmod.pixelmon.enums.items.EnumRodType;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public abstract class FishingEvent
extends Event {
    public final ServerPlayerEntity player;
    public final HookEntity fishHook;

    protected FishingEvent(ServerPlayerEntity player, HookEntity fishHook) {
        this.player = player;
        this.fishHook = fishHook;
    }

    public EnumRodType getRodType() {
        return this.fishHook.getRodType();
    }

    public static class Reel
    extends FishingEvent {
        public final Optional<Entity> optEntity;

        public Reel(ServerPlayerEntity player, HookEntity fishHook, Entity entity) {
            super(player, fishHook);
            this.optEntity = entity == null ? Optional.empty() : Optional.of(entity);
        }

        public boolean isPokemon() {
            return this.optEntity.isPresent() && this.optEntity.get() instanceof PixelmonEntity;
        }
    }

    @Cancelable
    public static class Catch
    extends FishingEvent {
        public final SpawnAction<? extends Entity> plannedSpawn;
        private int ticksTillEscape;
        private int displayedMarks;

        public Catch(ServerPlayerEntity player, HookEntity fishHook, SpawnAction<? extends Entity> plannedSpawn, int ticksTillEscape, int displayedMarks) {
            super(player, fishHook);
            this.plannedSpawn = plannedSpawn;
            this.ticksTillEscape = ticksTillEscape;
            this.displayedMarks = displayedMarks;
        }

        public int getDisplayedMarks() {
            return this.displayedMarks;
        }

        public void setDisplayedMarks(int displayedMarks) {
            if (displayedMarks < 0) {
                displayedMarks = 0;
            }
            this.displayedMarks = displayedMarks;
        }

        public int getTicksTillEscape() {
            return this.ticksTillEscape;
        }

        public void setTicksTillEscape(int ticksTillEscape) {
            if (ticksTillEscape < 0 && ticksTillEscape != -1) {
                ticksTillEscape = 0;
            }
            this.ticksTillEscape = ticksTillEscape;
        }
    }

    public static class Cast
    extends FishingEvent {
        private int ticksUntilCatch;
        private float chanceOfNothing;

        public Cast(ServerPlayerEntity player, HookEntity fishHook, int ticksUntilCatch, float chanceOfNothing) {
            super(player, fishHook);
            this.ticksUntilCatch = ticksUntilCatch;
            this.chanceOfNothing = chanceOfNothing;
        }

        public int getTicksUntilCatch() {
            return this.ticksUntilCatch;
        }

        public void setTicksUntilCatch(int ticksUntilCatch) {
            if (ticksUntilCatch <= 0) {
                ticksUntilCatch = 1;
            }
            this.ticksUntilCatch = ticksUntilCatch;
        }

        public float getChanceOfNothing() {
            return this.chanceOfNothing;
        }

        public void setChanceOfNothing(float chanceOfNothing) {
            this.chanceOfNothing = MathHelper.func_76131_a((float)chanceOfNothing, (float)0.0f, (float)1.0f);
        }
    }
}

