/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.data;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.helpers.CommonHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.entity.Entity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;

public class DataSync<A, B> {
    private final DataParameter<B> dataParameter;
    private final BiConsumer<A, B> fieldSetter;
    private final BiConsumer<Pokemon, B> fieldSetterPokemon;
    private final Class<? extends Entity> entityClass;

    public DataSync(Class<? extends Entity> entityClass, IDataSerializer<B> serializer, BiConsumer<A, B> fieldSetter) {
        this.dataParameter = EntityDataManager.func_187226_a(entityClass, serializer);
        this.entityClass = entityClass;
        this.fieldSetter = fieldSetter;
        this.fieldSetterPokemon = null;
    }

    public DataSync(Class<? extends Entity> entityClass, DataParameter<B> dataParameter, BiConsumer<A, B> fieldSetter) {
        this.entityClass = entityClass;
        this.dataParameter = dataParameter;
        this.fieldSetter = fieldSetter;
        this.fieldSetterPokemon = null;
    }

    public DataSync(Class<? extends Entity> entityClass, IDataSerializer<B> serializer, BiConsumer<A, B> fieldSetter, BiConsumer<Pokemon, B> fieldSetterPokemon) {
        this.entityClass = entityClass;
        this.dataParameter = EntityDataManager.func_187226_a(entityClass, serializer);
        this.fieldSetter = fieldSetter;
        this.fieldSetterPokemon = fieldSetterPokemon;
    }

    public DataSync(Class<? extends Entity> entityClass, DataParameter<B> dataParameter, BiConsumer<A, B> fieldSetter, BiConsumer<Pokemon, B> fieldSetterPokemon) {
        this.entityClass = entityClass;
        this.dataParameter = dataParameter;
        this.fieldSetter = fieldSetter;
        this.fieldSetterPokemon = fieldSetterPokemon;
    }

    public int getParameterId() {
        return this.dataParameter.func_187155_a();
    }

    public DataParameter<B> getDataParameter() {
        return this.dataParameter;
    }

    public void onSyncedDataUpdated(DataParameter<?> key, Entity sender) {
        if (!Objects.equals(key, this.dataParameter)) {
            return;
        }
        this.fieldSetter.accept(sender, sender.func_184212_Q().func_187225_a(key));
    }

    public void set(Entity sender, Object data) {
        if (this.entityClass.isAssignableFrom(sender.getClass())) {
            this.fieldSetter.accept(sender, data);
        }
        sender.func_184212_Q().func_187227_b(this.dataParameter, data);
    }

    public void set(Pokemon sender, Object data) {
        Optional<PixelmonEntity> pixelmonEntity = sender.getPixelmonEntity();
        if (pixelmonEntity.isPresent()) {
            this.set((Entity)pixelmonEntity.get(), data);
        } else {
            this.fieldSetterPokemon.accept(sender, data);
        }
    }

    static {
        CommonHelper.disableLogMessage(EntityDataManager.class, ".*defineId called for:.*");
    }
}

