/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.config.api.yaml;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.config.api.data.ConfigPath;
import com.pixelmonmod.pixelmon.api.config.api.data.Serializers;
import com.pixelmonmod.pixelmon.api.config.api.yaml.AbstractYamlConfig;
import com.pixelmonmod.pixelmon.api.config.api.yaml.data.YamlConfigStyle;
import info.pixelmon.repack.org.spongepowered.CommentedConfigurationNode;
import info.pixelmon.repack.org.spongepowered.ConfigurateException;
import info.pixelmon.repack.org.spongepowered.ConfigurationOptions;
import info.pixelmon.repack.org.spongepowered.loader.HeaderMode;
import info.pixelmon.repack.org.spongepowered.reference.ConfigurationReference;
import info.pixelmon.repack.org.spongepowered.reference.ValueReference;
import info.pixelmon.repack.org.spongepowered.reference.WatchServiceListener;
import info.pixelmon.repack.org.spongepowered.serialize.ScalarSerializer;
import info.pixelmon.repack.org.spongepowered.yaml.NodeStyle;
import info.pixelmon.repack.org.spongepowered.yaml.YamlConfigurationLoader;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class YamlConfigFactory {
    private static final WatchServiceListener SERVICE_LISTENER = YamlConfigFactory.getServiceListener();

    private static WatchServiceListener getServiceListener() {
        try {
            return WatchServiceListener.builder().build();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T extends AbstractYamlConfig> T getInstance(Class<T> clazz) throws IOException {
        ConfigurationReference<CommentedConfigurationNode> base;
        ConfigPath annotation = clazz.getAnnotation(ConfigPath.class);
        if (annotation == null) {
            throw new IOException("Cannot load config " + clazz.getSimpleName() + " as it's missing @ConfigPath annotation");
        }
        NodeStyle style = YamlConfigFactory.getNodeStyle(clazz);
        Path configFile = Paths.get(annotation.value(), new String[0]);
        if (!configFile.toFile().exists()) {
            configFile.getParent().toFile().mkdirs();
            configFile.toFile().createNewFile();
        }
        ArrayList serializers = Lists.newArrayList();
        Serializers serializedData = clazz.getAnnotation(Serializers.class);
        if (serializedData != null) {
            serializers.addAll(Arrays.asList(serializedData.value()));
        }
        if ((base = YamlConfigFactory.listenToConfig(configFile, serializers, style)) == null) {
            throw new IOException("Error config loaded as null");
        }
        ValueReference<T, CommentedConfigurationNode> reference = base.referenceTo(clazz, new Object[0]);
        AbstractYamlConfig instance = (AbstractYamlConfig)reference.get();
        if (instance == null) {
            throw new IOException("Error config loaded as null");
        }
        instance.base = base;
        instance.config = reference;
        instance.save();
        return (T)instance;
    }

    private static NodeStyle getNodeStyle(Class<?> clazz) {
        YamlConfigStyle annotation = clazz.getAnnotation(YamlConfigStyle.class);
        if (annotation == null) {
            return NodeStyle.BLOCK;
        }
        return annotation.value();
    }

    private static ConfigurationReference<CommentedConfigurationNode> listenToConfig(Path configFile, List<Class<? extends ScalarSerializer<?>>> serializers, NodeStyle style) {
        try {
            return SERVICE_LISTENER.listenToConfiguration(file -> ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().headerMode(HeaderMode.PRESERVE)).nodeStyle(style).defaultOptions(ConfigurationOptions.defaults().serializers(builder -> {
                try {
                    for (Class serializer : serializers) {
                        builder.register((ScalarSerializer)serializer.newInstance());
                    }
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
            }).nativeTypes(Sets.newHashSet((Object[])new Class[]{String.class, Integer.class, Byte.class, Double.class, Boolean.class, Long.class, Map.class, List.class})))).defaultOptions(opts -> opts.shouldCopyDefaults(true))).path((Path)file)).build(), configFile);
        }
        catch (ConfigurateException e) {
            e.printStackTrace();
            return null;
        }
    }
}

