/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.config;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.spawning.CompositeSpawnCondition;
import com.pixelmonmod.pixelmon.api.spawning.conditions.RarityMultiplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;

public class BetterSpawnerConfig {
    public static final String PATH = "config/pixelmon/betterspawnerconfig.json";
    public static final HashMap<String, Long> intervalTimes = new HashMap();
    public static BetterSpawnerConfig INSTANCE = null;
    public CompositeSpawnCondition globalCompositeCondition = new CompositeSpawnCondition();
    public ArrayList<RarityMultiplier> globalRarityMultipliers = new ArrayList();
    public HashMap<String, PokemonSpecification> autoTagSpecs = new HashMap();
    public HashMap<String, Integer> intervalSeconds = new HashMap();
    public transient Set<Block> landBlockCategory = Sets.newHashSet();
    public transient Set<Block> waterBlockCategory = Sets.newHashSet();
    public transient Set<Block> airBlockCategory = Sets.newHashSet();
    public transient Set<Block> lavaBlockCategory = Sets.newHashSet();
    public transient Set<Block> seesSkyBlockCategory = Sets.newHashSet();
    public transient Set<Block> treeTopBlockCategory = Sets.newHashSet();
    public transient Set<Block> structureBlockCategory = Sets.newHashSet();
    public transient HashMap<String, Set<Block>> cachedBlockCategories = new HashMap();
    public transient HashMap<String, Set<Biome>> cachedBiomeCategories = new HashMap();
    private HashMap<String, ArrayList<String>> blockCategories = new HashMap();
    private HashMap<String, ArrayList<String>> biomeCategories = new HashMap();
    private static String storedJson;

    public static void load(Gson gson, JsonElement json) {
        storedJson = json.toString();
        Pixelmon.LOGGER.info("Registering Better Spawner.");
        BetterSpawnerConfig loading = (BetterSpawnerConfig)gson.fromJson(json, BetterSpawnerConfig.class);
        loading.cachedBlockCategories = BetterSpawnerConfig.convert(loading.blockCategories, Block.class);
        loading.cachedBiomeCategories = BetterSpawnerConfig.convert(loading.biomeCategories, Biome.class);
        loading.landBlockCategory = loading.cachedBlockCategories.get("land");
        loading.waterBlockCategory = loading.cachedBlockCategories.get("water");
        loading.airBlockCategory = loading.cachedBlockCategories.get("air");
        loading.lavaBlockCategory = loading.cachedBlockCategories.get("lava");
        loading.seesSkyBlockCategory = loading.cachedBlockCategories.get("seesSkyException");
        loading.treeTopBlockCategory = loading.cachedBlockCategories.get("treeTop");
        loading.structureBlockCategory = loading.cachedBlockCategories.get("structure");
        INSTANCE = loading;
        if (BetterSpawnerConfig.INSTANCE.globalCompositeCondition != null) {
            BetterSpawnerConfig.INSTANCE.globalCompositeCondition.onImport();
        }
    }

    public static String getStoredJson() {
        return storedJson;
    }

    private static <T extends IForgeRegistryEntry<T>> HashMap<String, Set<T>> convert(HashMap<String, ArrayList<String>> values, Class<T> clazz) {
        HashMap<String, Set<T>> converted = new HashMap<String, Set<T>>();
        IForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(clazz);
        for (Map.Entry<String, ArrayList<String>> entry : values.entrySet()) {
            HashSet ts = Sets.newHashSet();
            if (entry.getValue() != null) {
                block1: for (String string : entry.getValue()) {
                    for (Map.Entry entry2 : registry.getEntries()) {
                        if (!((RegistryKey)entry2.getKey()).func_240901_a_().toString().equalsIgnoreCase(string) && !((RegistryKey)entry2.getKey()).func_240901_a_().func_110623_a().equalsIgnoreCase(string)) continue;
                        ts.add(entry2.getValue());
                        continue block1;
                    }
                }
            }
            converted.put(entry.getKey(), ts);
        }
        return converted;
    }

    public static boolean checkInterval(String interval) {
        if (interval == null) {
            return true;
        }
        if (!BetterSpawnerConfig.INSTANCE.intervalSeconds.containsKey(interval)) {
            return true;
        }
        if (BetterSpawnerConfig.INSTANCE.intervalSeconds.get(interval) == -1) {
            return false;
        }
        Long last = intervalTimes.get(interval);
        if (last == null || !BetterSpawnerConfig.INSTANCE.intervalSeconds.containsKey(interval)) {
            return true;
        }
        return last < System.currentTimeMillis();
    }

    public static void consumeInterval(String interval) {
        if (BetterSpawnerConfig.INSTANCE.intervalSeconds.containsKey(interval)) {
            intervalTimes.put(interval, System.currentTimeMillis() + (long)(BetterSpawnerConfig.INSTANCE.intervalSeconds.get(interval) * 1000));
        }
    }

    public static Set<Block> getLandBlocks() {
        return BetterSpawnerConfig.INSTANCE.landBlockCategory;
    }

    public static Set<Block> getWaterBlocks() {
        return BetterSpawnerConfig.INSTANCE.waterBlockCategory;
    }

    public static Set<Block> getLavaBlocks() {
        return BetterSpawnerConfig.INSTANCE.lavaBlockCategory;
    }

    public static Set<Block> getAirBlocks() {
        return BetterSpawnerConfig.INSTANCE.airBlockCategory;
    }

    public static Set<Block> getSeesSkyExceptionBlocks() {
        return BetterSpawnerConfig.INSTANCE.seesSkyBlockCategory;
    }

    public static Set<Block> getStructureBlocks() {
        return BetterSpawnerConfig.INSTANCE.structureBlockCategory;
    }

    public static Set<Block> getTreeTopBlocks() {
        return BetterSpawnerConfig.INSTANCE.treeTopBlockCategory;
    }

    public static Set<Block> getBlockCategory(String blockCategory) {
        if (BetterSpawnerConfig.INSTANCE.cachedBlockCategories.containsKey(blockCategory)) {
            return BetterSpawnerConfig.INSTANCE.cachedBlockCategories.get(blockCategory);
        }
        return Sets.newHashSet();
    }

    public static boolean doesBlockSeeSky(BlockState state) {
        if (state == null) {
            return false;
        }
        return BetterSpawnerConfig.getAirBlocks().contains(state.func_177230_c()) || BetterSpawnerConfig.getSeesSkyExceptionBlocks().contains(state.func_177230_c()) || !state.func_200132_m();
    }

    public static boolean inBiomeCategory(String category, Biome name) {
        if (INSTANCE == null) {
            return false;
        }
        Set<Biome> biomes = BetterSpawnerConfig.INSTANCE.cachedBiomeCategories.getOrDefault(category, Sets.newHashSet());
        return biomes.stream().anyMatch(b -> Objects.equals(b.getRegistryName(), name.getRegistryName()));
    }
}

