/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.command;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.PixelmonPlayerUtils;
import com.pixelmonmod.pixelmon.api.util.ThreadPool;
import com.pixelmonmod.pixelmon.api.util.helpers.PlayerHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.EntitySelector;
import net.minecraft.command.arguments.EntitySelectorParser;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class PixelmonCommandUtils {
    public static final ThreadPool THREAD_POOL = ThreadPool.createNewThreadPool("Pixelmon Commands", 2);
    public static final List<String> PARTY_SLOTS = Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5", "6"});
    public static final List<String> SPEC_REQUIREMENTS = Lists.newArrayList((Object[])PokemonSpecificationProxy.getRequirementNames());
    public static final List<String> REMOVE_ARGUMENT = Lists.newArrayList((Object[])new String[]{"remove"});
    public static final List<String> TARGET_SELECTORS = Lists.newArrayList((Object[])new String[]{"@p", "@r", "@a", "@e", "@s"});

    public static void notifyCommandListener(CommandSource sender, PixelCommand command, int i, String translatedText, Object ... values) {
        sender.func_197030_a((ITextComponent)new TranslationTextComponent(translatedText, values), true);
    }

    public static String[] setupCommandTargets(PixelCommand command, CommandSource sender, String[] args, int playerIndex) throws CommandException, CommandSyntaxException {
        String selector;
        if (args.length > playerIndex && (selector = args[playerIndex]).startsWith("@")) {
            List playerMatches = PixelmonCommandUtils.getEntitySelector(selector).func_197341_b(sender);
            PixelmonCommandUtils.require(playerMatches, "argument.entity.notfound.player", selector);
            if (!playerMatches.isEmpty()) {
                Entity first = (Entity)playerMatches.remove(0);
                for (Entity entity : playerMatches) {
                    if (!(entity instanceof ServerPlayerEntity)) continue;
                    String[] newArgs = (String[])args.clone();
                    newArgs[playerIndex] = entity.func_200200_C_().getString();
                    command.execute(sender, newArgs);
                }
                args[playerIndex] = first.func_200200_C_().getString();
                return args;
            }
        }
        return command.setupTargetOrSourceAsTarget(sender, args, playerIndex);
    }

    public static EntitySelector getEntitySelector(String username) throws CommandSyntaxException {
        return new EntitySelectorParser(new StringReader(username), true).func_201345_m();
    }

    @Nonnull
    public static ServerPlayerEntity requireEntityPlayer(String username) throws CommandException {
        ServerPlayerEntity player = PixelmonCommandUtils.getEntityPlayer(username);
        if (player != null) {
            return player;
        }
        throw PixelmonCommandUtils.getException(PixelmonCommandUtils.format(TextFormatting.RED, "argument.entity.notfound.player", username));
    }

    public static ServerPlayerEntity requireEntityPlayer(CommandSource source) throws CommandException {
        try {
            return source.func_197035_h();
        }
        catch (CommandSyntaxException e) {
            throw PixelmonCommandUtils.getException(PixelmonCommandUtils.format(TextFormatting.RED, "argument.entity.notfound.player", source.func_197037_c()));
        }
    }

    @Nullable
    public static ServerPlayerEntity getEntityPlayer(String username) {
        if (username == null || username.isEmpty()) {
            return null;
        }
        if (username.length() == 36) {
            return PixelmonCommandUtils.getEntityPlayer(UUID.fromString(username));
        }
        if (username.length() == 32) {
            BigInteger bigInteger = new BigInteger(username, 16);
            UUID uuid = new UUID(bigInteger.shiftRight(64).longValue(), bigInteger.longValue());
            return PixelmonCommandUtils.getEntityPlayer(uuid);
        }
        for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
            if (!player.func_200200_C_().getString().equalsIgnoreCase(username)) continue;
            return player;
        }
        return null;
    }

    public static ServerPlayerEntity getEntityPlayer(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        return ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(uuid);
    }

    public static GameProfile findProfile(String username) {
        if (username == null || username.isEmpty()) {
            return null;
        }
        ServerPlayerEntity playerMP = PixelmonCommandUtils.getEntityPlayer(username);
        if (playerMP != null) {
            return playerMP.func_146103_bH();
        }
        PlayerProfileCache cache = ServerLifecycleHooks.getCurrentServer().func_152358_ax();
        if (username.length() == 36) {
            UUID uuid = UUID.fromString(username);
            return cache.func_152652_a(uuid);
        }
        if (username.length() == 32) {
            BigInteger bigInteger = new BigInteger(username, 16);
            UUID uuid = new UUID(bigInteger.shiftRight(64).longValue(), bigInteger.longValue());
            return cache.func_152652_a(uuid);
        }
        return PixelmonPlayerUtils.getGameProfileNoLookup(cache, username);
    }

    public static int requireInt(String input, String message) throws CommandException {
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException var2) {
            throw PixelmonCommandUtils.getException(PixelmonCommandUtils.format(TextFormatting.RED, message, input));
        }
    }

    public static int requireInt(String input, int min, int max, String message, Object ... data) throws CommandException {
        try {
            int i = Integer.parseInt(input);
            if (i < min) {
                throw PixelmonCommandUtils.getException(PixelmonCommandUtils.format(TextFormatting.RED, "argument.integer.low", min, input));
            }
            if (i > max) {
                throw PixelmonCommandUtils.getException(PixelmonCommandUtils.format(TextFormatting.RED, "argument.integer.big", max, input));
            }
            return i;
        }
        catch (NumberFormatException var2) {
            throw PixelmonCommandUtils.getException(PixelmonCommandUtils.format(TextFormatting.RED, message, input, data));
        }
    }

    public static void require(boolean boo, String message, Object ... data) throws CommandException {
        if (!boo) {
            PixelmonCommandUtils.endCommand(message, data);
        }
    }

    @Nonnull
    public static <T> T require(Optional<T> optional, String message, Object ... data) throws CommandException {
        if (!optional.isPresent()) {
            PixelmonCommandUtils.endCommand(message, data);
        }
        return optional.get();
    }

    @Nonnull
    public static <T> T require(T obj, String message, Object ... data) throws CommandException {
        if (obj == null) {
            PixelmonCommandUtils.endCommand(message, data);
        } else if (obj instanceof Boolean && !((Boolean)obj).booleanValue()) {
            PixelmonCommandUtils.endCommand(message, data);
        } else if (obj instanceof Collection && ((Collection)obj).isEmpty()) {
            PixelmonCommandUtils.endCommand(message, data);
        }
        return obj;
    }

    public static void endCommand(String message, Object ... data) throws CommandException {
        throw PixelmonCommandUtils.getException(PixelmonCommandUtils.format(TextFormatting.RED, message, data));
    }

    public static CommandException getException(String translation, Object ... data) {
        return PixelmonCommandUtils.getException((IFormattableTextComponent)new TranslationTextComponent(translation, data));
    }

    public static CommandException getException(IFormattableTextComponent translation) {
        return new FilledInStackTrace((ITextComponent)translation);
    }

    @Nullable
    public static PlayerPartyStorage getPlayerStorage(ServerPlayerEntity player) {
        return StorageProxy.getParty(player);
    }

    public static PCStorage getComputerStorage(ServerPlayerEntity player) {
        return StorageProxy.getPCForPlayer(player);
    }

    public static List<String> tabCompleteUsernames() {
        return Lists.newArrayList((Object[])ServerLifecycleHooks.getCurrentServer().func_71213_z());
    }

    public static List<String> tabCompletePokemon() {
        return Lists.newArrayList(PixelmonSpecies.getFormattedEnglishNameSet());
    }

    public static List<String> tabCompleteWorld() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        ArrayList worlds = Lists.newArrayList();
        for (RegistryKey key : server.func_240770_D_()) {
            worlds.add(key.func_240901_a_().toString());
        }
        return worlds;
    }

    public static ServerWorld getWorld(String[] args, CommandSource sender) {
        if (args.length < 1) {
            return sender.func_197023_e();
        }
        ServerWorld world = sender.func_197028_i().func_71218_a(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)ResourceLocationHelper.of(args[0])));
        if (world == null) {
            return sender.func_197023_e();
        }
        return world;
    }

    public static boolean doesStringStartWith(String original, String region) {
        return region.regionMatches(true, 0, original, 0, original.length());
    }

    public static IFormattableTextComponent format(TextFormatting color, String lang, Object ... args) {
        return PixelmonCommandUtils.format(Color.func_240744_a_((TextFormatting)color), lang, args);
    }

    public static IFormattableTextComponent format(TextFormatting color, String lang, Consumer<IFormattableTextComponent> formatting, Object ... args) {
        IFormattableTextComponent textComponent = PixelmonCommandUtils.format(Color.func_240744_a_((TextFormatting)color), lang, args);
        formatting.accept(textComponent);
        return textComponent;
    }

    public static IFormattableTextComponent format(Color color, String lang, Object ... args) {
        TranslationTextComponent message = new TranslationTextComponent(lang, args);
        message.func_230530_a_(message.func_150256_b().func_240718_a_(color));
        return message;
    }

    public static IFormattableTextComponent format(String lang, Object ... args) {
        return PixelmonCommandUtils.format(TextFormatting.GRAY, lang, args);
    }

    public static void sendMessage(ServerPlayerEntity target, TextFormatting color, String string, Object ... data) {
        target.func_145747_a((ITextComponent)PixelmonCommandUtils.format(color, string, data), Util.field_240973_b_);
    }

    public static void sendMessage(CommandSource sender, TextFormatting color, String string, Object ... data) {
        sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(color, string, data), false);
    }

    public static void sendMessage(CommandSource sender, TextFormatting color, String string, Consumer<IFormattableTextComponent> formatting, Object ... data) {
        sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(color, string, formatting, data), false);
    }

    public static void sendMessage(CommandSource sender, String string, Object ... data) {
        PixelmonCommandUtils.sendMessage(sender, TextFormatting.GRAY, string, data);
    }

    public static void sendMessage(CommandSource sender, String string, Consumer<IFormattableTextComponent> formatting, Object ... data) {
        PixelmonCommandUtils.sendMessage(sender, TextFormatting.GRAY, string, formatting, data);
    }

    public static void sendMessage(ServerPlayerEntity sender, String string, Object ... data) {
        PixelmonCommandUtils.sendMessage(sender, TextFormatting.GRAY, string, data);
    }

    public static boolean hasPermission(CommandSource source, String permission) {
        try {
            ServerPlayerEntity serverPlayerEntity = source.func_197035_h();
            return PlayerHelper.hasPermission(serverPlayerEntity, permission);
        }
        catch (CommandSyntaxException e) {
            return true;
        }
    }

    public static void applySpecs(Pokemon pokemon, String[] specList) {
        PokemonSpecification spec = PokemonSpecificationProxy.create(specList);
        spec.apply(pokemon);
    }

    private static class FilledInStackTrace
    extends CommandException {
        public FilledInStackTrace(ITextComponent message) {
            super(message);
        }

        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

