/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.ai;

import com.pixelmonmod.pixelmon.api.util.helpers.EntityHelper;
import com.pixelmonmod.pixelmon.client.models.animations.EnumRotation;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;

public class FlyingPersistentGoal
extends Goal {
    protected PixelmonEntity pixelmon;
    private int ticksToChangeDirection = 0;
    private int ticksToChangeSpeed = 0;
    private float movespeed = 1.0f;
    private int directionChange = 1000;
    private int speedChange = 500;
    private boolean lastChangeDirection;
    private int initialHeight;
    private int ticksToRefresh;

    public FlyingPersistentGoal(PixelmonEntity entity) {
        if (entity.getFlyingParameters() != null) {
            this.movespeed = entity.getFlyingParameters().getFlySpeedModifier();
            this.directionChange = entity.getFlyingParameters().getFlyRefreshRateXZ();
            this.speedChange = entity.getFlyingParameters().getFlyRefreshRateSpeed();
            this.ticksToRefresh = entity.getFlyingParameters().getFlyRefreshRateY();
        }
        this.pixelmon = entity;
        this.initialHeight = Integer.MIN_VALUE;
    }

    public boolean func_75250_a() {
        return this.pixelmon.getFlyingParameters() != null;
    }

    public boolean func_75253_b() {
        return true;
    }

    public void func_75246_d() {
        if (this.initialHeight == Integer.MIN_VALUE) {
            this.initialHeight = (int)this.pixelmon.func_226278_cu_();
        }
        --this.ticksToChangeDirection;
        boolean useLastChangeDirection = false;
        BlockRayTraceResult mop = this.pixelmon.field_70170_p.func_217299_a(new RayTraceContext(new Vector3d(this.pixelmon.func_226277_ct_(), this.pixelmon.func_174813_aQ().field_72338_b, this.pixelmon.func_226281_cx_()), new Vector3d(this.pixelmon.func_226277_ct_() + this.pixelmon.func_213322_ci().func_82615_a() * 100.0, this.pixelmon.func_174813_aQ().field_72338_b, this.pixelmon.func_226281_cx_() + this.pixelmon.func_213322_ci().func_82616_c() * 100.0), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.ANY, (Entity)this.pixelmon));
        if (mop.func_216346_c() == RayTraceResult.Type.MISS) {
            mop = this.pixelmon.field_70170_p.func_217299_a(new RayTraceContext(new Vector3d(this.pixelmon.func_226277_ct_(), this.pixelmon.func_174813_aQ().field_72337_e, this.pixelmon.func_226281_cx_()), new Vector3d(this.pixelmon.func_226277_ct_() + this.pixelmon.func_213322_ci().func_82615_a() * 100.0, this.pixelmon.func_174813_aQ().field_72337_e, this.pixelmon.func_226281_cx_() + this.pixelmon.func_213322_ci().func_82616_c() * 100.0), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.ANY, (Entity)this.pixelmon));
        }
        if (mop.func_216346_c() != RayTraceResult.Type.MISS) {
            useLastChangeDirection = true;
            this.ticksToChangeDirection = 0;
        }
        if (this.ticksToChangeDirection <= 0 && this.directionChange > 0) {
            this.pickDirection(useLastChangeDirection);
            this.ticksToChangeDirection = 25 + this.pixelmon.func_70681_au().nextInt(Math.max(1, this.directionChange));
        }
        this.pickSpeed();
        this.pickHeight();
        this.pixelmon.func_213352_e(new Vector3d(0.0, 0.0, (double)this.movespeed));
        super.func_75246_d();
    }

    public void pickDirection(boolean useLastChangeDirection) {
        double rotAmt;
        if (useLastChangeDirection) {
            rotAmt = this.pixelmon.func_70681_au().nextInt(5) + 5;
            if (this.lastChangeDirection) {
                rotAmt *= -1.0;
            }
        } else {
            rotAmt = this.pixelmon.func_70681_au().nextInt(40) - 20;
            this.lastChangeDirection = rotAmt > 0.0;
        }
        this.pixelmon.field_70177_z = (float)((double)this.pixelmon.field_70177_z + rotAmt);
    }

    public void pickSpeed() {
        if (this.pixelmon.battleController != null) {
            this.movespeed = 0.0f;
            return;
        }
        if (this.ticksToChangeSpeed <= 0) {
            this.movespeed = this.pixelmon.func_70681_au().nextFloat() * 0.7f + 1.0f;
            this.ticksToChangeSpeed = 50 + this.pixelmon.func_70681_au().nextInt(Math.max(1, this.speedChange));
        }
        --this.ticksToChangeSpeed;
    }

    public void pickHeight() {
        if (this.pixelmon.getFlyingParameters() == null) {
            return;
        }
        if (this.ticksToRefresh < 0) {
            this.pixelmon.setFlyHeight(-1);
            this.ticksToRefresh = this.pixelmon.getFlyingParameters().getFlyRefreshRateY();
        }
        --this.ticksToRefresh;
        double refreshRate = this.pixelmon.getFlyingParameters().getFlyRefreshRateY();
        if (refreshRate == 0.0) {
            refreshRate = 1.0;
        }
        double v = this.initialHeight + this.pixelmon.getFlyHeight();
        EntityHelper.setMotion((Entity)this.pixelmon, EnumRotation.y, (v - (double)this.pixelmon.func_233580_cy_().func_177956_o()) / refreshRate);
    }
}

