/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.advancements.PixelmonAdvancements;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.config.FormLogRegistry;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.BeatWildPixelmonEvent;
import com.pixelmonmod.pixelmon.api.events.HeldItemChangedEvent;
import com.pixelmonmod.pixelmon.api.events.NPCChatEvent;
import com.pixelmonmod.pixelmon.api.events.PokemonReceivedEvent;
import com.pixelmonmod.pixelmon.api.events.PokemonSendOutEvent;
import com.pixelmonmod.pixelmon.api.events.moveskills.UseMoveSkillEvent;
import com.pixelmonmod.pixelmon.api.events.pokemon.MovesetEvent;
import com.pixelmonmod.pixelmon.api.events.spawning.SpawnEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.registries.PixelmonForms;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonPalettes;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.spawning.SpawnerCoordinator;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnActionPokemon;
import com.pixelmonmod.pixelmon.api.spawning.conditions.LocationType;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.CollectionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.SpriteItemHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetNPCDataPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.items.MemoryItem;
import com.pixelmonmod.pixelmon.items.heldItems.PlateItem;
import com.pixelmonmod.pixelmon.items.heldItems.ZCrystalItem;
import java.time.LocalDate;
import java.time.Month;
import java.time.temporal.ChronoField;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PixelmonEventHandler {
    @SubscribeEvent
    public static void structureVoidHelper(PlayerInteractEvent.RightClickBlock event) {
        if (Pixelmon.isDevEnvironment() && event.getPlayer() instanceof ServerPlayerEntity && event.getHand() == Hand.MAIN_HAND && event.getFace() != null && event.getItemStack().func_77973_b() == Item.func_150898_a((Block)Blocks.field_189881_dj) && event.getWorld().func_180495_p(event.getHitVec().func_216350_a()).func_177230_c() == Blocks.field_189881_dj) {
            BlockPos pos = event.getPos().func_177972_a(event.getFace());
            for (int i = 0; i < event.getItemStack().func_190916_E(); ++i) {
                event.getWorld().func_175656_a(pos, Blocks.field_189881_dj.func_176223_P());
                event.getWorld().func_184133_a(null, pos, SoundEvents.field_187845_fY, SoundCategory.BLOCKS, 1.0f, 1.0f);
                pos = pos.func_177972_a(event.getFace());
            }
        }
    }

    @SubscribeEvent
    public void onLightning(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof LightningBoltEntity) {
            LightningBoltEntity bolt = (LightningBoltEntity)event.getEntity();
            World world = event.getWorld();
            if (world.func_201670_d()) {
                return;
            }
            BlockPos.Mutable mutablePos = new BlockPos.Mutable(bolt.func_226277_ct_(), (double)world.func_234938_ad_(), bolt.func_226281_cx_());
            BlockState block = world.func_180495_p((BlockPos)mutablePos);
            while (block.func_196958_f() && mutablePos.func_177956_o() > 0) {
                mutablePos.func_185336_p(mutablePos.func_177956_o() - 1);
                block = world.func_180495_p((BlockPos)mutablePos);
            }
            if (world.func_180495_p((BlockPos)mutablePos).func_177230_c() == Blocks.field_150348_b) {
                world.func_180501_a((BlockPos)mutablePos, PixelmonBlocks.thunder_stone_ore.func_176223_P(), 3);
                for (int x = -2; x <= 2; ++x) {
                    for (int y = -2; y <= 0; ++y) {
                        for (int z = -2; z <= 2; ++z) {
                            if (!RandomHelper.getRandomChance(0.05f)) continue;
                            BlockPos.Mutable pos = mutablePos.func_196234_d(x, y, z);
                            if (world.func_180495_p((BlockPos)pos).func_177230_c() == Blocks.field_150348_b) {
                                world.func_180501_a((BlockPos)pos, PixelmonBlocks.thunder_stone_ore.func_176223_P(), 3);
                            }
                            mutablePos.func_196234_d(-x, -y, -z);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onMoveSkillUsed(UseMoveSkillEvent event) {
        Tuple data;
        ServerPlayerEntity trainer = event.pixelmon.getPokemon().getOwnerPlayer();
        if (Objects.equals(event.moveSkill.id, "forage") && event.pixelmon.getSpecies().is(PixelmonSpecies.PICHU) && event.pixelmon.getPokemon().getFriendship() == 255 && !event.pixelmon.getPokemon().getPersistentData().func_74767_n("Pichu_friend") && event.data instanceof Tuple && StorageProxy.getParty(trainer).hasSpace() && event.pixelmon.field_70170_p.func_180495_p((BlockPos)(data = (Tuple)event.data).func_76341_a()).func_177230_c() == PixelmonBlocks.ilex_shrine.getBlock()) {
            event.pixelmon.getPokemon().getPersistentData().func_74757_a("Pichu_friend", true);
            Pokemon pichu = PokemonFactory.create(PixelmonSpecies.PICHU.getValueUnsafe());
            pichu.setGender(Gender.FEMALE);
            pichu.setLevel(30);
            pichu.setForm("spiky");
            pichu.setAbility(AbilityRegistry.STATIC);
            pichu.setHeldItem(new ItemStack((IItemProvider)PixelmonItems.zap_plate.getItem()));
            pichu.getMoveset().set(0, new Attack(AttackRegistry.VOLT_TACKLE));
            pichu.getMoveset().set(1, new Attack(AttackRegistry.HELPING_HAND));
            pichu.getMoveset().set(2, new Attack(AttackRegistry.SWAGGER));
            pichu.getMoveset().set(3, new Attack(AttackRegistry.PAIN_SPLIT));
            pichu.getPersistentData().func_74757_a("Pichu_friend", true);
            StorageProxy.getParty(trainer).add(pichu);
            NPCChatEvent event2 = new NPCChatEvent(null, (PlayerEntity)trainer, Lists.newArrayList((Object[])new String[]{"event.spikepichu"}));
            if (!Pixelmon.EVENT_BUS.post((Event)event2)) {
                NetworkHelper.sendPacket(trainer, new SetNPCDataPacket("", event2.getChat()));
                OpenScreenPacket.open((PlayerEntity)trainer, EnumGuiScreen.NPCChat, -1);
            }
        }
    }

    @SubscribeEvent
    public void onBeatPokemon(BeatWildPixelmonEvent event) {
        PixelmonAdvancements.throwBattleTriggers(event.player);
        if (PixelmonConfigProxy.getGeneral().isAwardTokens()) {
            for (PixelmonWrapper wrapper : event.wpp.controlledPokemon) {
                PixelmonEntity pokemon = wrapper.entity;
                event.player.field_71071_by.func_70441_a(SpriteItemHelper.getPhoto(pokemon.getPokemon()));
            }
        }
    }

    @SubscribeEvent
    public void onChristmasDelibird(BeatWildPixelmonEvent event) {
        SpawnerCoordinator.PROCESSOR.submit(() -> {
            if (event.wpp.controlledPokemon.stream().anyMatch(it -> it.pokemon.getSpecies().is(PixelmonSpecies.DELIBIRD))) {
                PlayerPartyStorage party = StorageProxy.getParty(event.player);
                LocalDate now = LocalDate.now();
                int year = now.get(ChronoField.YEAR);
                Month month = now.getMonth();
                int day = now.getDayOfMonth();
                if (month == Month.DECEMBER && day >= 20 && day <= 31 && !party.playerData.getWasGifted(year)) {
                    ChatHandler.sendChat((Entity)event.player, "christmas.received", new Object[0]);
                    event.player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)PixelmonItems.gift_box));
                    party.playerData.receivedGift(year);
                }
            }
        });
    }

    @SubscribeEvent
    public void onHeldItemChanged(HeldItemChangedEvent event) {
        if (event.getSpecies().is(PixelmonSpecies.GIRATINA)) {
            if (event.pokemon.getForm().isForm("altered") && event.newHeldItem.func_77973_b() == PixelmonItems.griseous_orb) {
                event.pokemon.setForm("origin");
                if (event.player != null) {
                    ChatHandler.sendChat((Entity)event.player, "pixelmon.abilities.changeform", "Giratina");
                }
            } else if (event.pokemon.getForm().isForm("origin") && event.newHeldItem.func_77973_b() != PixelmonItems.griseous_orb) {
                event.pokemon.setForm("altered");
                if (event.player != null) {
                    ChatHandler.sendChat((Entity)event.player, "pixelmon.abilities.changeform", "Giratina");
                }
            }
        } else if (event.getSpecies().is(PixelmonSpecies.ARCEUS)) {
            Element type = event.newHeldItem.func_190926_b() || !(event.newHeldItem.func_77973_b() instanceof PlateItem) && !(event.newHeldItem.func_77973_b() instanceof ZCrystalItem) ? Element.NORMAL : (event.newHeldItem.func_77973_b() instanceof PlateItem ? ((PlateItem)event.newHeldItem.func_77973_b()).getType() : ((ZCrystalItem)event.newHeldItem.func_77973_b()).type.affiliatedType);
            String newForm = PixelmonForms.getFromType(type);
            event.pokemon.setForm(newForm);
        } else if (event.getSpecies().is(PixelmonSpecies.SILVALLY)) {
            Item item;
            String newForm = PixelmonForms.NONE;
            if (!event.newHeldItem.func_190926_b() && (item = event.newHeldItem.func_77973_b()) instanceof MemoryItem) {
                newForm = PixelmonForms.getFromType(((MemoryItem)item).type);
            }
            event.pokemon.setForm(newForm);
        } else if (event.getSpecies().is(PixelmonSpecies.GENESECT)) {
            String newForm = PixelmonForms.NONE;
            if (!event.newHeldItem.func_190926_b()) {
                Item item = event.newHeldItem.func_77973_b();
                if (item == PixelmonItems.burn_drive) {
                    newForm = "burn";
                } else if (item == PixelmonItems.chill_drive) {
                    newForm = "chill";
                } else if (item == PixelmonItems.douse_drive) {
                    newForm = "douse";
                } else if (item == PixelmonItems.shock_drive) {
                    newForm = "shock";
                }
            }
            event.pokemon.setForm(newForm);
            if (event.player != null) {
                ChatHandler.sendChat((Entity)event.player, "pixelmon.abilities.changeform", "Genesect");
            }
        }
    }

    @SubscribeEvent
    public void onSentOut(PokemonSendOutEvent event) {
        if (event.getPokemon().getSpecies().is(PixelmonSpecies.SHAYMIN)) {
            if (event.getPokemon().getForm().isForm("sky") && !event.getPlayer().func_71121_q().func_72935_r()) {
                event.getPokemon().setForm("land");
                ChatHandler.sendChat((Entity)event.getPlayer(), "pixelmon.abilities.changeform", event.getPokemon().getDisplayName());
            }
        } else if (event.getPokemon().getSpecies().is(PixelmonSpecies.CHERRIM)) {
            if (event.getPokemon().getForm().isForm("sunshine")) {
                event.getPokemon().setForm("overcast");
            }
        } else if (!event.getPokemon().getSpecies().is(PixelmonSpecies.TOXTRICITY) && event.getPokemon().getSpecies().is(PixelmonSpecies.HOOPA) && event.getPokemon().getForm().isForm("unbound") && System.currentTimeMillis() > event.getPokemon().getPersistentData().func_74763_f("unboundTime") + 3600000L) {
            event.getPokemon().setForm("confined");
            event.getPokemon().getPersistentData().func_82580_o("unboundTime");
            ChatHandler.sendChat((Entity)event.getPlayer(), "pixelmon.abilities.changeform", event.getPokemon().getDisplayName());
        }
    }

    @SubscribeEvent
    public void onMoveLearned(MovesetEvent.LearntMoveEvent event) {
        if (event.pokemon.getSpecies().is(PixelmonSpecies.KELDEO)) {
            if (event.learntAttack.isAttack(AttackRegistry.SECRET_SWORD) && event.pokemon.getForm().isForm("ordinary")) {
                event.pokemon.setForm("resolute");
            } else if (!event.moveset.hasAttack(AttackRegistry.SECRET_SWORD) && event.pokemon.getForm().isForm("resolute")) {
                event.pokemon.setForm("ordinary");
            }
        }
    }

    @SubscribeEvent
    public void onMoveForgot(MovesetEvent.ForgotMoveEvent event) {
        if (event.pokemon.getSpecies().is(PixelmonSpecies.KELDEO) && event.forgottenAttack.isAttack(AttackRegistry.SECRET_SWORD)) {
            event.pokemon.setForm("ordinary");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPokemonSpawn(SpawnEvent event) {
        if (event.action instanceof SpawnActionPokemon) {
            SpawnActionPokemon spawnPokemon = (SpawnActionPokemon)event.action;
            if (event.action.spawnLocation.types.contains(LocationType.OAS_ROD)) {
                FormLogRegistry.assignRandomFish(spawnPokemon);
            } else if (!(event.action.spawnLocation.types.contains(LocationType.WATER) || event.action.spawnLocation.types.contains(LocationType.SURFACE_WATER) || event.action.spawnLocation.types.contains(LocationType.UNDERGROUND_WATER) || event.action.spawnLocation.types.contains(LocationType.SEAFLOOR) || event.action.spawnLocation.types.contains(LocationType.SEAWEED) || event.action.spawnLocation.types.contains(LocationType.LAVA) || event.action.spawnLocation.types.contains(LocationType.SURFACE_LAVA) || event.action.spawnLocation.types.contains(LocationType.UNDERGROUND_LAVA))) {
                int rodQuality = 0;
                if (event.action.spawnLocation.types.contains(LocationType.SUPREME_ROD_QUALITY)) {
                    rodQuality = 6;
                } else if (event.action.spawnLocation.types.contains(LocationType.PRO_ROD_QUALITY)) {
                    rodQuality = 5;
                } else if (event.action.spawnLocation.types.contains(LocationType.RARE_ROD_QUALITY)) {
                    rodQuality = 4;
                } else if (event.action.spawnLocation.types.contains(LocationType.GREAT_ROD_QUALITY)) {
                    rodQuality = 3;
                } else if (event.action.spawnLocation.types.contains(LocationType.GOOD_ROD_QUALITY)) {
                    rodQuality = 2;
                } else if (event.action.spawnLocation.types.contains(LocationType.SO_SO_ROD_QUALITY)) {
                    rodQuality = 1;
                } else if (event.action.spawnLocation.types.contains(LocationType.OK_ROD_QUALITY)) {
                    rodQuality = 0;
                } else {
                    return;
                }
                Species species = spawnPokemon.pokemon.getSpecies();
                PixelmonEntity pokemon = (PixelmonEntity)spawnPokemon.getOrCreateEntity();
                if (pokemon != null) {
                    String palette = PixelmonPalettes.getJumpPalette(PixelmonSpecies.MAGIKARP.getValueUnsafe(), rodQuality);
                    if (species.is(PixelmonSpecies.MAGIKARP)) {
                        if (CollectionHelper.anyMatch(event.action.spawnLocation.types, Sets.newHashSet((Object[])new LocationType[]{LocationType.OLD_ROD_LAVA, LocationType.GOOD_ROD_LAVA, LocationType.SUPER_ROD_LAVA}))) {
                            pokemon.getPokemon().setPalette("roasted");
                        } else if (palette.equals("karp")) {
                            pokemon.getPokemon().setSpecies(PixelmonSpecies.FEEBAS, true);
                        }
                    }
                    pokemon.getPokemon().setPalette(palette);
                }
            }
        }
    }

    @SubscribeEvent
    public void onReceive(PokemonReceivedEvent event) {
        ServerPlayerEntity player = event.getPlayer();
        PixelmonAdvancements.POKEDEX_TRIGGER.trigger(player);
        if (event.getCause().equals("Starter")) {
            PixelmonAdvancements.STARTER_TRIGGER.trigger(player);
        }
    }
}

