/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.util;

import com.chaosthedude.explorerscompass.client.OverlaySide;
import com.chaosthedude.explorerscompass.config.ConfigHandler;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderUtils {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final FontRenderer fontRenderer = RenderUtils.mc.field_71466_p;

    public static void drawStringLeft(MatrixStack matrixStack, String string, FontRenderer fontRenderer, int x, int y, int color) {
        fontRenderer.func_238405_a_(matrixStack, string, (float)x, (float)y, color);
    }

    public static void drawStringRight(MatrixStack matrixStack, String string, FontRenderer fontRenderer, int x, int y, int color) {
        fontRenderer.func_238405_a_(matrixStack, string, (float)(x - fontRenderer.func_78256_a(string)), (float)y, color);
    }

    public static void drawConfiguredStringOnHUD(MatrixStack matrixStack, String string, int xOffset, int yOffset, int color, int relLineOffset) {
        yOffset += (relLineOffset + (Integer)ConfigHandler.CLIENT.overlayLineOffset.get()) * 9;
        if (ConfigHandler.CLIENT.overlaySide.get() == OverlaySide.LEFT) {
            RenderUtils.drawStringLeft(matrixStack, string, fontRenderer, xOffset + 2, yOffset + 2, color);
        } else {
            RenderUtils.drawStringRight(matrixStack, string, fontRenderer, mc.func_228018_at_().func_198107_o() - xOffset - 2, yOffset + 2, color);
        }
    }

    public static void drawRect(int left, int top, int right, int bottom, int color) {
        int temp;
        if (left < right) {
            temp = left;
            left = right;
            right = temp;
        }
        if (top < bottom) {
            temp = top;
            top = bottom;
            bottom = temp;
        }
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.color4f((float)red, (float)green, (float)blue, (float)alpha);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buffer.func_225582_a_((double)left, (double)bottom, 0.0).func_181675_d();
        buffer.func_225582_a_((double)right, (double)bottom, 0.0).func_181675_d();
        buffer.func_225582_a_((double)right, (double)top, 0.0).func_181675_d();
        buffer.func_225582_a_((double)left, (double)top, 0.0).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }
}

