/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.gui;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.gui.ExplorersCompassScreen;
import com.chaosthedude.explorerscompass.gui.StructureSearchList;
import com.chaosthedude.explorerscompass.util.StructureUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StructureSearchEntry
extends ExtendedList.AbstractListEntry<StructureSearchEntry> {
    private final Minecraft mc;
    private final ExplorersCompassScreen parentScreen;
    private final Structure<?> structure;
    private final StructureSearchList structuresList;
    private long lastClickTime;

    public StructureSearchEntry(StructureSearchList structuresList, Structure<?> structure) {
        this.structuresList = structuresList;
        this.structure = structure;
        this.parentScreen = structuresList.getParentScreen();
        this.mc = Minecraft.func_71410_x();
    }

    public void func_230432_a_(MatrixStack matrixStack, int par1, int par2, int par3, int par4, int par5, int par6, int par7, boolean par8, float par9) {
        this.mc.field_71466_p.func_243248_b(matrixStack, (ITextComponent)new StringTextComponent(StructureUtils.getStructureName(this.structure)), (float)(par3 + 1), (float)(par2 + 1), 0xFFFFFF);
        FontRenderer fontRenderer = this.mc.field_71466_p;
        IFormattableTextComponent iFormattableTextComponent = new TranslationTextComponent("string.explorerscompass.source").func_230529_a_((ITextComponent)new StringTextComponent(": " + StructureUtils.getStructureSource(this.structure)));
        float f = par3 + 1;
        this.mc.field_71466_p.getClass();
        fontRenderer.func_243248_b(matrixStack, (ITextComponent)iFormattableTextComponent, f, (float)(par2 + 9 + 3), 0x808080);
        FontRenderer fontRenderer2 = this.mc.field_71466_p;
        IFormattableTextComponent iFormattableTextComponent2 = new TranslationTextComponent("string.explorerscompass.category").func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_((ITextComponent)new TranslationTextComponent("string.explorerscompass." + this.structure.func_236396_f_().toString().toLowerCase()));
        float f2 = par3 + 1;
        this.mc.field_71466_p.getClass();
        fontRenderer2.func_243248_b(matrixStack, (ITextComponent)iFormattableTextComponent2, f2, (float)(par2 + 9 + 14), 0x808080);
        FontRenderer fontRenderer3 = this.mc.field_71466_p;
        IFormattableTextComponent iFormattableTextComponent3 = new TranslationTextComponent("string.explorerscompass.dimension").func_230529_a_((ITextComponent)new StringTextComponent(": " + StructureUtils.structureDimensionsToString(ExplorersCompass.dimensionsForAllowedStructures.get(this.structure))));
        float f3 = par3 + 1;
        this.mc.field_71466_p.getClass();
        fontRenderer3.func_243248_b(matrixStack, (ITextComponent)iFormattableTextComponent3, f3, (float)(par2 + 9 + 25), 0x808080);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.structuresList.selectStructure(this);
            if (Util.func_211177_b() - this.lastClickTime < 250L) {
                this.searchForBiome();
                return true;
            }
            this.lastClickTime = Util.func_211177_b();
            return false;
        }
        return false;
    }

    public void searchForBiome() {
        this.mc.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        this.parentScreen.searchForStructure(this.structure);
    }
}

