/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.server.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import corgiaoc.byg.BYG;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.ServerWorldInfo;
import net.minecraftforge.fml.ModList;

public class GenDataCommand {
    public static void dataGenCommand(CommandDispatcher<CommandSource> dispatcher) {
        String commandString = "gendata";
        ArrayList modIdList = new ArrayList();
        ModList.get().getMods().forEach(modContainer -> {
            String modId = modContainer.getModId();
            if (!modId.equals("forge")) {
                modIdList.add(modId);
            }
        });
        LiteralCommandNode source = dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)commandString).then(Commands.func_197056_a((String)"modid", (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> ISuggestionProvider.func_197013_a(modIdList.stream(), (SuggestionsBuilder)sb)).executes(cs -> {
            GenDataCommand.createBiomeDatapack((String)cs.getArgument("modid", String.class), (CommandContext<CommandSource>)cs);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)commandString).redirect((CommandNode)source));
    }

    public static void createBiomeDatapack(String modId, CommandContext<CommandSource> commandSource) {
        ArrayList biomeList = new ArrayList();
        boolean stopSpamFlag = false;
        Path dataPackPath = GenDataCommand.dataPackPath(((CommandSource)commandSource.getSource()).func_197023_e().func_73046_m().func_240776_a_(FolderName.field_237251_g_), modId);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        DynamicRegistries manager = ((CommandSource)commandSource.getSource()).func_197023_e().func_241828_r();
        MutableRegistry biomeRegistry = manager.func_243612_b(Registry.field_239720_u_);
        MutableRegistry featuresRegistry = manager.func_243612_b(Registry.field_243552_au);
        MutableRegistry structuresRegistry = manager.func_243612_b(Registry.field_243553_av);
        MutableRegistry carverRegistry = manager.func_243612_b(Registry.field_243551_at);
        MutableRegistry surfaceBuilderRegistry = manager.func_243612_b(Registry.field_243550_as);
        MutableRegistry structureProcessorRegistry = manager.func_243612_b(Registry.field_243554_aw);
        Function dimensionGeneratorSettingsCodec = JsonOps.INSTANCE.withEncoder((Encoder)DimensionGeneratorSettings.field_236201_a_);
        DataResult jsonResult = (DataResult)dimensionGeneratorSettingsCodec.apply(((ServerWorldInfo)((CommandSource)commandSource.getSource()).func_197023_e().func_72912_H()).func_230418_z_());
        try {
            Path worldImportPath = GenDataCommand.worldImportJsonPath(dataPackPath.getParent(), "world_settings");
            Files.createDirectories(worldImportPath.getParent(), new FileAttribute[0]);
            Files.write(worldImportPath, gson.toJson((JsonElement)jsonResult.get().left().get()).getBytes(), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        GenDataCommand.createJson(modId, dataPackPath, gson, surfaceBuilderRegistry, ConfiguredSurfaceBuilder.field_244393_b_);
        GenDataCommand.createJson(modId, dataPackPath, gson, featuresRegistry, ConfiguredFeature.field_236264_b_);
        GenDataCommand.createJson(modId, dataPackPath, gson, carverRegistry, ConfiguredCarver.field_244390_b_);
        GenDataCommand.createJson(modId, dataPackPath, gson, structuresRegistry, StructureFeature.field_244391_b_);
        GenDataCommand.createJson(modId, dataPackPath, gson, structureProcessorRegistry, IStructureProcessorType.field_242922_m);
        GenDataCommand.createBiomeJsonAndPackMcMeta(modId, commandSource, dataPackPath, gson, (Registry<Biome>)biomeRegistry, featuresRegistry, structuresRegistry, carverRegistry, surfaceBuilderRegistry);
    }

    private static void createBiomeJsonAndPackMcMeta(String modId, CommandContext<CommandSource> commandSource, Path dataPackPath, Gson gson, Registry<Biome> biomeRegistry, Registry<ConfiguredFeature<?, ?>> featuresRegistry, Registry<StructureFeature<?, ?>> structuresRegistry, Registry<ConfiguredCarver<?>> carverRegistry, Registry<ConfiguredSurfaceBuilder<?>> surfaceBuilderRegistry) {
        int hits = 0;
        int failedHits = 0;
        for (Map.Entry entry : biomeRegistry.func_239659_c_()) {
            ResourceLocation key = ((RegistryKey)entry.getKey()).func_240901_a_();
            Biome biome = (Biome)entry.getValue();
            if (!key.toString().contains(modId)) continue;
            ++hits;
            Path biomeJsonPath = GenDataCommand.biomeJsonPath(dataPackPath, key, modId);
            Function biomeCodec = JsonOps.INSTANCE.withEncoder((Encoder)Biome.field_235051_b_);
            try {
                Files.createDirectories(biomeJsonPath.getParent(), new FileAttribute[0]);
                Optional optional = ((DataResult)biomeCodec.apply(() -> biome)).result();
                if (optional.isPresent()) {
                    JsonElement root = (JsonElement)optional.get();
                    JsonArray features = new JsonArray();
                    for (List list : biome.func_242440_e().func_242498_c()) {
                        GenerationStage.Carving[] stage = new JsonArray();
                        for (Supplier feature : list) {
                            featuresRegistry.func_230519_c_(feature.get()).ifPresent(arg_0 -> GenDataCommand.lambda$createBiomeJsonAndPackMcMeta$4((JsonArray)stage, arg_0));
                        }
                        features.add((JsonElement)stage);
                    }
                    root.getAsJsonObject().add("features", (JsonElement)features);
                    String surfaceBuilder = ((RegistryKey)surfaceBuilderRegistry.func_230519_c_(biome.func_242440_e().func_242500_d().get()).get()).func_240901_a_().toString();
                    root.getAsJsonObject().addProperty("surface_builder", surfaceBuilder);
                    JsonObject carvers = new JsonObject();
                    for (GenerationStage.Carving step : GenerationStage.Carving.values()) {
                        JsonArray stage = new JsonArray();
                        for (Supplier carver : biome.func_242440_e().func_242489_a(step)) {
                            carverRegistry.func_230519_c_(carver.get()).ifPresent(carverKey -> stage.add(carverKey.func_240901_a_().toString()));
                        }
                        if (stage.size() <= 0) continue;
                        carvers.add(step.func_222671_a(), (JsonElement)stage);
                    }
                    root.getAsJsonObject().add("carvers", (JsonElement)carvers);
                    JsonArray starts = new JsonArray();
                    for (Supplier start : biome.func_242440_e().func_242487_a()) {
                        structuresRegistry.func_230519_c_(start.get()).ifPresent(structureKey -> starts.add(structureKey.func_240901_a_().toString()));
                    }
                    root.getAsJsonObject().add("starts", (JsonElement)starts);
                    Files.write(biomeJsonPath, gson.toJson(root).getBytes(), new OpenOption[0]);
                    continue;
                }
                ++failedHits;
                BYG.LOGGER.warn("No parsable element found for: " + key);
                ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.gendata.failed.parse", new Object[]{key}).func_240700_a_(text -> text.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.RED))), false);
            }
            catch (IOException e) {
                ++failedHits;
                e.printStackTrace();
                ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.gendata.failed.ioexception", new Object[]{key, e.getMessage()}).func_240700_a_(text -> text.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.RED)).func_240713_a_(Boolean.valueOf(true))), false);
            }
        }
        try {
            GenDataCommand.createPackMCMeta(dataPackPath, modId);
        }
        catch (IOException e) {
            ((CommandSource)commandSource.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("commands.gendata.mcmeta.failed", new Object[]{modId}).func_240700_a_(text -> text.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.RED))));
        }
        IFormattableTextComponent filePathText = new StringTextComponent(dataPackPath.toString()).func_240699_a_(TextFormatting.UNDERLINE).func_240700_a_(text -> text.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.GREEN)).func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_FILE, dataPackPath.toString())).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("commands.gendata.hovertext"))));
        IFormattableTextComponent filePathText2 = new StringTextComponent("https://github.com/CorgiTaco/BYG/issues/194").func_240699_a_(TextFormatting.UNDERLINE).func_240700_a_(text -> text.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.DARK_RED)).func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/CorgiTaco/BYG/issues/194")).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("commands.gendata.hovertext.link"))));
        if (failedHits > 0) {
            ((CommandSource)commandSource.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("commands.gendata.failed.parse.recommend.new.world", new Object[]{filePathText2}).func_240700_a_(text -> text.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.RED)).func_240713_a_(Boolean.valueOf(true))));
        }
        if (hits > 0) {
            ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.gendata.success", new Object[]{commandSource.getArgument("modid", String.class), filePathText}), false);
        } else {
            ((CommandSource)commandSource.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("commands.gendata.listisempty", new Object[]{modId}).func_240700_a_(text -> text.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.RED))));
        }
    }

    private static <T> void createJson(String modId, Path dataPackPath, Gson gson, Registry<T> registry, Codec<Supplier<T>> encoder) {
        for (Map.Entry entry : registry.func_239659_c_()) {
            Optional optional;
            Function featureCodec = JsonOps.INSTANCE.withEncoder(encoder);
            Object object = entry.getValue();
            if (!((RegistryKey)entry.getKey()).func_240901_a_().toString().contains(modId) || object == null || !Objects.requireNonNull(registry.func_177774_c(object)).toString().contains(modId) || !(optional = ((DataResult)featureCodec.apply(() -> object)).result()).isPresent()) continue;
            try {
                Path cfPath = GenDataCommand.createPath(dataPackPath, Objects.requireNonNull(registry.func_177774_c(object)), modId, registry.func_243578_f());
                Files.createDirectories(cfPath.getParent(), new FileAttribute[0]);
                Files.write(cfPath, gson.toJson((JsonElement)optional.get()).getBytes(), new OpenOption[0]);
            }
            catch (IOException iOException) {}
        }
    }

    private static Path worldImportJsonPath(Path path, String jsonName) {
        return path.resolve("import/" + jsonName + ".json");
    }

    private static <T> Path createPath(Path path, ResourceLocation identifier, String modId, RegistryKey<? extends Registry<T>> registry) {
        return path.resolve("data/" + modId + "/" + registry.func_240901_a_().toString().replace("minecraft:", "") + "/" + identifier.func_110623_a() + ".json");
    }

    private static Path biomeJsonPath(Path path, ResourceLocation identifier, String modId) {
        return path.resolve("data/" + modId + "/worldgen/biome/" + identifier.func_110623_a() + ".json");
    }

    private static Path dataPackPath(Path path, String modId) {
        return path.resolve("gendata/" + modId + "-custom");
    }

    private static void createPackMCMeta(Path dataPackPath, String modID) throws IOException {
        String fileString = "{\n\t\"pack\":{\n\t\t\"pack_format\": 6,\n\t\t\"description\": \"Custom biome datapack for " + modID + ".\"\n\t}\n}\n";
        Files.write(dataPackPath.resolve("pack.mcmeta"), fileString.getBytes(), new OpenOption[0]);
    }

    private static /* synthetic */ void lambda$createBiomeJsonAndPackMcMeta$4(JsonArray stage, RegistryKey featureKey) {
        stage.add(featureKey.func_240901_a_().toString());
    }
}

