/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.loadingrequirement.v2.internal;

import de.keksuccino.fancymenu.menu.loadingrequirement.v2.internal.LegacyRequirementConverter;
import de.keksuccino.fancymenu.menu.loadingrequirement.v2.internal.LoadingRequirementGroup;
import de.keksuccino.fancymenu.menu.loadingrequirement.v2.internal.LoadingRequirementInstance;
import de.keksuccino.konkrete.properties.PropertiesSection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoadingRequirementContainer {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final List<LoadingRequirementGroup> groups = new ArrayList<LoadingRequirementGroup>();
    protected final List<LoadingRequirementInstance> instances = new ArrayList<LoadingRequirementInstance>();
    public boolean forceRequirementsMet = false;
    public boolean forceRequirementsNotMet = false;

    public boolean requirementsMet() {
        if (this.forceRequirementsMet) {
            return true;
        }
        if (this.forceRequirementsNotMet) {
            return false;
        }
        try {
            for (LoadingRequirementGroup g : this.groups) {
                if (g.requirementsMet()) continue;
                return false;
            }
            for (LoadingRequirementInstance i : this.instances) {
                if (i.requirementMet()) continue;
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.error("[FANCYMENU] Error while checking LoadingRequirements of LoadingRequirementContainer!");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public LoadingRequirementGroup createAndAddGroup(String identifier, LoadingRequirementGroup.GroupMode mode) {
        if (!this.groupExists(identifier)) {
            LoadingRequirementGroup g = new LoadingRequirementGroup(identifier, mode, this);
            this.groups.add(g);
            return g;
        }
        return null;
    }

    public boolean addGroup(LoadingRequirementGroup group) {
        if (!this.groupExists(group.identifier)) {
            this.groups.add(group);
            return true;
        }
        return false;
    }

    public List<LoadingRequirementGroup> getGroups() {
        return new ArrayList<LoadingRequirementGroup>(this.groups);
    }

    public LoadingRequirementGroup getGroup(String identifier) {
        for (LoadingRequirementGroup g : this.groups) {
            if (!g.identifier.equals(identifier)) continue;
            return g;
        }
        return null;
    }

    public boolean groupExists(String identifier) {
        return this.getGroup(identifier) != null;
    }

    public boolean removeGroup(LoadingRequirementGroup group) {
        return this.groups.remove(group);
    }

    public boolean removeGroupByIdentifier(String identifier) {
        LoadingRequirementGroup g = this.getGroup(identifier);
        if (g != null) {
            return this.groups.remove(g);
        }
        return false;
    }

    public boolean addInstance(LoadingRequirementInstance instance) {
        if (!this.instances.contains(instance)) {
            this.instances.add(instance);
            return true;
        }
        return false;
    }

    public boolean removeInstance(LoadingRequirementInstance instance) {
        return this.instances.remove(instance);
    }

    public List<LoadingRequirementInstance> getInstances() {
        return new ArrayList<LoadingRequirementInstance>(this.instances);
    }

    public void serializeContainerToExistingPropertiesSection(PropertiesSection target) {
        PropertiesSection sec = LoadingRequirementContainer.serializeRequirementContainer(this);
        for (Map.Entry m : sec.getEntries().entrySet()) {
            target.addEntry((String)m.getKey(), (String)m.getValue());
        }
    }

    public static PropertiesSection serializeRequirementContainer(LoadingRequirementContainer container) {
        PropertiesSection sec = new PropertiesSection("loading_requirement_container");
        for (LoadingRequirementGroup g : container.groups) {
            PropertiesSection sg = LoadingRequirementGroup.serializeRequirementGroup(g);
            for (Map.Entry m : sg.getEntries().entrySet()) {
                sec.addEntry((String)m.getKey(), (String)m.getValue());
            }
        }
        for (LoadingRequirementInstance i : container.instances) {
            List<String> l = LoadingRequirementInstance.serializeRequirementInstance(i);
            sec.addEntry(l.get(0), l.get(1));
        }
        return sec;
    }

    public static LoadingRequirementContainer deserializeRequirementContainer(PropertiesSection sec) {
        LoadingRequirementContainer c = new LoadingRequirementContainer();
        for (Map.Entry m : sec.getEntries().entrySet()) {
            LoadingRequirementGroup g;
            if (!((String)m.getKey()).startsWith("[loading_requirement_group:") || (g = LoadingRequirementGroup.deserializeRequirementGroup((String)m.getKey(), (String)m.getValue(), c)) == null) continue;
            c.addGroup(g);
        }
        for (Map.Entry m : sec.getEntries().entrySet()) {
            LoadingRequirementInstance i;
            if (!((String)m.getKey()).startsWith("[loading_requirement:") || (i = LoadingRequirementInstance.deserializeRequirementInstance((String)m.getKey(), (String)m.getValue(), c)) == null) continue;
            if (i.group != null) {
                i.group.addInstance(i);
                continue;
            }
            c.addInstance(i);
        }
        LegacyRequirementConverter.deserializeLegacyAndAddTo(sec, c);
        return c;
    }
}

