/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item.items.playerentity.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import de.keksuccino.fancymenu.menu.fancy.item.items.playerentity.render.PlayerEntityModel;
import de.keksuccino.fancymenu.menu.fancy.item.items.playerentity.render.PlayerEntityProperties;
import de.keksuccino.fancymenu.menu.fancy.item.items.playerentity.render.layers.PlayerEntityCapeLayer;
import de.keksuccino.fancymenu.menu.fancy.item.items.playerentity.render.layers.PlayerEntityRenderLayer;
import de.keksuccino.fancymenu.menu.fancy.item.items.playerentity.render.layers.PlayerEntityShoulderParrotLayer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlayerEntityItemRenderer
extends PlayerRenderer {
    private static final EntityRendererManager RENDER_CONTEXT = new EntityRendererManager(Minecraft.func_71410_x().field_71446_o, Minecraft.func_71410_x().func_175599_af(), (IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G(), Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().field_71474_y);
    public final PlayerEntityProperties properties;
    public final PlayerEntityModel playerModel;

    public PlayerEntityItemRenderer(boolean slim) {
        super(RENDER_CONTEXT, slim);
        this.properties = new PlayerEntityProperties(slim);
        this.playerModel = new PlayerEntityModel(0.0f, slim, this.properties);
        this.func_177094_a(new PlayerEntityShoulderParrotLayer(this, this.properties));
        this.func_177094_a(new PlayerEntityCapeLayer(this, this.properties));
    }

    public void renderPlayerEntityItem(double d11, double d12, double d13, float f11, float f12, MatrixStack matrix, IRenderTypeBuffer bufferSource, int i11) {
        try {
            Vector3d vec3 = this.func_225627_b_((AbstractClientPlayerEntity)null, f12);
            double d2 = d11 + vec3.func_82615_a();
            double d3 = d12 + vec3.func_82617_b();
            double d0 = d13 + vec3.func_82616_c();
            matrix.func_227860_a_();
            matrix.func_227861_a_(d2, d3, d0);
            this.render(f11, f12, matrix, bufferSource, i11);
            matrix.func_227861_a_(-vec3.func_82615_a(), -vec3.func_82617_b(), -vec3.func_82616_c());
            matrix.func_227865_b_();
        }
        catch (Exception ex) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)ex, (String)"FancyMenu: Rendering player entity item");
            CrashReportCategory crashreportcategory1 = crashreport.func_85058_a("Renderer details");
            crashreportcategory1.func_71507_a("Rotation", (Object)Float.valueOf(f11));
            crashreportcategory1.func_71507_a("Delta", (Object)Float.valueOf(f12));
            throw new ReportedException(crashreport);
        }
    }

    protected void render(float f11, float f12, MatrixStack matrix, IRenderTypeBuffer bufferSource, int i11) {
        this.setModelProperties();
        this.innerRender(f11, f12, matrix, bufferSource, i11);
    }

    protected void innerRender(float f11, float f12, MatrixStack matrix, IRenderTypeBuffer bufferSource, int i11) {
        Direction direction;
        boolean shouldSit;
        matrix.func_227860_a_();
        this.playerModel.field_217113_d = shouldSit = this.properties.shouldSit;
        this.playerModel.field_217114_e = this.properties.isBaby;
        float f = MathHelper.func_219805_h((float)f12, (float)this.properties.yBodyRotO, (float)this.properties.yBodyRot);
        float f1 = MathHelper.func_219805_h((float)f12, (float)this.properties.yHeadRotO, (float)this.properties.yHeadRot);
        float f2 = f1 - f;
        float f6 = MathHelper.func_219799_g((float)f12, (float)this.properties.xRotO, (float)this.properties.xRot);
        if (this.properties.hasPose(Pose.SLEEPING) && (direction = this.properties.getBedOrientation()) != null) {
            float f4 = this.properties.getEyeHeight(Pose.STANDING) - 0.1f;
            matrix.func_227861_a_((double)((float)(-direction.func_82601_c()) * f4), 0.0, (double)((float)(-direction.func_82599_e()) * f4));
        }
        float f7 = f12;
        this.setupRotations(matrix, f7, f, f12);
        matrix.func_227862_a_(-1.0f, -1.0f, 1.0f);
        this.scale(matrix, f12);
        matrix.func_227861_a_(0.0, (double)-1.501f, 0.0);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit) {
            f8 = MathHelper.func_219799_g((float)f12, (float)this.properties.animationSpeedOld, (float)this.properties.animationSpeed);
            f5 = this.properties.animationPosition - this.properties.animationSpeed * (1.0f - f12);
            if (this.properties.isBaby) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        this.playerModel.setupAnimWithoutEntity(f5, f8, f7, f2, f6);
        Minecraft minecraft = Minecraft.func_71410_x();
        boolean flag = !this.properties.invisible;
        boolean flag1 = false;
        boolean glowing = this.properties.glowing;
        RenderType rendertype = this.getRenderType(null, flag, flag1, glowing);
        if (rendertype != null) {
            IVertexBuilder vertexconsumer = bufferSource.getBuffer(rendertype);
            int i = OverlayTexture.func_229201_a_((int)OverlayTexture.func_229199_a_((float)this.func_225625_b_(null, f12)), (int)OverlayTexture.func_229202_a_((boolean)false));
            this.playerModel.func_225598_a_(matrix, vertexconsumer, i11, i, 1.0f, 1.0f, 1.0f, flag1 ? 0.15f : 1.0f);
        }
        if (!this.properties.isSpectator()) {
            for (LayerRenderer renderlayer : this.field_177097_h) {
                if (!(renderlayer instanceof PlayerEntityRenderLayer)) continue;
                renderlayer.func_225628_a_(matrix, bufferSource, i11, null, f5, f8, f12, f7, f2, f6);
            }
        }
        matrix.func_227865_b_();
        if (this.properties.showDisplayName) {
            this.func_225629_a_((AbstractClientPlayerEntity)null, this.properties.displayName, matrix, bufferSource, i11);
        }
    }

    protected void scale(MatrixStack matrix, float f11) {
        float f = 0.9375f;
        matrix.func_227862_a_(0.9375f, 0.9375f, 0.9375f);
    }

    private void setModelProperties() {
        PlayerEntityModel playermodel = this.playerModel;
        if (this.properties.isSpectator()) {
            playermodel.func_178719_a(false);
            playermodel.field_78116_c.field_78806_j = true;
            playermodel.field_178720_f.field_78806_j = true;
        } else {
            playermodel.func_178719_a(true);
            playermodel.field_178720_f.field_78806_j = this.properties.isModelPartShown(PlayerModelPart.HAT);
            playermodel.field_178730_v.field_78806_j = this.properties.isModelPartShown(PlayerModelPart.JACKET);
            playermodel.field_178733_c.field_78806_j = this.properties.isModelPartShown(PlayerModelPart.LEFT_PANTS_LEG);
            playermodel.field_178731_d.field_78806_j = this.properties.isModelPartShown(PlayerModelPart.RIGHT_PANTS_LEG);
            playermodel.field_178734_a.field_78806_j = this.properties.isModelPartShown(PlayerModelPart.LEFT_SLEEVE);
            playermodel.field_178732_b.field_78806_j = this.properties.isModelPartShown(PlayerModelPart.RIGHT_SLEEVE);
            playermodel.field_228270_o_ = this.properties.isCrouching();
            BipedModel.ArmPose humanoidmodel$armpose = PlayerEntityItemRenderer.getArmPose(this.properties, Hand.MAIN_HAND);
            BipedModel.ArmPose humanoidmodel$armpose1 = PlayerEntityItemRenderer.getArmPose(this.properties, Hand.OFF_HAND);
            if (humanoidmodel$armpose.func_241657_a_()) {
                BipedModel.ArmPose armPose = humanoidmodel$armpose1 = this.properties.getOffhandItem().func_190926_b() ? BipedModel.ArmPose.EMPTY : BipedModel.ArmPose.ITEM;
            }
            if (this.properties.getMainArm() == HandSide.RIGHT) {
                playermodel.field_187076_m = humanoidmodel$armpose;
                playermodel.field_187075_l = humanoidmodel$armpose1;
            } else {
                playermodel.field_187076_m = humanoidmodel$armpose1;
                playermodel.field_187075_l = humanoidmodel$armpose;
            }
        }
    }

    private static BipedModel.ArmPose getArmPose(PlayerEntityProperties props, Hand interactionHand) {
        ItemStack itemstack = props.getItemInHand(interactionHand);
        if (itemstack.func_190926_b()) {
            return BipedModel.ArmPose.EMPTY;
        }
        if (props.getUsedItemHand() == interactionHand && props.getUseItemRemainingTicks() > 0L) {
            UseAction useanim = itemstack.func_77975_n();
            if (useanim == UseAction.BLOCK) {
                return BipedModel.ArmPose.BLOCK;
            }
            if (useanim == UseAction.BOW) {
                return BipedModel.ArmPose.BOW_AND_ARROW;
            }
            if (useanim == UseAction.SPEAR) {
                return BipedModel.ArmPose.THROW_SPEAR;
            }
            if (useanim == UseAction.CROSSBOW && interactionHand == props.getUsedItemHand()) {
                return BipedModel.ArmPose.CROSSBOW_CHARGE;
            }
        } else if (itemstack.func_77973_b() instanceof CrossbowItem && CrossbowItem.func_220012_d((ItemStack)itemstack)) {
            return BipedModel.ArmPose.CROSSBOW_HOLD;
        }
        return BipedModel.ArmPose.ITEM;
    }

    public Vector3d func_225627_b_(AbstractClientPlayerEntity p_225627_1_, float p_225627_2_) {
        return this.properties.isCrouching() ? new Vector3d(0.0, -0.125, 0.0) : Vector3d.field_186680_a;
    }

    protected RenderType getRenderType(AbstractClientPlayerEntity entity, boolean visible, boolean isVisibleToPlayer, boolean glowing) {
        ResourceLocation resourcelocation = this.func_110775_a(entity);
        if (isVisibleToPlayer) {
            return RenderType.func_239268_f_((ResourceLocation)resourcelocation);
        }
        if (visible) {
            return this.playerModel.func_228282_a_(resourcelocation);
        }
        return glowing ? RenderType.func_228654_j_((ResourceLocation)resourcelocation) : null;
    }

    public ResourceLocation func_110775_a(AbstractClientPlayerEntity entity) {
        return this.properties.getSkinTextureLocation();
    }

    protected void func_225629_a_(AbstractClientPlayerEntity entity, ITextComponent content, MatrixStack matrix, IRenderTypeBuffer bufferSource, int p_114502_) {
        boolean flag = !this.properties.isCrouching();
        float f = this.properties.getDimensions().field_220316_b + 0.5f;
        boolean i = false;
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.0, (double)f, 0.0);
        matrix.func_227862_a_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        float f1 = Minecraft.func_71410_x().field_71474_y.func_216840_a(0.25f);
        int j = (int)(f1 * 255.0f) << 24;
        FontRenderer font = this.func_76983_a();
        float f2 = -font.func_238414_a_((ITextProperties)content) / 2;
        font.func_243247_a(content, f2, (float)i, 0x20FFFFFF, false, matrix4f, bufferSource, flag, j, p_114502_);
        if (flag) {
            font.func_243247_a(content, f2, (float)i, -1, false, matrix4f, bufferSource, false, 0, p_114502_);
        }
        matrix.func_227865_b_();
    }

    protected void setupRotations(MatrixStack matrix, float f11, float f12, float f13) {
        if (!this.properties.hasPose(Pose.SLEEPING)) {
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - f12));
        }
    }
}

