/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.loadingrequirement;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.loadingrequirement.BuildRequirementGroupScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.loadingrequirement.BuildRequirementScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.ConfirmationScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.UIBase;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollarea.entry.TextListScrollAreaEntry;
import de.keksuccino.fancymenu.menu.loadingrequirement.v2.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.menu.loadingrequirement.v2.internal.LoadingRequirementGroup;
import de.keksuccino.fancymenu.menu.loadingrequirement.v2.internal.LoadingRequirementInstance;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;

public class ManageRequirementsScreen
extends Screen {
    protected Screen parentScreen;
    protected LoadingRequirementContainer container;
    protected Consumer<LoadingRequirementContainer> callback;
    protected ScrollArea requirementsScrollArea = new ScrollArea(0, 0, 0, 0);
    protected AdvancedButton addRequirementButton;
    protected AdvancedButton addGroupButton;
    protected AdvancedButton editButton;
    protected AdvancedButton removeButton;
    protected AdvancedButton doneButton;

    public ManageRequirementsScreen(Screen parentScreen, LoadingRequirementContainer container, Consumer<LoadingRequirementContainer> callback) {
        super((ITextComponent)new StringTextComponent(Locals.localize((String)"fancymenu.editor.loading_requirement.screens.manage_screen.manage", (String[])new String[0])));
        this.parentScreen = parentScreen;
        this.container = container;
        this.callback = callback;
        this.updateRequirementsScrollArea();
        this.addRequirementButton = new AdvancedButton(0, 0, 150, 20, Locals.localize((String)"fancymenu.editor.loading_requirement.screens.add_requirement", (String[])new String[0]), true, button -> {
            BuildRequirementScreen s = new BuildRequirementScreen(this, this.container, null, call -> {
                if (call != null) {
                    this.container.addInstance((LoadingRequirementInstance)call);
                    this.updateRequirementsScrollArea();
                }
            });
            Minecraft.func_71410_x().func_147108_a((Screen)s);
        });
        this.addRequirementButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.loading_requirement.screens.manage_screen.add_requirement.desc", (String[])new String[0]), (String)"%n%"));
        UIBase.applyDefaultButtonSkinTo(this.addRequirementButton);
        this.addGroupButton = new AdvancedButton(0, 0, 150, 20, Locals.localize((String)"fancymenu.editor.loading_requirement.screens.add_group", (String[])new String[0]), true, button -> {
            BuildRequirementGroupScreen s = new BuildRequirementGroupScreen(this, this.container, null, call -> {
                if (call != null) {
                    this.container.addGroup((LoadingRequirementGroup)call);
                    this.updateRequirementsScrollArea();
                }
            });
            Minecraft.func_71410_x().func_147108_a((Screen)s);
        });
        this.addGroupButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.loading_requirement.screens.manage_screen.add_group.desc", (String[])new String[0]), (String)"%n%"));
        UIBase.applyDefaultButtonSkinTo(this.addGroupButton);
        this.editButton = new AdvancedButton(0, 0, 150, 20, "", true, button -> {
            Screen s = null;
            if (this.isInstanceSelected()) {
                s = new BuildRequirementScreen(this, this.container, this.getSelectedInstance(), call -> {
                    if (call != null) {
                        this.updateRequirementsScrollArea();
                    }
                });
            } else if (this.isGroupSelected()) {
                s = new BuildRequirementGroupScreen(this, this.container, this.getSelectedGroup(), call -> {
                    if (call != null) {
                        this.updateRequirementsScrollArea();
                    }
                });
            }
            if (s != null) {
                Minecraft.func_71410_x().func_147108_a(s);
            }
        }){

            public void func_230430_a_(MatrixStack p_93657_, int p_93658_, int p_93659_, float p_93660_) {
                ManageRequirementsScreen s = ManageRequirementsScreen.this;
                if (!s.isInstanceSelected() && !s.isGroupSelected()) {
                    this.setMessage(Locals.localize((String)"fancymenu.editor.loading_requirement.screens.manage_screen.edit.generic", (String[])new String[0]));
                    this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.loading_requirement.screens.manage_screen.no_entry_selected", (String[])new String[0]), (String)"%n%"));
                    this.field_230693_o_ = false;
                } else {
                    if (s.isInstanceSelected()) {
                        this.setMessage(Locals.localize((String)"fancymenu.editor.loading_requirement.screens.edit_requirement", (String[])new String[0]));
                    } else {
                        this.setMessage(Locals.localize((String)"fancymenu.editor.loading_requirement.screens.edit_group", (String[])new String[0]));
                    }
                    this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.loading_requirement.screens.manage_screen.edit.desc", (String[])new String[0]), (String)"%n%"));
                    this.field_230693_o_ = true;
                }
                super.func_230430_a_(p_93657_, p_93658_, p_93659_, p_93660_);
            }
        };
        UIBase.applyDefaultButtonSkinTo(this.editButton);
        this.removeButton = new AdvancedButton(0, 0, 150, 20, "", true, button -> {
            ConfirmationScreen s = null;
            if (this.isInstanceSelected()) {
                LoadingRequirementInstance i = this.getSelectedInstance();
                s = new ConfirmationScreen(this, call -> {
                    if (call.booleanValue()) {
                        this.container.removeInstance(i);
                        this.updateRequirementsScrollArea();
                    }
                }, StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.loading_requirement.screens.remove_requirement.confirm", (String[])new String[0]), (String)"%n%"));
            } else if (this.isGroupSelected()) {
                LoadingRequirementGroup g = this.getSelectedGroup();
                s = new ConfirmationScreen(this, call -> {
                    if (call.booleanValue()) {
                        this.container.removeGroup(g);
                        this.updateRequirementsScrollArea();
                    }
                }, StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.loading_requirement.screens.remove_group.confirm", (String[])new String[0]), (String)"%n%"));
            }
            if (s != null) {
                Minecraft.func_71410_x().func_147108_a(s);
            }
        }){

            public void func_230430_a_(MatrixStack p_93657_, int p_93658_, int p_93659_, float p_93660_) {
                ManageRequirementsScreen s = ManageRequirementsScreen.this;
                if (!s.isInstanceSelected() && !s.isGroupSelected()) {
                    this.setMessage(Locals.localize((String)"fancymenu.editor.loading_requirement.screens.manage_screen.remove.generic", (String[])new String[0]));
                    this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.loading_requirement.screens.manage_screen.no_entry_selected", (String[])new String[0]), (String)"%n%"));
                    this.field_230693_o_ = false;
                } else {
                    if (s.isInstanceSelected()) {
                        this.setMessage(Locals.localize((String)"fancymenu.editor.loading_requirement.screens.remove_requirement", (String[])new String[0]));
                    } else {
                        this.setMessage(Locals.localize((String)"fancymenu.editor.loading_requirement.screens.remove_group", (String[])new String[0]));
                    }
                    this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.loading_requirement.screens.manage_screen.remove.desc", (String[])new String[0]), (String)"%n%"));
                    this.field_230693_o_ = true;
                }
                super.func_230430_a_(p_93657_, p_93658_, p_93659_, p_93660_);
            }
        };
        UIBase.applyDefaultButtonSkinTo(this.removeButton);
        this.doneButton = new AdvancedButton(0, 0, 150, 20, Locals.localize((String)"fancymenu.guicomponents.done", (String[])new String[0]), true, button -> {
            Minecraft.func_71410_x().func_147108_a(this.parentScreen);
            this.callback.accept(this.container);
        });
        UIBase.applyDefaultButtonSkinTo(this.doneButton);
    }

    protected void func_231160_c_() {
        Minecraft.func_71410_x().func_228018_at_().func_216525_a((double)Minecraft.func_71410_x().func_228018_at_().func_216521_a(Minecraft.func_71410_x().field_71474_y.field_74335_Z, Minecraft.func_71410_x().func_211821_e()));
        this.field_230709_l_ = Minecraft.func_71410_x().func_228018_at_().func_198087_p();
        this.field_230708_k_ = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
        super.func_231160_c_();
    }

    public void func_231175_as__() {
        Minecraft.func_71410_x().func_147108_a(this.parentScreen);
        this.callback.accept(this.container);
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partial) {
        ManageRequirementsScreen.func_238467_a_((MatrixStack)matrix, (int)0, (int)0, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)UIBase.SCREEN_BACKGROUND_COLOR.getRGB());
        IFormattableTextComponent titleComp = this.field_230704_d_.func_230532_e_().func_240703_c_(Style.field_240709_b_.func_240713_a_(Boolean.valueOf(true)));
        this.field_230712_o_.func_243248_b(matrix, (ITextComponent)titleComp, 20.0f, 20.0f, -1);
        this.field_230712_o_.func_238421_b_(matrix, Locals.localize((String)"fancymenu.editor.loading_requirement.screens.manage_screen.requirements_and_groups", (String[])new String[0]), 20.0f, 50.0f, -1);
        this.requirementsScrollArea.setWidth(this.field_230708_k_ - 20 - 150 - 20 - 20, true);
        this.requirementsScrollArea.setHeight(this.field_230709_l_ - 85, true);
        this.requirementsScrollArea.setX(20, true);
        this.requirementsScrollArea.setY(65, true);
        this.requirementsScrollArea.render(matrix, mouseX, mouseY, partial);
        this.doneButton.setX(this.field_230708_k_ - 20 - this.doneButton.func_230998_h_());
        this.doneButton.setY(this.field_230709_l_ - 20 - 20);
        this.doneButton.func_230430_a_(matrix, mouseX, mouseY, partial);
        this.removeButton.setX(this.field_230708_k_ - 20 - this.removeButton.func_230998_h_());
        this.removeButton.setY(this.doneButton.getY() - 15 - 20);
        this.removeButton.func_230430_a_(matrix, mouseX, mouseY, partial);
        this.editButton.setX(this.field_230708_k_ - 20 - this.editButton.func_230998_h_());
        this.editButton.setY(this.removeButton.getY() - 5 - 20);
        this.editButton.func_230430_a_(matrix, mouseX, mouseY, partial);
        this.addGroupButton.setX(this.field_230708_k_ - 20 - this.addGroupButton.func_230998_h_());
        this.addGroupButton.setY(this.editButton.getY() - 5 - 20);
        this.addGroupButton.func_230430_a_(matrix, mouseX, mouseY, partial);
        this.addRequirementButton.setX(this.field_230708_k_ - 20 - this.addRequirementButton.func_230998_h_());
        this.addRequirementButton.setY(this.addGroupButton.getY() - 5 - 20);
        this.addRequirementButton.func_230430_a_(matrix, mouseX, mouseY, partial);
        super.func_230430_a_(matrix, mouseX, mouseY, partial);
    }

    protected LoadingRequirementInstance getSelectedInstance() {
        ScrollAreaEntry e = this.requirementsScrollArea.getFocusedEntry();
        if (e instanceof RequirementInstanceEntry) {
            return ((RequirementInstanceEntry)e).instance;
        }
        return null;
    }

    protected boolean isInstanceSelected() {
        return this.getSelectedInstance() != null;
    }

    protected LoadingRequirementGroup getSelectedGroup() {
        ScrollAreaEntry e = this.requirementsScrollArea.getFocusedEntry();
        if (e instanceof RequirementGroupEntry) {
            return ((RequirementGroupEntry)e).group;
        }
        return null;
    }

    protected boolean isGroupSelected() {
        return this.getSelectedGroup() != null;
    }

    protected void updateRequirementsScrollArea() {
        ScrollAreaEntry e;
        this.requirementsScrollArea.clearEntries();
        for (LoadingRequirementGroup g : this.container.getGroups()) {
            e = new RequirementGroupEntry(this.requirementsScrollArea, g);
            this.requirementsScrollArea.addEntry(e);
        }
        for (LoadingRequirementInstance i : this.container.getInstances()) {
            e = new RequirementInstanceEntry(this.requirementsScrollArea, i, 14);
            this.requirementsScrollArea.addEntry(e);
        }
    }

    public static class RequirementInstanceEntry
    extends ScrollAreaEntry {
        public static final int HEADER_FOOTER_HEIGHT = 3;
        public LoadingRequirementInstance instance;
        public final int lineHeight;
        public FontRenderer font;
        private IFormattableTextComponent displayNameComponent;
        private IFormattableTextComponent modeComponent;
        private IFormattableTextComponent valueComponent;

        public RequirementInstanceEntry(ScrollArea parent, LoadingRequirementInstance instance, int lineHeight) {
            super(parent, 100, 30);
            this.font = Minecraft.func_71410_x().field_71466_p;
            this.instance = instance;
            this.lineHeight = lineHeight;
            this.displayNameComponent = new StringTextComponent(this.instance.requirement.getDisplayName()).func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)TEXT_COLOR_GRAY_1.getRGB())));
            String modeString = this.instance.mode == LoadingRequirementInstance.RequirementMode.IF ? Locals.localize((String)"fancymenu.editor.loading_requirement.screens.requirement.info.mode.normal", (String[])new String[0]) : Locals.localize((String)"fancymenu.editor.loading_requirement.screens.requirement.info.mode.opposite", (String[])new String[0]);
            this.modeComponent = new StringTextComponent(Locals.localize((String)"fancymenu.editor.loading_requirement.screens.requirement.info.mode", (String[])new String[0]) + " ").func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)TEXT_COLOR_GRAY_1.getRGB()))).func_230529_a_((ITextComponent)new StringTextComponent(modeString).func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)TEXT_COLOR_GREY_4.getRGB()))));
            String valueString = this.instance.value != null ? this.instance.value : Locals.localize((String)"fancymenu.editor.loading_requirement.screens.requirement.info.value.none", (String[])new String[0]);
            this.valueComponent = new StringTextComponent(Locals.localize((String)"fancymenu.editor.loading_requirement.screens.requirement.info.value", (String[])new String[0]) + " ").func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)TEXT_COLOR_GRAY_1.getRGB()))).func_230529_a_((ITextComponent)new StringTextComponent(valueString).func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)TEXT_COLOR_GREY_4.getRGB()))));
            this.setWidth(this.calculateWidth());
            this.setHeight(lineHeight * 3 + 6);
        }

        @Override
        public void render(MatrixStack matrix, int mouseX, int mouseY, float partial) {
            super.render(matrix, mouseX, mouseY, partial);
            int centerYLine1 = this.getY() + 3 + this.lineHeight / 2;
            int centerYLine2 = this.getY() + 3 + this.lineHeight / 2 * 3;
            int centerYLine3 = this.getY() + 3 + this.lineHeight / 2 * 5;
            RenderSystem.enableBlend();
            RequirementInstanceEntry.renderListingDot(matrix, this.getX() + 5, centerYLine1 - 2, LISTING_DOT_RED);
            float f = this.getX() + 5 + 4 + 3;
            this.font.getClass();
            this.font.func_243248_b(matrix, (ITextComponent)this.displayNameComponent, f, (float)(centerYLine1 - 9 / 2), -1);
            RequirementInstanceEntry.renderListingDot(matrix, this.getX() + 5 + 4 + 3, centerYLine2 - 2, LISTING_DOT_BLUE);
            float f2 = this.getX() + 5 + 4 + 3 + 4 + 3;
            this.font.getClass();
            this.font.func_243248_b(matrix, (ITextComponent)this.modeComponent, f2, (float)(centerYLine2 - 9 / 2), -1);
            RequirementInstanceEntry.renderListingDot(matrix, this.getX() + 5 + 4 + 3, centerYLine3 - 2, LISTING_DOT_BLUE);
            float f3 = this.getX() + 5 + 4 + 3 + 4 + 3;
            this.font.getClass();
            this.font.func_243248_b(matrix, (ITextComponent)this.valueComponent, f3, (float)(centerYLine3 - 9 / 2), -1);
        }

        private int calculateWidth() {
            int w = 12 + this.font.func_238414_a_((ITextProperties)this.displayNameComponent) + 5;
            int w2 = 19 + this.font.func_238414_a_((ITextProperties)this.modeComponent) + 5;
            int w3 = 19 + this.font.func_238414_a_((ITextProperties)this.valueComponent) + 5;
            if (w2 > w) {
                w = w2;
            }
            if (w3 > w) {
                w = w3;
            }
            return w;
        }

        @Override
        public void onClick(ScrollAreaEntry entry) {
        }
    }

    public static class RequirementGroupEntry
    extends TextListScrollAreaEntry {
        public static final int HEADER_FOOTER_HEIGHT = 3;
        public LoadingRequirementGroup group;

        public RequirementGroupEntry(ScrollArea parent, LoadingRequirementGroup group) {
            super(parent, (ITextComponent)new StringTextComponent(group.identifier).func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)TEXT_COLOR_GRAY_1.getRGB()))).func_230529_a_((ITextComponent)new StringTextComponent(" (" + Locals.localize((String)"fancymenu.editor.loading_requirement.screens.manage_screen.group.info", (String[])new String[]{"" + group.getInstances().size()}) + ")").func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)TEXT_COLOR_GREY_4.getRGB())))), LISTING_DOT_ORANGE, entry -> {});
            this.group = group;
            this.setHeight(this.getHeight() + 6);
        }
    }
}

