/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.actions;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.api.buttonaction.ButtonActionContainer;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.actions.BuildActionScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.ConfirmationScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.UIBase;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;

public class ManageActionsScreen
extends Screen {
    protected Screen parentScreen;
    protected List<ActionInstance> instances;
    protected ScrollArea actionsScrollArea = new ScrollArea(0, 0, 0, 0);
    protected Consumer<List<ActionInstance>> callback;
    protected AdvancedButton addActionButton;
    protected AdvancedButton moveUpButton;
    protected AdvancedButton moveDownButton;
    protected AdvancedButton editButton;
    protected AdvancedButton removeButton;
    protected AdvancedButton doneButton;

    public ManageActionsScreen(Screen parentScreen, List<ActionInstance> instances, Consumer<List<ActionInstance>> callback) {
        super((ITextComponent)new StringTextComponent(Locals.localize((String)"fancymenu.editor.action.screens.manage_screen.manage", (String[])new String[0])));
        this.parentScreen = parentScreen;
        this.callback = callback;
        this.instances = instances;
        this.updateActionInstanceScrollArea(false);
        this.addActionButton = new AdvancedButton(0, 0, 150, 20, Locals.localize((String)"fancymenu.editor.action.screens.add_action", (String[])new String[0]), true, button -> {
            BuildActionScreen s = new BuildActionScreen(this, null, call -> {
                if (call != null) {
                    this.instances.add((ActionInstance)call);
                    this.updateActionInstanceScrollArea(false);
                }
            });
            Minecraft.func_71410_x().func_147108_a((Screen)s);
        });
        this.addActionButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.action.screens.add_action.desc", (String[])new String[0]), (String)"%n%"));
        UIBase.applyDefaultButtonSkinTo(this.addActionButton);
        this.moveUpButton = new AdvancedButton(0, 0, 150, 20, Locals.localize((String)"fancymenu.editor.action.screens.move_action_up", (String[])new String[0]), true, button -> {
            ActionInstance selected;
            int index;
            if (this.isInstanceSelected() && (index = this.instances.indexOf(selected = this.getSelectedInstance())) > 0) {
                this.instances.remove(selected);
                this.instances.add(index - 1, selected);
                this.updateActionInstanceScrollArea(true);
                for (ScrollAreaEntry e : this.actionsScrollArea.getEntries()) {
                    if (!(e instanceof ActionInstanceEntry) || ((ActionInstanceEntry)e).instance != selected) continue;
                    e.setFocused(true);
                    break;
                }
            }
        }){

            public void func_230430_a_(MatrixStack p_93657_, int p_93658_, int p_93659_, float p_93660_) {
                ManageActionsScreen s = ManageActionsScreen.this;
                if (!s.isInstanceSelected()) {
                    this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.action.screens.finish.no_action_selected", (String[])new String[0]), (String)"%n%"));
                    this.field_230693_o_ = false;
                } else {
                    this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.action.screens.move_action_up.desc", (String[])new String[0]), (String)"%n%"));
                    this.field_230693_o_ = true;
                }
                super.func_230430_a_(p_93657_, p_93658_, p_93659_, p_93660_);
            }
        };
        UIBase.applyDefaultButtonSkinTo(this.moveUpButton);
        this.moveDownButton = new AdvancedButton(0, 0, 150, 20, Locals.localize((String)"fancymenu.editor.action.screens.move_action_down", (String[])new String[0]), true, button -> {
            ActionInstance selected;
            int index;
            if (this.isInstanceSelected() && (index = this.instances.indexOf(selected = this.getSelectedInstance())) >= 0 && index <= this.instances.size() - 2) {
                this.instances.remove(selected);
                this.instances.add(index + 1, selected);
                this.updateActionInstanceScrollArea(true);
                for (ScrollAreaEntry e : this.actionsScrollArea.getEntries()) {
                    if (!(e instanceof ActionInstanceEntry) || ((ActionInstanceEntry)e).instance != selected) continue;
                    e.setFocused(true);
                    break;
                }
            }
        }){

            public void func_230430_a_(MatrixStack p_93657_, int p_93658_, int p_93659_, float p_93660_) {
                ManageActionsScreen s = ManageActionsScreen.this;
                if (!s.isInstanceSelected()) {
                    this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.action.screens.finish.no_action_selected", (String[])new String[0]), (String)"%n%"));
                    this.field_230693_o_ = false;
                } else {
                    this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.action.screens.move_action_down.desc", (String[])new String[0]), (String)"%n%"));
                    this.field_230693_o_ = true;
                }
                super.func_230430_a_(p_93657_, p_93658_, p_93659_, p_93660_);
            }
        };
        UIBase.applyDefaultButtonSkinTo(this.moveDownButton);
        this.editButton = new AdvancedButton(0, 0, 150, 20, Locals.localize((String)"fancymenu.editor.action.screens.edit_action", (String[])new String[0]), true, button -> {
            if (this.isInstanceSelected()) {
                BuildActionScreen s = new BuildActionScreen(this, this.getSelectedInstance(), call -> this.updateActionInstanceScrollArea(false));
                Minecraft.func_71410_x().func_147108_a((Screen)s);
            }
        }){

            public void func_230430_a_(MatrixStack p_93657_, int p_93658_, int p_93659_, float p_93660_) {
                ManageActionsScreen s = ManageActionsScreen.this;
                if (!s.isInstanceSelected()) {
                    this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.action.screens.finish.no_action_selected", (String[])new String[0]), (String)"%n%"));
                    this.field_230693_o_ = false;
                } else {
                    this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.action.screens.edit_action.desc", (String[])new String[0]), (String)"%n%"));
                    this.field_230693_o_ = true;
                }
                super.func_230430_a_(p_93657_, p_93658_, p_93659_, p_93660_);
            }
        };
        UIBase.applyDefaultButtonSkinTo(this.editButton);
        this.removeButton = new AdvancedButton(0, 0, 150, 20, Locals.localize((String)"fancymenu.editor.action.screens.remove_action", (String[])new String[0]), true, button -> {
            if (this.isInstanceSelected()) {
                ActionInstance i = this.getSelectedInstance();
                ConfirmationScreen s = new ConfirmationScreen(this, call -> {
                    if (call.booleanValue()) {
                        this.instances.remove(i);
                        this.updateActionInstanceScrollArea(false);
                    }
                }, StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.action.screens.remove_action.confirm", (String[])new String[0]), (String)"%n%"));
                Minecraft.func_71410_x().func_147108_a((Screen)s);
            }
        }){

            public void func_230430_a_(MatrixStack p_93657_, int p_93658_, int p_93659_, float p_93660_) {
                ManageActionsScreen s = ManageActionsScreen.this;
                if (!s.isInstanceSelected()) {
                    this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.action.screens.finish.no_action_selected", (String[])new String[0]), (String)"%n%"));
                    this.field_230693_o_ = false;
                } else {
                    this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.action.screens.remove_action.desc", (String[])new String[0]), (String)"%n%"));
                    this.field_230693_o_ = true;
                }
                super.func_230430_a_(p_93657_, p_93658_, p_93659_, p_93660_);
            }
        };
        UIBase.applyDefaultButtonSkinTo(this.removeButton);
        this.doneButton = new AdvancedButton(0, 0, 150, 20, Locals.localize((String)"fancymenu.guicomponents.done", (String[])new String[0]), true, button -> {
            Minecraft.func_71410_x().func_147108_a(this.parentScreen);
            this.callback.accept(this.instances);
        });
        UIBase.applyDefaultButtonSkinTo(this.doneButton);
    }

    protected void func_231160_c_() {
        Minecraft.func_71410_x().func_228018_at_().func_216525_a((double)Minecraft.func_71410_x().func_228018_at_().func_216521_a(Minecraft.func_71410_x().field_71474_y.field_74335_Z, Minecraft.func_71410_x().func_211821_e()));
        this.field_230709_l_ = Minecraft.func_71410_x().func_228018_at_().func_198087_p();
        this.field_230708_k_ = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
        super.func_231160_c_();
    }

    public void func_231175_as__() {
        Minecraft.func_71410_x().func_147108_a(this.parentScreen);
        this.callback.accept(this.instances);
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partial) {
        ManageActionsScreen.func_238467_a_((MatrixStack)matrix, (int)0, (int)0, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)UIBase.SCREEN_BACKGROUND_COLOR.getRGB());
        IFormattableTextComponent titleComp = this.field_230704_d_.func_230532_e_().func_240703_c_(Style.field_240709_b_.func_240713_a_(Boolean.valueOf(true)));
        this.field_230712_o_.func_243248_b(matrix, (ITextComponent)titleComp, 20.0f, 20.0f, -1);
        this.field_230712_o_.func_238421_b_(matrix, Locals.localize((String)"fancymenu.editor.action.screens.manage_screen.actions", (String[])new String[0]), 20.0f, 50.0f, -1);
        this.actionsScrollArea.setWidth(this.field_230708_k_ - 20 - 150 - 20 - 20, true);
        this.actionsScrollArea.setHeight(this.field_230709_l_ - 85, true);
        this.actionsScrollArea.setX(20, true);
        this.actionsScrollArea.setY(65, true);
        this.actionsScrollArea.render(matrix, mouseX, mouseY, partial);
        this.doneButton.setX(this.field_230708_k_ - 20 - this.doneButton.func_230998_h_());
        this.doneButton.setY(this.field_230709_l_ - 20 - 20);
        this.doneButton.func_230430_a_(matrix, mouseX, mouseY, partial);
        this.removeButton.setX(this.field_230708_k_ - 20 - this.removeButton.func_230998_h_());
        this.removeButton.setY(this.doneButton.getY() - 15 - 20);
        this.removeButton.func_230430_a_(matrix, mouseX, mouseY, partial);
        this.editButton.setX(this.field_230708_k_ - 20 - this.editButton.func_230998_h_());
        this.editButton.setY(this.removeButton.getY() - 5 - 20);
        this.editButton.func_230430_a_(matrix, mouseX, mouseY, partial);
        this.moveDownButton.setX(this.field_230708_k_ - 20 - this.moveDownButton.func_230998_h_());
        this.moveDownButton.setY(this.editButton.getY() - 5 - 20);
        this.moveDownButton.func_230430_a_(matrix, mouseX, mouseY, partial);
        this.moveUpButton.setX(this.field_230708_k_ - 20 - this.moveUpButton.func_230998_h_());
        this.moveUpButton.setY(this.moveDownButton.getY() - 5 - 20);
        this.moveUpButton.func_230430_a_(matrix, mouseX, mouseY, partial);
        this.addActionButton.setX(this.field_230708_k_ - 20 - this.addActionButton.func_230998_h_());
        this.addActionButton.setY(this.moveUpButton.getY() - 5 - 20);
        this.addActionButton.func_230430_a_(matrix, mouseX, mouseY, partial);
        super.func_230430_a_(matrix, mouseX, mouseY, partial);
    }

    protected ActionInstance getSelectedInstance() {
        ScrollAreaEntry e = this.actionsScrollArea.getFocusedEntry();
        if (e instanceof ActionInstanceEntry) {
            return ((ActionInstanceEntry)e).instance;
        }
        return null;
    }

    protected boolean isInstanceSelected() {
        return this.getSelectedInstance() != null;
    }

    protected void updateActionInstanceScrollArea(boolean keepScroll) {
        float oldScrollVertical = this.actionsScrollArea.verticalScrollBar.getScroll();
        float oldScrollHorizontal = this.actionsScrollArea.horizontalScrollBar.getScroll();
        this.actionsScrollArea.clearEntries();
        for (ActionInstance i : this.instances) {
            ActionInstanceEntry e = new ActionInstanceEntry(this.actionsScrollArea, i, 14);
            this.actionsScrollArea.addEntry(e);
        }
        if (keepScroll) {
            this.actionsScrollArea.verticalScrollBar.setScroll(oldScrollVertical);
            this.actionsScrollArea.horizontalScrollBar.setScroll(oldScrollHorizontal);
        }
    }

    public static class ActionInstance {
        public ButtonActionContainer action;
        public String value;

        public ActionInstance(ButtonActionContainer action, String value) {
            this.action = action;
            this.value = value;
        }
    }

    public static class ActionInstanceEntry
    extends ScrollAreaEntry {
        public static final int HEADER_FOOTER_HEIGHT = 3;
        public ActionInstance instance;
        public final int lineHeight;
        public FontRenderer font;
        private IFormattableTextComponent displayNameComponent;
        private IFormattableTextComponent valueComponent;

        public ActionInstanceEntry(ScrollArea parent, ActionInstance instance, int lineHeight) {
            super(parent, 100, 30);
            this.font = Minecraft.func_71410_x().field_71466_p;
            this.instance = instance;
            this.lineHeight = lineHeight;
            this.displayNameComponent = new StringTextComponent(this.instance.action.getAction()).func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)TEXT_COLOR_GRAY_1.getRGB())));
            String valueString = this.instance.value != null && this.instance.action.hasValue() ? this.instance.value : Locals.localize((String)"fancymenu.editor.action.screens.manage_screen.info.value.none", (String[])new String[0]);
            this.valueComponent = new StringTextComponent(Locals.localize((String)"fancymenu.editor.action.screens.manage_screen.info.value", (String[])new String[0]) + " ").func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)TEXT_COLOR_GRAY_1.getRGB()))).func_230529_a_((ITextComponent)new StringTextComponent(valueString).func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)TEXT_COLOR_GREY_4.getRGB()))));
            this.setWidth(this.calculateWidth());
            this.setHeight(lineHeight * 2 + 6);
        }

        @Override
        public void render(MatrixStack matrix, int mouseX, int mouseY, float partial) {
            super.render(matrix, mouseX, mouseY, partial);
            int centerYLine1 = this.getY() + 3 + this.lineHeight / 2;
            int centerYLine2 = this.getY() + 3 + this.lineHeight / 2 * 3;
            RenderSystem.enableBlend();
            ActionInstanceEntry.renderListingDot(matrix, this.getX() + 5, centerYLine1 - 2, LISTING_DOT_RED);
            float f = this.getX() + 5 + 4 + 3;
            this.font.getClass();
            this.font.func_243248_b(matrix, (ITextComponent)this.displayNameComponent, f, (float)(centerYLine1 - 9 / 2), -1);
            ActionInstanceEntry.renderListingDot(matrix, this.getX() + 5 + 4 + 3, centerYLine2 - 2, LISTING_DOT_BLUE);
            float f2 = this.getX() + 5 + 4 + 3 + 4 + 3;
            this.font.getClass();
            this.font.func_243248_b(matrix, (ITextComponent)this.valueComponent, f2, (float)(centerYLine2 - 9 / 2), -1);
        }

        private int calculateWidth() {
            int w = 12 + this.font.func_238414_a_((ITextProperties)this.displayNameComponent) + 5;
            int w2 = 19 + this.font.func_238414_a_((ITextProperties)this.valueComponent) + 5;
            if (w2 > w) {
                w = w2;
            }
            return w;
        }

        @Override
        public void onClick(ScrollAreaEntry entry) {
        }
    }
}

