/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.api.background.example.with_input_string;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.api.background.MenuBackground;
import de.keksuccino.fancymenu.api.background.MenuBackgroundType;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import de.keksuccino.konkrete.resources.TextureHandler;
import java.io.File;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;

public class ExampleMenuBackgroundForInputString
extends MenuBackground {
    private ExternalTextureResourceLocation imageLocation = null;

    public ExampleMenuBackgroundForInputString(@Nonnull MenuBackgroundType type, String imagePath) {
        super("unused_identifier", type);
        File imageFile = new File(imagePath);
        if (imageFile.exists() && (imageFile.getPath().toLowerCase().endsWith(".jpg") || imageFile.getPath().toLowerCase().endsWith(".jpeg") || imageFile.getPath().toLowerCase().endsWith(".png"))) {
            this.imageLocation = TextureHandler.getResource((String)imageFile.getPath());
            if (this.imageLocation != null) {
                this.imageLocation.loadTexture();
            }
        }
    }

    @Override
    public void onOpenMenu() {
    }

    @Override
    public void render(MatrixStack matrix, Screen screen, boolean keepAspectRatio) {
        try {
            if (this.imageLocation != null && this.imageLocation.isReady()) {
                RenderSystem.enableBlend();
                Minecraft.func_71410_x().field_71446_o.func_110577_a(this.imageLocation.getResourceLocation());
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (!keepAspectRatio) {
                    AbstractGui.func_238463_a_((MatrixStack)matrix, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)screen.field_230708_k_, (int)screen.field_230709_l_, (int)screen.field_230708_k_, (int)screen.field_230709_l_);
                } else {
                    int w = this.imageLocation.getWidth();
                    int h = this.imageLocation.getHeight();
                    double ratio = (double)w / (double)h;
                    int wfinal = (int)((double)screen.field_230709_l_ * ratio);
                    int screenCenterX = screen.field_230708_k_ / 2;
                    if (wfinal < screen.field_230708_k_) {
                        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)screen.field_230708_k_, (int)screen.field_230709_l_, (int)screen.field_230708_k_, (int)screen.field_230709_l_);
                    } else {
                        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(screenCenterX - wfinal / 2), (int)0, (float)1.0f, (float)1.0f, (int)wfinal, (int)screen.field_230709_l_, (int)wfinal, (int)screen.field_230709_l_);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

