/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.json.jsonpath.internal.path;

import de.keksuccino.konkrete.json.jsonpath.internal.PathRef;
import de.keksuccino.konkrete.json.jsonpath.internal.path.ArrayPathToken;
import de.keksuccino.konkrete.json.jsonpath.internal.path.ArraySliceOperation;
import de.keksuccino.konkrete.json.jsonpath.internal.path.EvaluationContextImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ArraySliceToken
extends ArrayPathToken {
    private static final Logger logger = LogManager.getLogger();
    private final ArraySliceOperation operation;

    ArraySliceToken(ArraySliceOperation operation) {
        this.operation = operation;
    }

    @Override
    public void evaluate(String currentPath, PathRef parent, Object model, EvaluationContextImpl ctx) {
        if (!this.checkArrayModel(currentPath, model, ctx)) {
            return;
        }
        switch (this.operation.operation()) {
            case SLICE_FROM: {
                this.sliceFrom(currentPath, parent, model, ctx);
                break;
            }
            case SLICE_BETWEEN: {
                this.sliceBetween(currentPath, parent, model, ctx);
                break;
            }
            case SLICE_TO: {
                this.sliceTo(currentPath, parent, model, ctx);
            }
        }
    }

    private void sliceFrom(String currentPath, PathRef parent, Object model, EvaluationContextImpl ctx) {
        int length = ctx.jsonProvider().length(model);
        int from = this.operation.from();
        if (from < 0) {
            from = length + from;
        }
        from = Math.max(0, from);
        logger.debug("Slice from index on array with length: {}. From index: {} to: {}. Input: {}", (Object)length, (Object)from, (Object)(length - 1), (Object)this.toString());
        if (length == 0 || from >= length) {
            return;
        }
        for (int i = from; i < length; ++i) {
            this.handleArrayIndex(i, currentPath, model, ctx);
        }
    }

    private void sliceBetween(String currentPath, PathRef parent, Object model, EvaluationContextImpl ctx) {
        int length = ctx.jsonProvider().length(model);
        int from = this.operation.from();
        int to = this.operation.to();
        if (from >= (to = Math.min(length, to)) || length == 0) {
            return;
        }
        logger.debug("Slice between indexes on array with length: {}. From index: {} to: {}. Input: {}", (Object)length, (Object)from, (Object)to, (Object)this.toString());
        for (int i = from; i < to; ++i) {
            this.handleArrayIndex(i, currentPath, model, ctx);
        }
    }

    private void sliceTo(String currentPath, PathRef parent, Object model, EvaluationContextImpl ctx) {
        int length = ctx.jsonProvider().length(model);
        if (length == 0) {
            return;
        }
        int to = this.operation.to();
        if (to < 0) {
            to = length + to;
        }
        to = Math.min(length, to);
        logger.debug("Slice to index on array with length: {}. From index: 0 to: {}. Input: {}", (Object)length, (Object)to, (Object)this.toString());
        for (int i = 0; i < to; ++i) {
            this.handleArrayIndex(i, currentPath, model, ctx);
        }
    }

    @Override
    public String getPathFragment() {
        return this.operation.toString();
    }

    @Override
    public boolean isTokenDefinite() {
        return false;
    }
}

