/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import de.keksuccino.konkrete.command.ClientCommandSourceStack;
import de.keksuccino.konkrete.command.ClientExecutor;
import de.keksuccino.konkrete.events.client.ClientCommandRegistrationEvent;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.SuggestionProviders;
import net.minecraft.entity.Entity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientCommandHandler {
    private static final Logger LOGGER = LogManager.getLogger((String)"konkrete/ClientCommandHandler");
    private static CommandDispatcher<CommandSource> dispatcher;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new ClientCommandHandler());
        ClientExecutor.init();
    }

    @SubscribeEvent
    public void onPlayerLogin(ClientPlayerNetworkEvent.LoggedInEvent e) {
        CommandDispatcher<ISuggestionProvider> d = ClientCommandHandler.mergeWithServerCommands((CommandDispatcher<ISuggestionProvider>)new CommandDispatcher());
        if (e.getNetworkManager().func_150729_e() instanceof ClientPlayNetHandler) {
            ((ClientPlayNetHandler)e.getNetworkManager().func_150729_e()).field_195517_n = d;
        }
    }

    public static CommandDispatcher<ISuggestionProvider> mergeWithServerCommands(CommandDispatcher<ISuggestionProvider> serverCommands) {
        CommandDispatcher commandsTemp = new CommandDispatcher();
        MinecraftForge.EVENT_BUS.post((Event)new ClientCommandRegistrationEvent((CommandDispatcher<CommandSource>)commandsTemp));
        dispatcher = new CommandDispatcher();
        ClientCommandHandler.copy(commandsTemp.getRoot(), dispatcher.getRoot());
        RootCommandNode serverCommandsRoot = serverCommands.getRoot();
        CommandDispatcher newServerCommands = new CommandDispatcher();
        ClientCommandHandler.copy(serverCommandsRoot, newServerCommands.getRoot());
        ClientCommandHandler.mergeCommandNode(dispatcher.getRoot(), newServerCommands.getRoot(), new IdentityHashMap(), ClientCommandHandler.getSource(), context -> 0, suggestions -> {
            SuggestionProvider suggestionProvider = SuggestionProviders.func_197496_b((SuggestionProvider)suggestions);
            if (suggestionProvider == SuggestionProviders.field_197502_a) {
                suggestionProvider = (context, builder) -> {
                    ClientCommandSourceStack source = ClientCommandHandler.getSource();
                    StringReader reader = new StringReader(context.getInput());
                    if (reader.canRead() && reader.peek() == '/') {
                        reader.skip();
                    }
                    ParseResults parse = dispatcher.parse(reader, (Object)source);
                    return dispatcher.getCompletionSuggestions(parse);
                };
            }
            return suggestionProvider;
        });
        return newServerCommands;
    }

    private static <S, T> void mergeCommandNode(CommandNode<S> sourceNode, CommandNode<T> resultNode, Map<CommandNode<S>, CommandNode<T>> sourceToResult, S canUse, Command<T> execute, Function<SuggestionProvider<S>, SuggestionProvider<T>> sourceToResultSuggestion) {
        sourceToResult.put(sourceNode, resultNode);
        for (CommandNode sourceChild : sourceNode.getChildren()) {
            if (!sourceChild.canUse(canUse)) continue;
            resultNode.addChild(ClientCommandHandler.toResult(sourceChild, sourceToResult, canUse, execute, sourceToResultSuggestion));
        }
    }

    private static <S, T> CommandNode<T> toResult(CommandNode<S> sourceNode, Map<CommandNode<S>, CommandNode<T>> sourceToResult, S canUse, Command<T> execute, Function<SuggestionProvider<S>, SuggestionProvider<T>> sourceToResultSuggestion) {
        LiteralArgumentBuilder resultBuilder;
        if (sourceToResult.containsKey(sourceNode)) {
            return sourceToResult.get(sourceNode);
        }
        if (sourceNode instanceof ArgumentCommandNode) {
            ArgumentCommandNode sourceArgument = (ArgumentCommandNode)sourceNode;
            RequiredArgumentBuilder resultArgumentBuilder = RequiredArgumentBuilder.argument((String)sourceArgument.getName(), (ArgumentType)sourceArgument.getType());
            if (sourceArgument.getCustomSuggestions() != null) {
                resultArgumentBuilder.suggests(sourceToResultSuggestion.apply(sourceArgument.getCustomSuggestions()));
            }
            resultBuilder = resultArgumentBuilder;
        } else if (sourceNode instanceof LiteralCommandNode) {
            LiteralCommandNode sourceLiteral = (LiteralCommandNode)sourceNode;
            resultBuilder = LiteralArgumentBuilder.literal((String)sourceLiteral.getLiteral());
        } else {
            if (sourceNode instanceof RootCommandNode) {
                RootCommandNode resultNode = new RootCommandNode();
                ClientCommandHandler.mergeCommandNode(sourceNode, resultNode, sourceToResult, canUse, execute, sourceToResultSuggestion);
                return resultNode;
            }
            throw new IllegalStateException("Node type " + sourceNode + " is not a standard node type");
        }
        if (sourceNode.getCommand() != null) {
            resultBuilder.executes(execute);
        }
        if (sourceNode.getRedirect() != null) {
            resultBuilder.redirect(ClientCommandHandler.toResult(sourceNode.getRedirect(), sourceToResult, canUse, execute, sourceToResultSuggestion));
        }
        CommandNode resultNode = resultBuilder.build();
        ClientCommandHandler.mergeCommandNode(sourceNode, resultNode, sourceToResult, canUse, execute, sourceToResultSuggestion);
        return resultNode;
    }

    public static CommandDispatcher<CommandSource> getDispatcher() {
        return dispatcher;
    }

    private static ClientCommandSourceStack getSource() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        return new ClientCommandSourceStack((ICommandSource)player, player.func_213303_ch(), player.func_189653_aC(), player.func_184840_I(), player.func_200200_C_().getString(), player.func_145748_c_(), (Entity)player);
    }

    private static <S> void copy(CommandNode<S> sourceNode, CommandNode<S> resultNode) {
        IdentityHashMap<Object, Object> newNodes = new IdentityHashMap<Object, Object>();
        newNodes.put(sourceNode, resultNode);
        for (CommandNode child : sourceNode.getChildren()) {
            CommandNode copy = newNodes.computeIfAbsent(child, innerChild -> {
                ArgumentBuilder builder = innerChild.createBuilder();
                CommandNode innerCopy = builder.build();
                ClientCommandHandler.copy(innerChild, innerCopy);
                return innerCopy;
            });
            resultNode.addChild(copy);
        }
    }

    public static boolean executeClientCommand(String command) {
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        StringReader reader = new StringReader(command);
        ClientCommandSourceStack source = ClientCommandHandler.getSource();
        try {
            dispatcher.execute(reader, (Object)source);
        }
        catch (RuntimeException ex) {
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new StringTextComponent(ex.getMessage()).func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
        }
        catch (CommandSyntaxException ex) {
            if (ex.getType() == CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand() || ex.getType() == CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument()) {
                return false;
            }
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("").func_230529_a_(TextComponentUtils.func_202465_a((Message)ex.getRawMessage())).func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
        }
        catch (Exception ex) {
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("command.failed").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            LOGGER.error("Error while trying to execute client-only command '" + command + "'!");
        }
        return true;
    }
}

