/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.fullscreen.layer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.forge.event.KeyEventHandler;
import journeymap.client.io.ThemeLoader;
import journeymap.client.properties.FullMapProperties;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.fullscreen.layer.Layer;
import journeymap.client.ui.theme.Theme;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;

public class KeybindingInfoLayer
extends Layer {
    private final List<DrawStep> drawStepList = new ArrayList<DrawStep>(1);
    private FontRenderer fontRenderer;
    private final KeybindingInfoStep keybindingInfoStep;
    private FullMapProperties fullMapProperties;
    private final Minecraft mc;

    public KeybindingInfoLayer(Fullscreen fullscreen) {
        super(fullscreen);
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.fullMapProperties = JourneymapClient.getInstance().getFullMapProperties();
        this.mc = Minecraft.func_71410_x();
        this.keybindingInfoStep = new KeybindingInfoStep();
        this.drawStepList.add(this.keybindingInfoStep);
    }

    @Override
    public List<DrawStep> onMouseMove(Minecraft mc, GridRenderer gridRenderer, Point2D.Double mousePosition, BlockPos blockPos, float fontScale, boolean isScrolling) {
        if (this.fullMapProperties.showKeys.get().booleanValue()) {
            if (this.keybindingInfoStep.panelRect.contains(mousePosition)) {
                this.keybindingInfoStep.hide();
            } else {
                this.keybindingInfoStep.show();
            }
            return this.drawStepList;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<DrawStep> onMouseClick(Minecraft mc, GridRenderer gridRenderer, Point2D.Double mousePosition, BlockPos blockCoord, int button, boolean doubleClick, float fontScale) {
        return this.fullMapProperties.showKeys.get() != false ? this.drawStepList : Collections.EMPTY_LIST;
    }

    @Override
    public boolean propagateClick() {
        return true;
    }

    class KeybindingInfoStep
    implements DrawStep {
        private double screenWidth;
        private double screenHeight;
        private double fontScale;
        private int pad;
        private ArrayList<Tuple<String, String>> lines;
        private int keyNameWidth = 0;
        private int keyDescWidth = 0;
        private int lineHeight = 0;
        Rectangle2D panelRect = new Rectangle2D.Double();
        Theme theme = ThemeLoader.getCurrentTheme();
        Theme.LabelSpec statusLabelSpec;
        int bgColor;
        float fgAlphaDefault = 1.0f;
        float bgAlphaDefault = 0.7f;
        float fgAlpha = this.fgAlphaDefault;
        float bgAlpha = this.bgAlphaDefault;

        KeybindingInfoStep() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void draw(MatrixStack mStack, IRenderTypeBuffer buffers, DrawStep.Pass pass, double xOffset, double yOffset, GridRenderer gridRenderer, double fontScale, double rotation) {
            if (pass == DrawStep.Pass.Text) {
                if (KeybindingInfoLayer.this.fullscreen.getMenuToolbarBounds() == null) {
                    return;
                }
                this.updateLayout(gridRenderer, fontScale);
                DrawUtil.drawRectangle(mStack, this.panelRect.getX(), this.panelRect.getY(), this.panelRect.getWidth(), this.panelRect.getHeight(), this.bgColor, this.bgAlpha);
                int x = (int)this.panelRect.getX() + this.pad + this.keyNameWidth;
                int y = (int)this.panelRect.getY() + this.pad;
                int firstColor = this.theme.fullscreen.statusLabel.highlight.getColor();
                int secondColor = this.theme.fullscreen.statusLabel.foreground.getColor();
                try {
                    RenderSystem.enableBlend();
                    for (Tuple<String, String> line : this.lines) {
                        DrawUtil.drawLabel(mStack, (ITextComponent)Constants.getStringTextComponent((String)line.func_76341_a()), x, y, DrawUtil.HAlign.Left, DrawUtil.VAlign.Middle, null, 0.0f, firstColor, this.fgAlpha, fontScale, false);
                        DrawUtil.drawLabel(mStack, (ITextComponent)Constants.getStringTextComponent((String)line.func_76340_b()), x + this.pad, y, DrawUtil.HAlign.Right, DrawUtil.VAlign.Middle, null, 0.0f, secondColor, this.fgAlpha, fontScale, false);
                        y += this.lineHeight;
                    }
                }
                finally {
                    RenderSystem.disableBlend();
                }
            }
        }

        @Override
        public int getDisplayOrder() {
            return 0;
        }

        @Override
        public String getModId() {
            return "journeymap";
        }

        void hide() {
            this.bgAlpha = 0.2f;
            this.fgAlpha = 0.2f;
        }

        void show() {
            this.bgAlpha = this.bgAlphaDefault;
            this.fgAlpha = this.fgAlphaDefault;
        }

        private void updateLayout(GridRenderer gridRenderer, double fontScale) {
            Theme theme = ThemeLoader.getCurrentTheme();
            this.statusLabelSpec = theme.fullscreen.statusLabel;
            this.bgColor = this.statusLabelSpec.background.getColor();
            if (fontScale != this.fontScale || this.screenWidth != (double)gridRenderer.getWidth() || this.screenHeight != (double)gridRenderer.getHeight()) {
                this.screenWidth = gridRenderer.getWidth();
                this.screenHeight = gridRenderer.getHeight();
                this.fontScale = fontScale;
                this.pad = (int)(10.0 * fontScale);
                KeybindingInfoLayer.this.fontRenderer.getClass();
                this.lineHeight = (int)(3.0 + fontScale * 9.0);
                this.initLines(fontScale);
                int panelWidth = this.keyNameWidth + this.keyDescWidth + 4 * this.pad;
                int panelHeight = this.lines.size() * this.lineHeight + this.pad;
                double scaleFactor = KeybindingInfoLayer.this.fullscreen.getScreenScaleFactor();
                double panelX = this.screenWidth - (double)theme.container.toolbar.vertical.margin * scaleFactor - (double)panelWidth;
                double panelY = this.screenHeight - (double)theme.container.toolbar.horizontal.margin * scaleFactor - (double)panelHeight;
                this.panelRect.setRect(panelX, panelY, panelWidth, panelHeight);
                Rectangle2D.Double menuToolbarRect = KeybindingInfoLayer.this.fullscreen.getMenuToolbarBounds();
                if (menuToolbarRect != null && menuToolbarRect.intersects(this.panelRect) && panelX <= menuToolbarRect.getMaxX()) {
                    panelY = (int)menuToolbarRect.getMinY() - 5 - panelHeight;
                    this.panelRect.setRect(panelX, panelY, panelWidth, panelHeight);
                }
            }
        }

        private void initLines(double fontScale) {
            this.lines = new ArrayList();
            this.keyDescWidth = 0;
            this.keyNameWidth = 0;
            this.bgAlpha = this.fgAlphaDefault;
            this.bgAlpha = this.bgAlphaDefault;
            for (KeyBinding keyBinding : KeyEventHandler.getInstance().getInGuiKeybindings()) {
                this.initLine(keyBinding, fontScale);
            }
            this.initLine(((KeybindingInfoLayer)KeybindingInfoLayer.this).mc.field_71474_y.field_74310_D, fontScale);
        }

        private void initLine(KeyBinding keyBinding, double fontScale) {
            String keyName = keyBinding.func_238171_j_().getString().toUpperCase();
            String keyDesc = Constants.getString(keyBinding.func_151464_g());
            Tuple line = new Tuple((Object)keyName, (Object)keyDesc);
            this.lines.add((Tuple<String, String>)line);
            this.keyNameWidth = (int)Math.max((double)this.keyNameWidth, fontScale * (double)KeybindingInfoLayer.this.fontRenderer.func_78256_a(keyName));
            this.keyDescWidth = (int)Math.max((double)this.keyDescWidth, fontScale * (double)KeybindingInfoLayer.this.fontRenderer.func_78256_a(keyDesc));
        }
    }
}

