/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model.part;

import cam72cam.immersiverailroading.ConfigSound;
import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.mod.resource.Identifier;
import cam72cam.mod.sound.ISound;
import cam72cam.mod.util.DegreeFuncs;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class FlangeSound {
    private final Identifier def;
    private final boolean canLoop;
    private final float attenuationDistance;
    private final Map<UUID, Sound> sounds = new HashMap<UUID, Sound>();

    public FlangeSound(Identifier def, boolean canLoop, float attenuationDistance) {
        this.def = def;
        this.canLoop = canLoop;
        this.attenuationDistance = attenuationDistance;
    }

    public void effects(EntityMoveableRollingStock stock) {
        this.sounds.computeIfAbsent(stock.getUUID(), uuid -> new Sound(stock)).effects();
    }

    public void removed(EntityMoveableRollingStock stock) {
        Sound sound = this.sounds.remove(stock.getUUID());
        if (sound != null) {
            sound.removed();
        }
    }

    private class Sound {
        private final EntityMoveableRollingStock stock;
        private final ISound sound;
        private final float sndRand;
        private float lastFlangeVolume = 0.0f;

        Sound(EntityMoveableRollingStock stock) {
            this.sound = stock.createSound(FlangeSound.this.def, FlangeSound.this.canLoop, FlangeSound.this.attenuationDistance, ConfigSound.SoundCategories.RollingStock::flange);
            this.stock = stock;
            this.sndRand = (float)Math.random() / 10.0f;
        }

        void effects() {
            double yawDelta = DegreeFuncs.delta((float)this.stock.getFrontYaw(), (float)this.stock.getRearYaw()) / Math.abs(this.stock.getDefinition().getBogeyFront(this.stock.gauge) - this.stock.getDefinition().getBogeyRear(this.stock.gauge));
            double startingFlangeSpeed = 5.0;
            double kmh = Math.abs(this.stock.getCurrentSpeed().metric());
            double flangeMinYaw = this.stock.getDefinition().flange_min_yaw;
            if (yawDelta > (flangeMinYaw = flangeMinYaw / Math.sqrt(kmh) * Math.sqrt(startingFlangeSpeed)) && kmh > 5.0) {
                if (!this.sound.isPlaying()) {
                    this.lastFlangeVolume = 0.1f;
                    this.sound.setVolume(this.lastFlangeVolume);
                    this.sound.play(this.stock.getPosition());
                }
                this.sound.setPitch(0.9f + Math.abs((float)this.stock.getCurrentSpeed().metric()) / 600.0f + this.sndRand);
                float oscillation = (float)Math.sin((float)this.stock.getTickCount() / 40.0f * this.sndRand * 40.0f);
                double flangeFactor = (yawDelta - flangeMinYaw) / (90.0 - flangeMinYaw);
                float desiredVolume = (float)flangeFactor / 2.0f * oscillation / 4.0f + 0.25f;
                this.lastFlangeVolume = (this.lastFlangeVolume * 4.0f + desiredVolume) / 5.0f;
                this.sound.setVolume(this.lastFlangeVolume);
                this.sound.setPosition(this.stock.getPosition());
                this.sound.setVelocity(this.stock.getVelocity());
            } else if (this.sound.isPlaying()) {
                if ((double)this.lastFlangeVolume > 0.1) {
                    this.lastFlangeVolume = (this.lastFlangeVolume * 4.0f + 0.0f) / 5.0f;
                    this.sound.setVolume(this.lastFlangeVolume);
                    this.sound.setPosition(this.stock.getPosition());
                    this.sound.setVelocity(this.stock.getVelocity());
                } else {
                    this.sound.stop();
                }
            }
        }

        public void removed() {
            this.sound.stop();
        }
    }
}

