/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model.part;

import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.library.ModelComponentType;
import cam72cam.immersiverailroading.library.ValveGearConfig;
import cam72cam.immersiverailroading.model.ModelState;
import cam72cam.immersiverailroading.model.animation.AnimatrixSet;
import cam72cam.immersiverailroading.model.components.ComponentProvider;
import cam72cam.immersiverailroading.model.components.ModelComponent;
import cam72cam.immersiverailroading.model.part.ValveGear;
import cam72cam.immersiverailroading.model.part.WheelSet;
import cam72cam.mod.math.Vec3d;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class CustomValveGear
extends ValveGear {
    private final AnimatrixSet animation;

    public static CustomValveGear get(ValveGearConfig custom, WheelSet wheels, ComponentProvider provider, ModelState state, ModelComponentType.ModelPosition pos) {
        List<Object> components = new ArrayList<ModelComponent>();
        components.add(provider.parse(ModelComponentType.MAIN_ROD_SIDE, pos));
        components.add(provider.parse(ModelComponentType.SIDE_ROD_SIDE, pos));
        components.add(provider.parse(ModelComponentType.PISTON_ROD_SIDE, pos));
        components.add(provider.parse(ModelComponentType.CYLINDER_SIDE, pos));
        components.add(provider.parse(ModelComponentType.UNION_LINK_SIDE, pos));
        components.add(provider.parse(ModelComponentType.COMBINATION_LEVER_SIDE, pos));
        components.add(provider.parse(ModelComponentType.ECCENTRIC_CRANK_SIDE, pos));
        components.add(provider.parse(ModelComponentType.ECCENTRIC_ROD_SIDE, pos));
        components.add(provider.parse(ModelComponentType.EXPANSION_LINK_SIDE, pos));
        components.add(provider.parse(ModelComponentType.RADIUS_BAR_SIDE, pos));
        components.add(provider.parse(ModelComponentType.VALVE_STEM_SIDE, pos));
        components.add(provider.parse(ModelComponentType.REVERSING_ARM_SIDE, pos));
        components.add(provider.parse(ModelComponentType.LIFTING_LINK_SIDE, pos));
        components.add(provider.parse(ModelComponentType.REACH_ROD_SIDE, pos));
        components.addAll(provider.parseAll(ModelComponentType.VALVE_PART_SIDE_ID, pos));
        components = components.stream().filter(Objects::nonNull).collect(Collectors.toList());
        ModelComponent frontExhaust = provider.parse(ModelComponentType.CYLINDER_DRAIN_SIDE, pos.and(ModelComponentType.ModelPosition.A));
        ModelComponent rearExhaust = provider.parse(ModelComponentType.CYLINDER_DRAIN_SIDE, pos.and(ModelComponentType.ModelPosition.B));
        return !components.isEmpty() ? new CustomValveGear(state, custom, wheels, components, frontExhaust, rearExhaust, provider.internal_model_scale) : null;
    }

    public CustomValveGear(ModelState state, ValveGearConfig custom, WheelSet wheels, List<ModelComponent> components, ModelComponent frontExhaust, ModelComponent rearExhaust, double internal_model_scale) {
        super(wheels, state, 0.0f);
        try {
            this.animation = new AnimatrixSet(custom.custom, internal_model_scale);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        state.push(settings -> settings.add((stock, group, partialTicks) -> this.animation.getMatrix(group, stock instanceof Locomotive ? ((Locomotive)stock).getReverser() : 0.0f, this.angle(stock.distanceTraveled) / 360.0f, true))).include(components);
        ModelComponent pistonRod = components.stream().filter(x -> x.type == ModelComponentType.PISTON_ROD_SIDE).findFirst().orElse(null);
        if (pistonRod != null) {
            Vec3d initial;
            float reverser = 1.0f;
            String pistonGroup = (String)pistonRod.modelIDs.stream().findFirst().get();
            float pistonStart = 0.0f;
            Vec3d pistonStartPos = initial = this.animation.getMatrix(pistonGroup, reverser, 0.0f, true).apply(pistonRod.center);
            float i = 0.0f;
            while (i < 1.0f) {
                Vec3d pos = this.animation.getMatrix(pistonGroup, reverser, i, true).apply(pistonRod.center);
                if (pos.distanceToSquared(initial) > pistonStartPos.distanceToSquared(initial)) {
                    pistonStartPos = pos;
                    pistonStart = i;
                }
                i = (float)((double)i + 0.05);
            }
            float pistonEnd = 0.0f;
            Vec3d pistonEndPos = pistonStartPos;
            float i2 = 0.0f;
            while (i2 < 1.0f) {
                Vec3d pos = this.animation.getMatrix(pistonGroup, reverser, i2, true).apply(pistonRod.center);
                if (pos.distanceToSquared(pistonStartPos) > pistonEndPos.distanceToSquared(pistonStartPos)) {
                    pistonEndPos = pos;
                    pistonEnd = i2;
                }
                i2 = (float)((double)i2 + 0.05);
            }
            state.include(frontExhaust);
            state.include(rearExhaust);
            this.frontExhaust = frontExhaust != null ? new ValveGear.Exhaust(this, frontExhaust, pistonStart * 360.0f) : new ValveGear.Exhaust((ValveGear)this, pistonEndPos.add(pistonStartPos.subtract(pistonEndPos).scale(2.0)), pistonRod.pos, pistonStart * 360.0f);
            this.rearExhaust = rearExhaust != null ? new ValveGear.Exhaust(this, rearExhaust, pistonEnd * 360.0f) : new ValveGear.Exhaust((ValveGear)this, pistonStartPos, pistonRod.pos, pistonEnd * 360.0f);
        }
    }
}

