/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model.animation;

import cam72cam.immersiverailroading.ConfigSound;
import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.model.animation.Animatrix;
import cam72cam.immersiverailroading.model.part.PartSound;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.render.ExpireableMap;
import java.io.IOException;
import java.util.UUID;
import util.Matrix4;

public class StockAnimation {
    private final EntityRollingStockDefinition.AnimationDefinition def;
    private final Animatrix animatrix;
    private final ExpireableMap<UUID, Boolean> active;
    private final ExpireableMap<UUID, Float> tickStart;
    private final ExpireableMap<UUID, Float> tickStop;
    private final boolean looping;
    private final PartSound sound;

    public StockAnimation(EntityRollingStockDefinition.AnimationDefinition def, double internal_model_scale) throws IOException {
        this.def = def;
        this.animatrix = new Animatrix(def.animatrix.getResourceStream(), internal_model_scale);
        this.tickStart = new ExpireableMap();
        this.tickStop = new ExpireableMap();
        this.active = new ExpireableMap();
        switch (def.mode) {
            case VALUE: 
            case PLAY_FORWARD: 
            case PLAY_REVERSE: 
            case PLAY_BOTH: {
                this.looping = false;
                break;
            }
            default: {
                this.looping = true;
            }
        }
        this.sound = def.sound != null ? new PartSound(def.sound, true, 20.0f, ConfigSound.SoundCategories::animations) : null;
    }

    public float getValue(EntityRollingStock stock) {
        float value = this.def.control_group != null ? stock.getControlPosition(this.def.control_group) : this.def.readout.getValue(stock);
        value += this.def.offset;
        if (this.def.invert) {
            value = 1.0f - value;
        }
        return value;
    }

    public float getPercent(EntityRollingStock stock, float partialTicks) {
        float value = this.getValue(stock);
        float total_ticks_per_loop = (float)this.animatrix.frameCount() / this.def.frames_per_tick;
        if (this.def.mode == EntityRollingStockDefinition.AnimationDefinition.AnimationMode.LOOP_SPEED) {
            total_ticks_per_loop /= value;
        }
        float tickCount = (float)stock.getTickCount() + partialTicks;
        switch (this.def.mode) {
            case VALUE: {
                return value;
            }
            case PLAY_FORWARD: 
            case PLAY_REVERSE: 
            case PLAY_BOTH: {
                float tickDelta;
                UUID key = stock.getUUID();
                if ((double)value >= 0.95) {
                    if (this.tickStart.get(key) == null) {
                        if (this.active.get(key) == null) {
                            this.active.put(key, true);
                            this.tickStart.put(key, Float.valueOf(tickCount - total_ticks_per_loop - 1.0f));
                        } else {
                            this.tickStart.put(key, Float.valueOf(tickCount));
                        }
                        this.tickStop.remove(key);
                    }
                    if (this.def.mode == EntityRollingStockDefinition.AnimationDefinition.AnimationMode.PLAY_REVERSE) {
                        return 1.0f;
                    }
                    tickDelta = tickCount - this.tickStart.get(key).floatValue();
                } else {
                    if (this.tickStop.get(key) == null) {
                        if (this.active.get(key) == null) {
                            this.active.put(key, true);
                            this.tickStop.put(key, Float.valueOf(tickCount - total_ticks_per_loop - 1.0f));
                        } else {
                            this.tickStop.put(key, Float.valueOf(tickCount));
                        }
                        this.tickStart.remove(key);
                    }
                    if (this.def.mode == EntityRollingStockDefinition.AnimationDefinition.AnimationMode.PLAY_FORWARD) {
                        return 0.0f;
                    }
                    tickDelta = tickCount - this.tickStop.get(key).floatValue();
                    if (this.def.mode == EntityRollingStockDefinition.AnimationDefinition.AnimationMode.PLAY_BOTH) {
                        tickDelta = total_ticks_per_loop - tickDelta;
                    }
                }
                return tickDelta / total_ticks_per_loop;
            }
            case LOOP: {
                if (!((double)value < 0.95)) break;
                return 0.0f;
            }
            case LOOP_SPEED: {
                if (value != 0.0f) break;
                return 0.0f;
            }
        }
        return tickCount % total_ticks_per_loop / total_ticks_per_loop;
    }

    public Matrix4 getMatrix(EntityRollingStock stock, String group, float partialTicks) {
        return this.animatrix.groups().contains(group) ? this.animatrix.getMatrix(group, this.getPercent(stock, partialTicks), this.looping) : null;
    }

    public <ENTITY extends EntityMoveableRollingStock> void effects(ENTITY stock) {
        if (this.sound != null) {
            float volume = 0.0f;
            float pitch = 1.0f;
            switch (this.def.mode) {
                case VALUE: {
                    volume = this.getValue(stock);
                    break;
                }
                case PLAY_FORWARD: 
                case PLAY_REVERSE: 
                case PLAY_BOTH: {
                    volume = this.getPercent(stock, 0.0f) > 0.0f && this.getPercent(stock, 0.0f) < 1.0f ? 1.0f : 0.0f;
                    break;
                }
                case LOOP: {
                    volume = (double)this.getValue(stock) > 0.95 ? 1.0f : 0.0f;
                    break;
                }
                case LOOP_SPEED: {
                    volume = this.getValue(stock) > 0.0f ? 1.0f : 0.0f;
                    pitch = this.getValue(stock);
                }
            }
            this.sound.effects(stock, volume, pitch);
        }
    }

    public <ENTITY extends EntityMoveableRollingStock> void removed(ENTITY stock) {
        if (this.sound != null) {
            this.sound.removed(stock);
        }
    }
}

