/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.item.ItemPackedStructure;
import zmaster587.advancedRocketry.item.ItemStationChip;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.stations.SpaceStationObject;
import zmaster587.advancedRocketry.tile.TileRocketAssemblingMachine;
import zmaster587.advancedRocketry.util.StorageChunk;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IDataSync;
import zmaster587.libVulpes.inventory.modules.IProgressBar;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModulePower;
import zmaster587.libVulpes.inventory.modules.ModuleProgress;
import zmaster587.libVulpes.inventory.modules.ModuleSlotArray;
import zmaster587.libVulpes.inventory.modules.ModuleSync;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.inventory.modules.ModuleTexturedSlotArray;
import zmaster587.libVulpes.util.EmbeddedInventory;

public class TileStationAssembler
extends TileRocketAssemblingMachine
implements IInventory {
    EmbeddedInventory inventory = new EmbeddedInventory(4);
    Long storedId;

    public TileStationAssembler() {
        this.status = TileRocketAssemblingMachine.ErrorCodes.EMPTY;
    }

    @Override
    public boolean canScan() {
        if (!super.canScan()) {
            return false;
        }
        ItemStack stack = new ItemStack(AdvancedRocketryBlocks.blockLoader, 1, 1);
        if (this.inventory.func_70301_a(0).func_190926_b() || !stack.func_77969_a(this.inventory.func_70301_a(0))) {
            this.status = TileRocketAssemblingMachine.ErrorCodes.NOSATELLITEHATCH;
            return false;
        }
        if (this.inventory.func_70301_a(1).func_190926_b() || AdvancedRocketryItems.itemSpaceStationChip != this.inventory.func_70301_a(1).func_77973_b()) {
            this.status = TileRocketAssemblingMachine.ErrorCodes.NOSATELLITECHIP;
            return false;
        }
        if (!this.inventory.func_70301_a(2).func_190926_b() || !this.inventory.func_70301_a(3).func_190926_b()) {
            this.status = TileRocketAssemblingMachine.ErrorCodes.OUTPUTBLOCKED;
            return false;
        }
        return true;
    }

    @Override
    public void scanRocket(World world, BlockPos pos2, AxisAlignedBB bb) {
        int actualMinX = (int)bb.field_72336_d;
        int actualMinY = (int)bb.field_72337_e;
        int actualMinZ = (int)bb.field_72334_f;
        int actualMaxX = (int)bb.field_72340_a;
        int actualMaxY = (int)bb.field_72338_b;
        int actualMaxZ = (int)bb.field_72339_c;
        int xCurr = (int)bb.field_72340_a;
        while ((double)xCurr <= bb.field_72336_d) {
            int zCurr = (int)bb.field_72339_c;
            while ((double)zCurr <= bb.field_72334_f) {
                int yCurr = (int)bb.field_72338_b;
                while ((double)yCurr <= bb.field_72337_e) {
                    BlockPos posCurr = new BlockPos(xCurr, yCurr, zCurr);
                    if (!world.func_175623_d(posCurr)) {
                        if (xCurr < actualMinX) {
                            actualMinX = xCurr;
                        }
                        if (yCurr < actualMinY) {
                            actualMinY = yCurr;
                        }
                        if (zCurr < actualMinZ) {
                            actualMinZ = zCurr;
                        }
                        if (xCurr > actualMaxX) {
                            actualMaxX = xCurr;
                        }
                        if (yCurr > actualMaxY) {
                            actualMaxY = yCurr;
                        }
                        if (zCurr > actualMaxZ) {
                            actualMaxZ = zCurr;
                        }
                    }
                    ++yCurr;
                }
                ++zCurr;
            }
            ++xCurr;
        }
        this.status = TileRocketAssemblingMachine.ErrorCodes.SUCCESS_STATION;
    }

    @Override
    public void assembleRocket() {
        if (!this.field_145850_b.field_72995_K) {
            ItemStack outputStack;
            StorageChunk storageChunk;
            if (this.bbCache == null) {
                return;
            }
            this.scanRocket(this.field_145850_b, this.field_174879_c, this.bbCache);
            if (this.status != TileRocketAssemblingMachine.ErrorCodes.SUCCESS_STATION) {
                return;
            }
            try {
                storageChunk = StorageChunk.cutWorldBB(this.field_145850_b, this.bbCache);
            }
            catch (NegativeArraySizeException e) {
                return;
            }
            SpaceStationObject spaceStationObject = null;
            if (this.storedId == null) {
                spaceStationObject = new SpaceStationObject();
                SpaceObjectManager.getSpaceManager().registerSpaceObject(spaceStationObject, -2147483647);
                outputStack = new ItemStack(AdvancedRocketryItems.itemSpaceStation, 1);
                ItemStationChip.setUUID(outputStack, spaceStationObject.getId());
            } else {
                outputStack = new ItemStack(AdvancedRocketryItems.itemSpaceStation, 1);
                ItemStationChip.setUUID(outputStack, (int)this.storedId.longValue());
            }
            ((ItemPackedStructure)outputStack.func_77973_b()).setStructure(outputStack, storageChunk);
            this.inventory.func_70299_a(2, outputStack);
            if (this.storedId == null) {
                ItemStack stack = new ItemStack(AdvancedRocketryItems.itemSpaceStationChip, 1);
                ItemStationChip.setUUID(stack, spaceStationObject.getId());
                this.inventory.func_70299_a(3, stack);
            }
            this.status = TileRocketAssemblingMachine.ErrorCodes.FINISHED;
            this.storedId = null;
            this.inventory.func_70298_a(0, 1);
            this.inventory.func_70298_a(1, 1);
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
    }

    @Override
    protected void updateText() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.getRocketPadBounds(this.field_145850_b, this.field_174879_c) == null) {
                this.setStatus(TileRocketAssemblingMachine.ErrorCodes.INCOMPLETESTRCUTURE.ordinal());
            } else if (TileRocketAssemblingMachine.ErrorCodes.INCOMPLETESTRCUTURE.equals((Object)this.getStatus())) {
                this.setStatus(TileRocketAssemblingMachine.ErrorCodes.UNSCANNED.ordinal());
            }
        }
        this.errorText.setText(this.status.getErrorCode());
    }

    @Override
    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add((ModuleBase)new ModulePower(160, 30, (IUniversalEnergy)this));
        modules.add((ModuleBase)new ModuleProgress(149, 30, 2, verticalProgressBar, (IProgressBar)this));
        modules.add((ModuleBase)new ModuleButton(5, 34, 0, LibVulpes.proxy.getLocalizedString("msg.rocketbuilder.scan"), (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonScan));
        ModuleButton buttonBuild = new ModuleButton(5, 60, 1, LibVulpes.proxy.getLocalizedString("msg.rocketbuilder.build"), (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonBuild);
        modules.add((ModuleBase)buttonBuild);
        buttonBuild.setColor(-56798);
        this.errorText = new ModuleText(5, 22, "", -222);
        modules.add((ModuleBase)this.errorText);
        modules.add((ModuleBase)new ModuleSync(4, (IDataSync)this));
        this.updateText();
        modules.add((ModuleBase)new ModuleSlotArray(90, 40, (IInventory)this.inventory, 0, 1));
        modules.add((ModuleBase)new ModuleTexturedSlotArray(108, 40, (IInventory)this.inventory, 1, 2, TextureResources.idChip));
        modules.add((ModuleBase)new ModuleSlotArray(90, 60, (IInventory)this.inventory, 2, 4));
        return modules;
    }

    @Override
    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        boolean isScanningFlag = !this.isScanning() && this.canScan();
        super.useNetworkData(player, side, id, nbt);
        if (id == 1 && isScanningFlag) {
            this.storedId = ItemStationChip.getUUID(this.inventory.func_70301_a(1));
            if (this.storedId == 0L) {
                this.storedId = null;
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.inventory.writeToNBT(nbt);
        if (this.storedId != null) {
            nbt.func_74772_a("storedID", this.storedId.longValue());
        }
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inventory.readFromNBT(nbt);
        if (nbt.func_74764_b("storedID")) {
            this.storedId = nbt.func_74763_f("storedID");
        }
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    @Nonnull
    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    @Nonnull
    public ItemStack func_70298_a(int slot, int amt) {
        return this.inventory.func_70298_a(slot, amt);
    }

    public void func_70299_a(int slot, @Nonnull ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
    }

    public String func_70005_c_() {
        return "tile.stationBuilder.name";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(@Nonnull EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public boolean func_191420_l() {
        return this.inventory.func_191420_l();
    }

    public void func_174889_b(EntityPlayer pos) {
    }

    public void func_174886_c(EntityPlayer pos) {
    }

    public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
        return this.inventory.func_94041_b(slot, stack);
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        return this.inventory.func_70304_b(index);
    }

    public int func_174887_a_(int id) {
        return this.inventory.func_174887_a_(id);
    }

    public void func_174885_b(int id, int value) {
        this.inventory.func_174885_b(id, value);
    }

    public int func_174890_g() {
        return this.inventory.func_174890_g();
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }
}

