/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.satellite;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.IUniversalEnergyTransmitter;

public class SatelliteMicrowaveEnergy
extends SatelliteBase
implements IUniversalEnergyTransmitter {
    byte teir;

    @Override
    public void setProperties(@Nonnull ItemStack satelliteProperties) {
        super.setProperties(satelliteProperties);
    }

    @Override
    public String getInfo(World world) {
        return LibVulpes.proxy.getLocalizedString("msg.itemsatellite.microwavestatus");
    }

    @Override
    public String getName() {
        return "Microwave Energy Satellite";
    }

    @Override
    public boolean performAction(EntityPlayer player, World world, BlockPos pos) {
        return false;
    }

    @Override
    public double failureChance() {
        return 0.0;
    }

    public int getEnergyMTU(EnumFacing side) {
        return (int)(ARConfiguration.getCurrentConfig().microwaveRecieverMulitplier * (float)this.battery.extractEnergy(this.battery.getMaxEnergyStored(), false));
    }

    @Override
    public void setDimensionId(World world) {
        super.setDimensionId(world);
    }

    public int transmitEnergy(EnumFacing dir, boolean simulate) {
        return this.getEnergyMTU(EnumFacing.DOWN);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74774_a("teir", this.teir);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.teir = nbt.func_74771_c("teir");
    }
}

