/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.mission;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.api.DataStorage;
import zmaster587.advancedRocketry.api.IInfrastructure;
import zmaster587.advancedRocketry.entity.EntityRocket;
import zmaster587.advancedRocketry.item.ItemAsteroidChip;
import zmaster587.advancedRocketry.mission.MissionResourceCollection;
import zmaster587.advancedRocketry.tile.TileGuidanceComputer;
import zmaster587.advancedRocketry.util.Asteroid;
import zmaster587.libVulpes.util.HashedBlockPosition;

public class MissionOreMining
extends MissionResourceCollection {
    public MissionOreMining() {
    }

    public MissionOreMining(long l, EntityRocket entityRocket, LinkedList<IInfrastructure> connectedInfrastructure) {
        super(l, entityRocket, connectedInfrastructure);
    }

    @Override
    public void onMissionComplete() {
        if (this.rocketStats.getDrillingPower() != 0.0f) {
            TileGuidanceComputer computer = this.rocketStorage.getGuidanceComputer();
            if (computer == null) {
                AdvancedRocketry.logger.warn("Cannot find guidance computer in rocket landing at " + this.x + ", " + this.z + " in dim " + this.launchDimension + ".  Unable to respawn the rocket.");
                return;
            }
            ItemStack stack = computer.func_70301_a(0);
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemAsteroidChip) {
                Asteroid asteroid;
                int distanceData = ((ItemAsteroidChip)stack.func_77973_b()).getData(stack, DataStorage.DataType.DISTANCE);
                int compositionData = ((ItemAsteroidChip)stack.func_77973_b()).getData(stack, DataStorage.DataType.COMPOSITION);
                int massData = ((ItemAsteroidChip)stack.func_77973_b()).getData(stack, DataStorage.DataType.MASS);
                int maxData = ((ItemAsteroidChip)stack.func_77973_b()).getMaxData(stack);
                if ((double)distanceData / (double)maxData > Math.random() && (asteroid = ARConfiguration.getCurrentConfig().asteroidTypes.get(((ItemAsteroidChip)stack.func_77973_b()).getType(stack))) != null) {
                    List<Asteroid.StackEntry> stacks2 = asteroid.getHarvest(((ItemAsteroidChip)stack.func_77973_b()).getUUID(stack));
                    LinkedList<ItemStack> totalStacksList = new LinkedList<ItemStack>();
                    for (Asteroid.StackEntry entry : stacks2) {
                        if ((double)((float)compositionData / (float)maxData) >= Math.random()) {
                            entry.stack.func_190920_e((int)((float)entry.stack.func_190916_E() * 1.25f));
                        }
                        if ((double)((float)massData / (float)maxData) >= Math.random()) {
                            entry.stack.func_190920_e((int)((float)entry.stack.func_190916_E() * 1.25f));
                        }
                        for (int i = 0; i < entry.stack.func_190916_E() / entry.stack.func_77976_d(); ++i) {
                            ItemStack stack2 = new ItemStack(entry.stack.func_77973_b(), entry.stack.func_77976_d(), entry.stack.func_77960_j());
                            totalStacksList.add(stack2);
                        }
                        entry.stack.func_190920_e(entry.stack.func_190916_E() % entry.stack.func_77976_d());
                        totalStacksList.add(entry.stack);
                    }
                    ItemStack[] stacks = new ItemStack[totalStacksList.size()];
                    totalStacksList.toArray(stacks);
                    int g = 0;
                    for (int i = 0; i < this.rocketStorage.getInventoryTiles().size(); ++i) {
                        int offset;
                        if (this.rocketStorage.getInventoryTiles().get(i).hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) {
                            IItemHandler capabilityItemHandle = (IItemHandler)this.rocketStorage.getInventoryTiles().get(i).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
                            for (offset = 0; offset < capabilityItemHandle.getSlots() && g < stacks.length; ++offset, ++g) {
                                if (!capabilityItemHandle.getStackInSlot(offset).func_190926_b()) continue;
                                capabilityItemHandle.insertItem(offset, stacks[g], false);
                            }
                            continue;
                        }
                        IInventory tile = (IInventory)this.rocketStorage.getInventoryTiles().get(i);
                        for (offset = 0; offset < tile.func_70302_i_() && g < stacks.length; ++offset, ++g) {
                            if (!tile.func_70301_a(offset).func_190926_b()) continue;
                            tile.func_70299_a(offset, stacks[g]);
                        }
                    }
                }
            }
        }
        this.rocketStorage.getGuidanceComputer().func_70299_a(0, ItemStack.field_190927_a);
        this.rocketStorage.getGuidanceComputer().func_70299_a(0, new ItemStack(AdvancedRocketryItems.itemAsteroidChip));
        EntityRocket rocket = new EntityRocket((World)DimensionManager.getWorld((int)this.launchDimension), this.rocketStorage, this.rocketStats, this.x, 999.0, this.z);
        WorldServer world = DimensionManager.getWorld((int)this.launchDimension);
        world.func_72838_d((Entity)rocket);
        rocket.setInOrbit(true);
        rocket.setInFlight(true);
        rocket.field_70181_x = -1.0;
        for (HashedBlockPosition i : this.infrastructureCoords) {
            TileEntity tile = world.func_175625_s(new BlockPos(i.x, (int)i.y, i.z));
            if (!(tile instanceof IInfrastructure)) continue;
            ((IInfrastructure)tile).unlinkMission();
            rocket.linkInfrastructure((IInfrastructure)tile);
        }
    }
}

