/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.blocks.BlockDecorDirectedHorizontal;
import wile.engineersdecor.detail.ExtItems;
import wile.engineersdecor.detail.ItemHandling;

public class BlockDecorMilker
extends BlockDecorDirectedHorizontal {
    public static final int BUCKET_SIZE = 1000;
    public static final int TICK_INTERVAL = 80;
    public static final int PROCESSING_TICK_INTERVAL = 20;
    public static final int TANK_CAPACITY = 12000;
    public static final int MAX_MILKING_TANK_LEVEL = 11500;
    public static final int FILLED_INDICATION_THRESHOLD = 1000;
    public static final int MAX_ENERGY_BUFFER = 16000;
    public static final int MAX_ENERGY_TRANSFER = 512;
    public static final int DEFAULT_ENERGY_CONSUMPTION = 0;
    private static FluidStack milk_fluid_ = new FluidStack(FluidRegistry.WATER, 0);
    private static HashMap<ItemStack, ItemStack> milk_containers_ = new HashMap();
    private static int energy_consumption = 0;
    public static final PropertyBool FILLED = PropertyBool.func_177716_a((String)"filled");
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");

    public static void on_config(int energy_consumption_per_tick) {
        energy_consumption = MathHelper.func_76125_a((int)energy_consumption_per_tick, (int)0, (int)128);
        Fluid milk = FluidRegistry.getFluid((String)"milk");
        if (milk != null) {
            milk_fluid_ = new FluidStack(milk, 1000);
        }
        milk_containers_.put(new ItemStack(Items.field_151133_ar), new ItemStack(Items.field_151117_aB));
        if (ExtItems.BOTTLED_MILK_BOTTLE_DRINKLABLE != null) {
            milk_containers_.put(new ItemStack(Items.field_151069_bo), new ItemStack(ExtItems.BOTTLED_MILK_BOTTLE_DRINKLABLE));
        }
        ModEngineersDecor.logger.info("Config milker energy consumption:" + energy_consumption + "rf/t" + (milk_fluid_ == null ? "" : " [milk fluid available]") + (ExtItems.BOTTLED_MILK_BOTTLE_DRINKLABLE == null ? "" : " [bottledmilk mod available]"));
    }

    public BlockDecorMilker(@Nonnull String registryName, long config, @Nullable Material material, float hardness, float resistance, @Nullable SoundType sound, @Nonnull AxisAlignedBB unrotatedAABB) {
        super(registryName, config, material, hardness, resistance, sound, unrotatedAABB);
        this.func_149713_g(0);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, FILLED, ACTIVE});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return super.func_176203_a(meta).func_177226_a((IProperty)FILLED, (Comparable)Boolean.valueOf((meta & 4) != 0)).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return super.func_176201_c(state) | ((Boolean)state.func_177229_b((IProperty)FILLED) != false ? 4 : 0) | ((Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? 8 : 0);
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a((IProperty)FILLED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        BTileEntity te = this.getTe(world, pos);
        return te == null ? 0 : MathHelper.func_76125_a((int)(16 * te.fluid_level() / 12000), (int)0, (int)15);
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new BTileEntity();
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (world.field_72995_K) {
            return true;
        }
        BTileEntity te = this.getTe(world, pos);
        if (te == null) {
            return super.removedByPlayer(state, world, pos, player, willHarvest);
        }
        NBTTagCompound te_nbt = te.destroy_getnbt();
        ItemStack stack = new ItemStack((Block)this, 1);
        if (te_nbt != null && !te_nbt.func_82582_d()) {
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            nbt.func_74782_a("tedata", (NBTBase)te_nbt);
            stack.func_77982_d(nbt);
        }
        world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack));
        world.func_175698_g(pos);
        world.func_175713_t(pos);
        return false;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        super.onBlockExploded(world, pos, explosion);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack insert_stack;
        ItemStack remainder;
        if (world.field_72995_K) {
            return true;
        }
        BTileEntity te = this.getTe(world, pos);
        if (te == null) {
            return true;
        }
        ItemStack in_stack = player.func_184586_b(hand);
        ItemStack out_stack = BTileEntity.milk_filled_container_item(in_stack);
        if (out_stack.func_190926_b()) {
            return FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)te.fluid_handler());
        }
        boolean drained = false;
        PlayerMainInvWrapper player_inventory = new PlayerMainInvWrapper(player.field_71071_by);
        if (te.fluid_level() >= 1000 && (remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)player_inventory, (ItemStack)(insert_stack = out_stack.func_77946_l()), (boolean)false)).func_190916_E() < insert_stack.func_190916_E()) {
            te.drain(1000);
            in_stack.func_190918_g(1);
            drained = true;
            if (remainder.func_190916_E() > 0) {
                EntityItem ei = new EntityItem(world, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, remainder);
                ei.func_174867_a(40);
                ei.field_70159_w = 0.0;
                ei.field_70179_y = 0.0;
                world.func_72838_d((Entity)ei);
            }
        }
        if (drained) {
            world.func_184133_a(null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 0.8f, 1.0f);
        }
        return true;
    }

    @Nullable
    private BTileEntity getTe(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return !(te instanceof BTileEntity) ? null : (BTileEntity)te;
    }

    public static class BTileEntity
    extends TileEntity
    implements ITickable,
    ICapabilityProvider,
    IEnergyStorage {
        private static final EnumFacing[] FLUID_TRANSFER_DIRECTRIONS = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.NORTH};
        private int tick_timer_;
        private int energy_stored_;
        private int tank_level_ = 0;
        private UUID tracked_cow_ = null;
        private MilkingState state_ = MilkingState.IDLE;
        private int state_timeout_ = 0;
        private int state_timer_ = 0;
        private BlockPos tracked_cow_original_position_ = null;
        private final BFluidHandler fluid_handler_ = new BFluidHandler(this);

        public BTileEntity() {
            this.reset();
        }

        public void reset() {
            this.tank_level_ = 0;
            this.energy_stored_ = 0;
            this.tick_timer_ = 0;
            this.tracked_cow_ = null;
            this.state_ = MilkingState.IDLE;
            this.state_timeout_ = 0;
        }

        public NBTTagCompound destroy_getnbt() {
            UUID cowuid = this.tracked_cow_;
            NBTTagCompound nbt = new NBTTagCompound();
            this.writenbt(nbt, false);
            this.reset();
            if (cowuid == null) {
                return nbt;
            }
            this.field_145850_b.func_175647_a(EntityCow.class, new AxisAlignedBB(this.field_174879_c).func_72314_b(16.0, 16.0, 16.0), e -> e.getPersistentID().equals(cowuid)).forEach(e -> e.func_94061_f(false));
            return nbt;
        }

        public void readnbt(NBTTagCompound nbt, boolean update_packet) {
            this.tank_level_ = nbt.func_74762_e("tank");
            this.energy_stored_ = nbt.func_74762_e("energy");
        }

        protected void writenbt(NBTTagCompound nbt, boolean update_packet) {
            if (this.tank_level_ > 0) {
                nbt.func_74768_a("tank", this.tank_level_);
            }
            if (this.energy_stored_ > 0) {
                nbt.func_74768_a("energy", this.energy_stored_);
            }
        }

        private IFluidHandler fluid_handler() {
            return this.fluid_handler_;
        }

        private int fluid_level() {
            return MathHelper.func_76125_a((int)this.tank_level_, (int)0, (int)12000);
        }

        private void drain(int amount) {
            this.tank_level_ = MathHelper.func_76125_a((int)(this.tank_level_ - 1000), (int)0, (int)12000);
            this.func_70296_d();
        }

        public boolean shouldRefresh(World world, BlockPos pos, IBlockState os, IBlockState ns) {
            return os.func_177230_c() != ns.func_177230_c() || !(ns.func_177230_c() instanceof BlockDecorMilker);
        }

        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.readnbt(nbt, false);
        }

        public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
            super.func_189515_b(nbt);
            this.writenbt(nbt, false);
            return nbt;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }

        public int getMaxEnergyStored() {
            return 16000;
        }

        public int getEnergyStored() {
            return this.energy_stored_;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (this.energy_stored_ >= 16000) {
                return 0;
            }
            int n = Math.min(maxReceive, 16000 - this.energy_stored_);
            if (n > 512) {
                n = 512;
            }
            if (!simulate) {
                this.energy_stored_ += n;
                this.func_70296_d();
            }
            return n;
        }

        public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
            if (cap == CapabilityEnergy.ENERGY && energy_consumption > 0) {
                return true;
            }
            if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && milk_fluid_.amount > 0) {
                return true;
            }
            return super.hasCapability(cap, facing);
        }

        @Nullable
        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return (T)this.fluid_handler_;
            }
            if (capability == CapabilityEnergy.ENERGY) {
                return (T)((Object)this);
            }
            return (T)super.getCapability(capability, facing);
        }

        private void log(String s) {
        }

        private static ItemStack milk_filled_container_item(ItemStack stack) {
            return milk_containers_.entrySet().stream().filter(e -> ((ItemStack)e.getKey()).func_77969_a(stack)).map(Map.Entry::getValue).findFirst().orElse(ItemStack.field_190927_a);
        }

        private void fill_adjacent_inventory_item_containers(EnumFacing block_facing) {
            IItemHandler src = ItemHandling.itemhandler(this.field_145850_b, this.field_174879_c.func_177972_a(block_facing), block_facing.func_176734_d());
            IItemHandler dst = ItemHandling.itemhandler(this.field_145850_b, this.field_174879_c.func_177977_b(), EnumFacing.UP);
            if (src == null) {
                src = dst;
            } else if (dst == null) {
                dst = src;
            }
            if (src == null || dst == null) {
                return;
            }
            while (this.tank_level_ >= 1000) {
                boolean inserted = false;
                for (Map.Entry e : milk_containers_.entrySet()) {
                    if (ItemHandling.extract(src, (ItemStack)e.getKey(), 1, true).func_190926_b() || !ItemHandling.insert(dst, ((ItemStack)e.getValue()).func_77946_l(), false).func_190926_b()) continue;
                    ItemHandling.extract(src, (ItemStack)e.getKey(), 1, false);
                    this.tank_level_ -= 1000;
                    inserted = true;
                }
                if (inserted) continue;
                break;
            }
        }

        private boolean milking_process() {
            if (this.tracked_cow_ == null && this.fluid_level() >= 11500) {
                return false;
            }
            EnumFacing facing = ((EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockDecorDirectedHorizontal.FACING)).func_176734_d();
            EntityCow cow = null;
            AxisAlignedBB aabb = new AxisAlignedBB(this.field_174879_c.func_177967_a(facing, 3)).func_72314_b(4.0, 2.0, 4.0);
            List cows = this.field_145850_b.func_175647_a(EntityCow.class, aabb, e -> this.tracked_cow_ == null && !e.func_70631_g_() && !e.func_70880_s() || e.getPersistentID().equals(this.tracked_cow_));
            if (cows.size() == 1) {
                cow = (EntityCow)cows.get(0);
            } else if (cows.size() > 1) {
                cow = (EntityCow)cows.get(this.field_145850_b.field_73012_v.nextInt(cows.size() - 1));
            }
            if (this.state_ != MilkingState.IDLE && (this.state_timeout_ -= 20) <= 0) {
                this.log("Cow motion timeout");
                cow = null;
            }
            if (cow == null || cow.field_70128_L || this.tracked_cow_ != null && !this.tracked_cow_.equals(cow.getPersistentID())) {
                this.tracked_cow_ = null;
                cow = null;
            }
            if (this.tracked_cow_ == null) {
                this.state_ = MilkingState.IDLE;
            }
            if (cow == null) {
                return false;
            }
            this.tick_timer_ = 20;
            this.state_timer_ -= 20;
            if (this.state_timer_ > 0) {
                return false;
            }
            switch (this.state_) {
                case IDLE: {
                    List blocking_entities = this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_174879_c.func_177972_a(facing)).func_72314_b(0.5, 0.5, 0.5));
                    if (blocking_entities.size() > 0) {
                        this.tick_timer_ = 80;
                        return false;
                    }
                    if (cow.func_110167_bD() || cow.func_70631_g_() || cow.func_70880_s() || !cow.field_70122_E || cow.func_184207_aI() || cow.func_70051_ag()) {
                        return false;
                    }
                    this.tracked_cow_ = cow.getPersistentID();
                    this.state_ = MilkingState.PICKED;
                    this.state_timeout_ = 200;
                    this.tracked_cow_original_position_ = cow.func_180425_c();
                    this.log("Idle: Picked cow" + this.tracked_cow_);
                    return false;
                }
                case PICKED: {
                    if (cow.func_70781_l()) {
                        return false;
                    }
                    BlockPos p = this.func_174877_v().func_177972_a(facing).func_177972_a(facing.func_176746_e());
                    if (!cow.func_70661_as().func_75492_a((double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p(), 1.0)) {
                        this.log("Picked: No path");
                        this.tracked_cow_ = null;
                        this.tick_timer_ = 80;
                        return false;
                    }
                    this.state_ = MilkingState.COMING;
                    this.state_timeout_ = 300;
                    this.log("Picked: coming");
                    return false;
                }
                case COMING: {
                    BlockPos p = this.func_174877_v().func_177972_a(facing).func_177972_a(facing.func_176746_e());
                    if (cow.func_180425_c().func_177951_i((Vec3i)p) > 1.0) {
                        if (cow.func_70781_l()) {
                            return false;
                        }
                        if (!cow.func_70661_as().func_75492_a((double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p(), 1.0)) {
                            this.log("Coming: lost path");
                            this.tracked_cow_ = null;
                            this.tick_timer_ = 80;
                            return false;
                        }
                        this.state_timeout_ -= 100;
                    } else {
                        BlockPos next_p = this.func_174877_v().func_177972_a(facing);
                        if (!cow.func_70661_as().func_75492_a((double)next_p.func_177958_n(), (double)next_p.func_177956_o(), (double)next_p.func_177952_p(), 1.0)) {
                            this.log("Coming: No path");
                            this.tracked_cow_ = null;
                            this.tick_timer_ = 80;
                            return false;
                        }
                        this.log("Coming: position reached");
                        this.state_ = MilkingState.POSITIONING;
                        this.state_timeout_ = 100;
                    }
                    return false;
                }
                case POSITIONING: {
                    BlockPos p = this.func_174877_v().func_177972_a(facing);
                    if (p.func_177957_d(cow.field_70165_t, cow.field_70163_u, cow.field_70161_v) > 0.45) {
                        if (cow.func_70781_l()) {
                            return false;
                        }
                        if (!cow.func_70661_as().func_75492_a((double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p(), 1.0)) {
                            this.log("Positioning: lost path");
                            this.tick_timer_ = 80;
                        } else {
                            this.state_timeout_ -= 25;
                        }
                        this.tracked_cow_ = null;
                        return false;
                    }
                    cow.func_94061_f(true);
                    cow.func_70091_d(MoverType.SELF, (double)p.func_177958_n() + 0.5 - cow.field_70165_t, 0.0, (double)p.func_177952_p() + 0.5 - cow.field_70161_v);
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187564_an, SoundCategory.BLOCKS, 0.5f, 1.0f);
                    this.state_timeout_ = 600;
                    this.state_ = MilkingState.MILKING;
                    this.state_timer_ = 30;
                    this.log("Positioning: start milking");
                    return false;
                }
                case MILKING: {
                    this.tank_level_ = MathHelper.func_76125_a((int)(this.tank_level_ + 1000), (int)0, (int)12000);
                    this.state_timeout_ = 600;
                    this.state_ = MilkingState.LEAVING;
                    this.state_timer_ = 20;
                    BlockPos p = this.tracked_cow_original_position_ != null ? this.tracked_cow_original_position_ : this.func_174877_v().func_177967_a(facing.func_176735_f(), 2);
                    cow.func_94061_f(false);
                    cow.func_70661_as().func_75492_a((double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p(), 1.0);
                    this.log("Milking: done, leave");
                    return true;
                }
                case LEAVING: {
                    BlockPos p = this.tracked_cow_original_position_ != null ? this.tracked_cow_original_position_ : this.func_174877_v().func_177967_a(facing.func_176735_f(), 2);
                    cow.func_70661_as().func_75492_a((double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p(), 1.0);
                    this.state_timeout_ = 600;
                    this.state_timer_ = 500;
                    this.tick_timer_ = 80;
                    this.state_ = MilkingState.WAITING;
                    this.log("Leaving: process done");
                    return true;
                }
                case WAITING: {
                    this.tick_timer_ = 80;
                    return true;
                }
            }
            this.tracked_cow_ = null;
            return this.tracked_cow_ != null;
        }

        public void func_73660_a() {
            IBlockState new_state;
            if (this.field_145850_b.field_72995_K || --this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 80;
            IBlockState block_state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(block_state.func_177230_c() instanceof BlockDecorMilker)) {
                return;
            }
            boolean dirty = false;
            if (energy_consumption > 0) {
                if (this.energy_stored_ <= 0) {
                    return;
                }
                this.energy_stored_ = MathHelper.func_76125_a((int)(this.energy_stored_ - energy_consumption), (int)0, (int)16000);
            }
            if (this.milking_process()) {
                dirty = true;
            }
            if (milk_fluid_.amount > 0 && this.fluid_level() >= 1000) {
                for (EnumFacing facing : FLUID_TRANSFER_DIRECTRIONS) {
                    IFluidHandler fh = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177972_a(facing), (EnumFacing)facing.func_176734_d());
                    if (fh == null) continue;
                    FluidStack fs = milk_fluid_.copy();
                    fs.amount = 1000;
                    int nfilled = MathHelper.func_76125_a((int)fh.fill(fs, true), (int)0, (int)1000);
                    if (nfilled <= 0) continue;
                    this.tank_level_ -= nfilled;
                    if (this.tank_level_ < 0) {
                        this.tank_level_ = 0;
                    }
                    dirty = true;
                    break;
                }
            }
            if (dirty && this.fluid_level() >= 1000) {
                this.fill_adjacent_inventory_item_containers((EnumFacing)block_state.func_177229_b((IProperty)BlockDecorDirectedHorizontal.FACING));
            }
            if (block_state != (new_state = block_state.func_177226_a((IProperty)FILLED, (Comparable)Boolean.valueOf(this.fluid_level() >= 1000)).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(this.state_ == MilkingState.MILKING)))) {
                this.field_145850_b.func_180501_a(this.field_174879_c, new_state, 19);
            }
            if (dirty) {
                this.func_70296_d();
            }
        }

        private static class BFluidHandler
        implements IFluidHandler,
        IFluidTankProperties {
            private final BTileEntity te;
            private final IFluidTankProperties[] props_ = new IFluidTankProperties[]{this};

            BFluidHandler(BTileEntity te) {
                this.te = te;
            }

            @Nullable
            public FluidStack getContents() {
                return new FluidStack(milk_fluid_, this.te.fluid_level());
            }

            public IFluidTankProperties[] getTankProperties() {
                return this.props_;
            }

            public int fill(FluidStack resource, boolean doFill) {
                return 0;
            }

            public int getCapacity() {
                return 12000;
            }

            public boolean canFill() {
                return false;
            }

            public boolean canDrain() {
                return milk_fluid_.amount > 0;
            }

            public boolean canFillFluidType(FluidStack fs) {
                return false;
            }

            public boolean canDrainFluidType(FluidStack fs) {
                return fs.isFluidEqual(milk_fluid_);
            }

            @Nullable
            public FluidStack drain(FluidStack resource, boolean doDrain) {
                return !resource.isFluidEqual(milk_fluid_) ? null : this.drain(resource.amount, doDrain);
            }

            @Nullable
            public FluidStack drain(int maxDrain, boolean doDrain) {
                if (this.te.fluid_level() <= 0) {
                    return null;
                }
                FluidStack fs = milk_fluid_.copy();
                fs.amount = Math.min(fs.amount, this.te.fluid_level());
                if (doDrain) {
                    BTileEntity bTileEntity = this.te;
                    bTileEntity.tank_level_ = bTileEntity.tank_level_ - fs.amount;
                }
                return fs;
            }
        }

        private static enum MilkingState {
            IDLE,
            PICKED,
            COMING,
            POSITIONING,
            MILKING,
            LEAVING,
            WAITING;

        }
    }
}

