/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.features.gdo.client.gui;

import gcewing.sg.SGCraft;
import gcewing.sg.features.gdo.network.GdoNetworkHandler;
import gcewing.sg.network.GuiNetworkHandler;
import gcewing.sg.tileentity.SGBaseTE;
import gcewing.sg.util.IrisState;
import gcewing.sg.util.SGAddressing;
import gcewing.sg.util.SGState;
import net.malisis.core.client.gui.Anchor;
import net.malisis.core.client.gui.BasicScreen;
import net.malisis.core.client.gui.GuiTexture;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.BasicForm;
import net.malisis.core.client.gui.component.decoration.UIImage;
import net.malisis.core.client.gui.component.decoration.UILabel;
import net.malisis.core.client.gui.component.interaction.UIButton;
import net.malisis.core.client.gui.component.interaction.button.builder.UIButtonBuilder;
import net.malisis.core.renderer.font.FontOptions;
import net.malisis.core.util.FontColors;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GdoScreen
extends BasicScreen {
    private int lastUpdate = 0;
    private boolean unlockMouse = true;
    private boolean isAdmin;
    private boolean debugScreen = false;
    private BasicForm form;
    private BasicForm localGateControlArea;
    private BasicForm remoteGateControlArea;
    private UIButton localIrisOpenButton;
    private UIButton localGateCloseButton;
    private UIButton localIrisCloseButton;
    private UIButton remoteIrisOpenButton;
    private UIButton remoteGateCloseButton;
    private UIButton remoteIrisCloseButton;
    private UIImage localGateImage;
    private UIImage remoteGateImage;
    private UILabel localGateAddressLabel;
    private UILabel remoteGateAddressLabel;
    private BlockPos location;
    private BlockPos gatePos;
    private World world;
    private EntityPlayer player;
    public boolean isRemoteConnected;
    public boolean r_hasIrisUpgrade;
    public boolean r_hasChevronUpgrade;
    public boolean r_isIrisClosed;
    public boolean canAccessLocal;
    public boolean canAccessRemote;
    public String r_address;
    public int r_gateType;
    public SGBaseTE localGate;

    public GdoScreen(EntityPlayer player, World worldIn, BlockPos gatePos, boolean isAdmin, boolean isRemoteConnected, boolean r_hasIrisUpgrade, boolean r_hasChevronUpgrade, boolean r_isIrisClosed, int r_gateType, String r_address, boolean canAccessLocal, boolean canAccessRemote) {
        this.player = player;
        this.world = worldIn;
        this.gatePos = gatePos;
        this.isAdmin = isAdmin;
        this.location = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        this.isRemoteConnected = isRemoteConnected;
        this.r_hasIrisUpgrade = r_hasIrisUpgrade;
        this.r_hasChevronUpgrade = r_hasChevronUpgrade;
        this.r_isIrisClosed = r_isIrisClosed;
        this.r_gateType = r_gateType;
        this.r_address = r_address;
        this.canAccessLocal = canAccessLocal;
        this.canAccessRemote = canAccessRemote;
    }

    public void construct() {
        this.guiscreenBackground = false;
        Keyboard.enableRepeatEvents((boolean)true);
        TileEntity localGateTE = this.world.func_175625_s(this.gatePos);
        if (localGateTE instanceof SGBaseTE) {
            this.localGate = (SGBaseTE)localGateTE;
            if (!this.localGate.isMerged) {
                SGBaseTE.sendGenericErrorMsg(this.player, "No Local Stargate within range.");
                return;
            }
        } else {
            SGBaseTE.sendGenericErrorMsg(this.player, "No Local Stargate within range.");
            return;
        }
        this.form = new BasicForm((MalisisGui)this, 400, 225, "");
        this.form.setAnchor(Anchor.CENTER | Anchor.MIDDLE);
        this.form.setMovable(true);
        this.form.setClosable(true);
        this.form.setBorder(0xFFFFFF, 1, 185);
        this.form.setBackgroundAlpha(215);
        this.form.setBottomPadding(3);
        this.form.setRightPadding(3);
        this.form.setTopPadding(20);
        this.form.setLeftPadding(3);
        UILabel titleLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.gdo.label.gdoController", (Object[])new Object[0]));
        titleLabel.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(true).scale(1.1f).build());
        titleLabel.setPosition(0, -15, Anchor.CENTER | Anchor.TOP);
        this.localGateControlArea = new BasicForm((MalisisGui)this, 195, 185, "");
        this.localGateControlArea.setPosition(0, 0, Anchor.LEFT | Anchor.MIDDLE);
        this.localGateControlArea.setMovable(false);
        this.localGateControlArea.setClosable(false);
        this.localGateControlArea.setBorder(0xFFFFFF, 1, 185);
        this.localGateControlArea.setBackgroundAlpha(215);
        this.localGateControlArea.setBottomPadding(3);
        this.localGateControlArea.setRightPadding(3);
        this.localGateControlArea.setTopPadding(3);
        this.localGateControlArea.setLeftPadding(3);
        UILabel localGateControlLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.gdo.label.localGateControl", (Object[])new Object[0]));
        localGateControlLabel.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(true).scale(1.1f).build());
        localGateControlLabel.setPosition(0, 0, Anchor.CENTER | Anchor.TOP);
        this.localGateImage = new UIImage((MalisisGui)this, new GuiTexture(SGCraft.mod.resourceLocation("textures/gui_image1.png")), null);
        this.localGateImage.setSize(110, 110);
        this.localGateImage.setPosition(0, 20, Anchor.TOP | Anchor.CENTER);
        this.localGateAddressLabel = new UILabel((MalisisGui)this, "gateAddress");
        this.localGateAddressLabel.setFontOptions(FontOptions.builder().from(FontColors.BLUE_FO).shadow(true).scale(1.3f).build());
        this.localGateAddressLabel.setPosition(0, -30, Anchor.CENTER | Anchor.BOTTOM);
        this.localIrisOpenButton = new UIButtonBuilder((MalisisGui)this).width(40).anchor(Anchor.BOTTOM | Anchor.LEFT).text(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.button.openIris", (Object[])new Object[0])).enabled(this.canAccessLocal).onClick(() -> GdoNetworkHandler.sendGdoInputToServer(this.localGate, 1)).listener((Object)this).build("button.local.iris.open");
        this.localGateCloseButton = new UIButtonBuilder((MalisisGui)this).width(40).anchor(Anchor.BOTTOM | Anchor.CENTER).text(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.button.disconnect", (Object[])new Object[0])).onClick(() -> GdoNetworkHandler.sendGdoInputToServer(this.localGate, 3)).listener((Object)this).build("button.local.gate.disconnect");
        this.localIrisCloseButton = new UIButtonBuilder((MalisisGui)this).width(40).anchor(Anchor.BOTTOM | Anchor.RIGHT).text(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.button.closeIris", (Object[])new Object[0])).enabled(this.canAccessLocal).onClick(() -> GdoNetworkHandler.sendGdoInputToServer(this.localGate, 2)).listener((Object)this).build("button.local.iris.close");
        this.localGateControlArea.add(new UIComponent[]{localGateControlLabel, this.localGateImage, this.localGateAddressLabel, this.localIrisOpenButton, this.localGateCloseButton, this.localIrisCloseButton});
        this.remoteGateControlArea = new BasicForm((MalisisGui)this, 195, 185, "");
        this.remoteGateControlArea.setPosition(0, 0, Anchor.RIGHT | Anchor.MIDDLE);
        this.remoteGateControlArea.setMovable(false);
        this.remoteGateControlArea.setClosable(false);
        this.remoteGateControlArea.setBorder(0xFFFFFF, 1, 185);
        this.remoteGateControlArea.setBackgroundAlpha(215);
        this.remoteGateControlArea.setBottomPadding(3);
        this.remoteGateControlArea.setRightPadding(3);
        this.remoteGateControlArea.setTopPadding(3);
        this.remoteGateControlArea.setLeftPadding(3);
        UILabel remoteGateControlLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.gdo.label.remoteGateControl", (Object[])new Object[0]));
        remoteGateControlLabel.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(true).scale(1.1f).build());
        remoteGateControlLabel.setPosition(0, 0, Anchor.CENTER | Anchor.TOP);
        this.remoteGateImage = new UIImage((MalisisGui)this, new GuiTexture(SGCraft.mod.resourceLocation("textures/gui_image1.png")), null);
        this.remoteGateImage.setSize(110, 110);
        this.remoteGateImage.setPosition(0, 20, Anchor.TOP | Anchor.CENTER);
        this.remoteGateAddressLabel = new UILabel((MalisisGui)this, "gateAddress");
        this.remoteGateAddressLabel.setFontOptions(FontOptions.builder().from(FontColors.BLUE_FO).shadow(true).scale(1.3f).build());
        this.remoteGateAddressLabel.setPosition(0, -30, Anchor.CENTER | Anchor.BOTTOM);
        this.remoteIrisOpenButton = new UIButtonBuilder((MalisisGui)this).width(40).anchor(Anchor.BOTTOM | Anchor.LEFT).text(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.button.openIris", (Object[])new Object[0])).enabled(this.canAccessRemote).onClick(() -> GdoNetworkHandler.sendGdoInputToServer(this.localGate, 4)).listener((Object)this).build("button.remote.iris.open");
        this.remoteGateCloseButton = new UIButtonBuilder((MalisisGui)this).width(40).anchor(Anchor.BOTTOM | Anchor.CENTER).text(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.button.disconnect", (Object[])new Object[0])).visible(false).onClick(() -> {}).listener((Object)this).build("button.remote.gate.disconnect");
        this.remoteIrisCloseButton = new UIButtonBuilder((MalisisGui)this).width(40).anchor(Anchor.BOTTOM | Anchor.RIGHT).text(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.button.closeIris", (Object[])new Object[0])).enabled(this.canAccessRemote).onClick(() -> GdoNetworkHandler.sendGdoInputToServer(this.localGate, 5)).listener((Object)this).build("button.remote.iris.close");
        this.remoteGateControlArea.add(new UIComponent[]{remoteGateControlLabel, this.remoteGateImage, this.remoteGateAddressLabel, this.remoteIrisOpenButton, this.remoteGateCloseButton, this.remoteIrisCloseButton});
        UIButton buttonClose = new UIButtonBuilder((MalisisGui)this).width(40).anchor(Anchor.BOTTOM | Anchor.RIGHT).text(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.button.close", (Object[])new Object[0])).onClick(() -> this.close()).listener((Object)this).build("button.close");
        this.form.add(new UIComponent[]{titleLabel, this.localGateControlArea, this.remoteGateControlArea, buttonClose});
        this.addToScreen((UIComponent)this.form);
        this.refresh();
    }

    private void refresh() {
        if (this.localGate != null) {
            if (this.localGate.isMerged) {
                this.localGateAddressLabel.setText(SGAddressing.formatAddress(this.localGate.homeAddress, "-", "-"));
            }
            if (!(this.localGate.isConnected() || this.localGate.hasIrisUpgrade || this.localGate.gateType != 0 && this.localGate.gateType != 1)) {
                this.localGateImage.setIcon(new GuiTexture(SGCraft.mod.resourceLocation("textures/milkyway_disconnected_no_iris.png")), null);
            }
            if (!this.localGate.isConnected() && !this.localGate.hasIrisUpgrade && this.localGate.gateType == 2) {
                this.localGateImage.setIcon(new GuiTexture(SGCraft.mod.resourceLocation("textures/pegasus_disconnected_no_iris.png")), null);
            }
            if (this.localGate.isConnected() && !this.localGate.hasIrisUpgrade && (this.localGate.gateType == 0 || this.localGate.gateType == 1)) {
                this.localGateImage.setIcon(new GuiTexture(SGCraft.mod.resourceLocation("textures/milkyway_connected_no_iris.png")), null);
            }
            if (this.localGate.isConnected() && !this.localGate.hasIrisUpgrade && this.localGate.gateType == 2) {
                this.localGateImage.setIcon(new GuiTexture(SGCraft.mod.resourceLocation("textures/pegasus_connected_no_iris.png")), null);
            }
            if (!this.localGate.isConnected() && this.localGate.hasIrisUpgrade && (this.localGate.gateType == 0 || this.localGate.gateType == 1) && this.localGate.irisIsClosed()) {
                this.localGateImage.setIcon(new GuiTexture(SGCraft.mod.resourceLocation("textures/milkyway_disconnected_iris_closed.png")), null);
            }
            if (!this.localGate.isConnected() && this.localGate.hasIrisUpgrade && this.localGate.gateType == 2 && this.localGate.irisIsClosed()) {
                this.localGateImage.setIcon(new GuiTexture(SGCraft.mod.resourceLocation("textures/pegasus_disconnected_iris_closed.png")), null);
            }
            if (this.localGate.isConnected() && this.localGate.hasIrisUpgrade && (this.localGate.gateType == 0 || this.localGate.gateType == 1) && this.localGate.irisIsClosed()) {
                this.localGateImage.setIcon(new GuiTexture(SGCraft.mod.resourceLocation("textures/milkyway_connected_iris_closed.png")), null);
            }
            if (this.localGate.isConnected() && this.localGate.hasIrisUpgrade && this.localGate.gateType == 2 && this.localGate.irisIsClosed()) {
                this.localGateImage.setIcon(new GuiTexture(SGCraft.mod.resourceLocation("textures/pegasus_connected_iris_closed.png")), null);
            }
            if (!(this.localGate.isConnected() || !this.localGate.hasIrisUpgrade || this.localGate.gateType != 0 && this.localGate.gateType != 1 || this.localGate.irisIsClosed())) {
                this.localGateImage.setIcon(new GuiTexture(SGCraft.mod.resourceLocation("textures/milkyway_disconnected_iris_open.png")), null);
            }
            if (!this.localGate.isConnected() && this.localGate.hasIrisUpgrade && this.localGate.gateType == 2 && !this.localGate.irisIsClosed()) {
                this.localGateImage.setIcon(new GuiTexture(SGCraft.mod.resourceLocation("textures/pegasus_disconnected_iris_open.png")), null);
            }
            if (this.localGate.isConnected() && this.localGate.hasIrisUpgrade && (this.localGate.gateType == 0 || this.localGate.gateType == 1) && !this.localGate.irisIsClosed()) {
                this.localGateImage.setIcon(new GuiTexture(SGCraft.mod.resourceLocation("textures/milkyway_connected_iris_open.png")), null);
            }
            if (this.localGate.isConnected() && this.localGate.hasIrisUpgrade && this.localGate.gateType == 2 && !this.localGate.irisIsClosed()) {
                this.localGateImage.setIcon(new GuiTexture(SGCraft.mod.resourceLocation("textures/pegasus_connected_iris_open.png")), null);
            }
            if (!this.localGate.hasIrisUpgrade) {
                this.localIrisOpenButton.setEnabled(false);
                this.localIrisCloseButton.setEnabled(false);
            } else if (this.localGate.irisState == IrisState.Closing || this.localGate.irisState == IrisState.Opening) {
                this.localIrisOpenButton.setEnabled(false);
                this.localIrisCloseButton.setEnabled(false);
            } else if (this.canAccessLocal) {
                if (this.localGate.irisIsClosed()) {
                    this.localIrisOpenButton.setEnabled(true);
                    this.localIrisCloseButton.setEnabled(false);
                } else {
                    this.localIrisOpenButton.setEnabled(false);
                    this.localIrisCloseButton.setEnabled(true);
                }
            }
            if (!this.localGate.isConnected() || this.localGate.state == SGState.Dialling || this.localGate.state == SGState.Disconnecting) {
                this.remoteGateImage.setVisible(false);
                this.localGateCloseButton.setEnabled(false);
                this.remoteGateCloseButton.setEnabled(false);
                this.remoteIrisOpenButton.setEnabled(false);
                this.remoteIrisCloseButton.setEnabled(false);
                this.form.setWidth(200);
                this.remoteGateControlArea.setVisible(false);
            } else if (this.isRemoteConnected) {
                this.form.setWidth(400);
                this.remoteGateControlArea.setVisible(true);
                this.remoteGateAddressLabel.setText(this.r_address);
                if (!(this.r_hasIrisUpgrade || this.r_gateType != 0 && this.r_gateType != 1)) {
                    this.remoteGateImage.setIcon(new GuiTexture(SGCraft.mod.resourceLocation("textures/milkyway_disconnected_no_iris.png")), null);
                }
                if (!this.r_hasIrisUpgrade && this.r_gateType == 2) {
                    this.remoteGateImage.setIcon(new GuiTexture(SGCraft.mod.resourceLocation("textures/pegasus_disconnected_no_iris.png")), null);
                }
                if (!(this.r_hasIrisUpgrade || this.r_gateType != 0 && this.r_gateType != 1)) {
                    this.remoteGateImage.setIcon(new GuiTexture(SGCraft.mod.resourceLocation("textures/milkyway_connected_no_iris.png")), null);
                }
                if (!this.r_hasIrisUpgrade && this.r_gateType == 2) {
                    this.remoteGateImage.setIcon(new GuiTexture(SGCraft.mod.resourceLocation("textures/pegasus_connected_no_iris.png")), null);
                }
                if (this.r_hasIrisUpgrade && (this.r_gateType == 0 || this.r_gateType == 1) && this.r_isIrisClosed) {
                    this.remoteGateImage.setIcon(new GuiTexture(SGCraft.mod.resourceLocation("textures/milkyway_disconnected_iris_closed.png")), null);
                }
                if (this.r_hasIrisUpgrade && this.r_gateType == 2 && this.r_isIrisClosed) {
                    this.remoteGateImage.setIcon(new GuiTexture(SGCraft.mod.resourceLocation("textures/pegasus_disconnected_iris_closed.png")), null);
                }
                if (this.r_hasIrisUpgrade && (this.r_gateType == 0 || this.r_gateType == 1) && this.r_isIrisClosed) {
                    this.remoteGateImage.setIcon(new GuiTexture(SGCraft.mod.resourceLocation("textures/milkyway_connected_iris_closed.png")), null);
                }
                if (this.r_hasIrisUpgrade && this.r_gateType == 2 && this.r_isIrisClosed) {
                    this.remoteGateImage.setIcon(new GuiTexture(SGCraft.mod.resourceLocation("textures/pegasus_connected_iris_closed.png")), null);
                }
                if (this.r_hasIrisUpgrade && (this.r_gateType == 0 || this.r_gateType == 1) && !this.r_isIrisClosed) {
                    this.remoteGateImage.setIcon(new GuiTexture(SGCraft.mod.resourceLocation("textures/milkyway_disconnected_iris_open.png")), null);
                }
                if (this.r_hasIrisUpgrade && this.r_gateType == 2 && !this.r_isIrisClosed) {
                    this.remoteGateImage.setIcon(new GuiTexture(SGCraft.mod.resourceLocation("textures/pegasus_disconnected_iris_open.png")), null);
                }
                if (this.r_hasIrisUpgrade && (this.r_gateType == 0 || this.r_gateType == 1) && !this.r_isIrisClosed) {
                    this.remoteGateImage.setIcon(new GuiTexture(SGCraft.mod.resourceLocation("textures/milkyway_connected_iris_open.png")), null);
                }
                if (this.r_hasIrisUpgrade && this.r_gateType == 2 && !this.r_isIrisClosed) {
                    this.remoteGateImage.setIcon(new GuiTexture(SGCraft.mod.resourceLocation("textures/pegasus_connected_iris_open.png")), null);
                }
                if (!this.r_hasIrisUpgrade) {
                    this.remoteIrisOpenButton.setEnabled(false);
                    this.remoteIrisCloseButton.setEnabled(false);
                } else if (this.canAccessRemote) {
                    if (this.r_isIrisClosed) {
                        this.remoteIrisOpenButton.setEnabled(true);
                        this.remoteIrisCloseButton.setEnabled(false);
                    } else {
                        this.remoteIrisOpenButton.setEnabled(false);
                        this.remoteIrisCloseButton.setEnabled(true);
                    }
                }
                this.remoteGateImage.setVisible(true);
                this.localGateCloseButton.setEnabled(true);
                this.remoteGateCloseButton.setEnabled(true);
            }
        }
    }

    public void update(int mouseX, int mouseY, float partialTick) {
        super.update(mouseX, mouseY, partialTick);
        if (this.unlockMouse && this.lastUpdate == 25) {
            Mouse.setGrabbed((boolean)false);
            this.unlockMouse = false;
        }
        if (!this.localGate.isMerged) {
            this.close();
        }
        if (this.lastUpdate == 100) {
            if (this.localGate != null) {
                GuiNetworkHandler.sendGuiRequestToServer(this.localGate, this.player, 2);
            }
            if (this.localGate.isMerged) {
                this.refresh();
            }
        }
        if (++this.lastUpdate > 120) {
            this.lastUpdate = 0;
        }
    }

    protected void func_73869_a(char keyChar, int keyCode) {
        super.func_73869_a(keyChar, keyCode);
        this.lastUpdate = 0;
    }

    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        this.lastUpdate = 0;
    }

    public boolean func_73868_f() {
        return false;
    }
}

