/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.blocks.machine.MachineRtgFurnace;
import com.hbm.items.machine.ItemRTGPellet;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.RTGUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;

public class TileEntityRtgFurnace
extends TileEntityMachineBase
implements ITickable {
    public int dualCookTime;
    public int heat;
    public static final int processingSpeed = 3000;
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{4};
    private static final int[] slots_side = new int[]{1, 2, 3};
    private String customName;

    public TileEntityRtgFurnace() {
        super(5);
    }

    @Override
    public String getName() {
        return this.hasCustomInventoryName() ? this.customName : "container.rtgFurnace";
    }

    @Override
    public String getInventoryName() {
        return this.hasCustomInventoryName() ? this.customName : "container.rtgFurnace";
    }

    @Override
    public boolean hasCustomInventoryName() {
        return this.customName != null && this.customName.length() > 0;
    }

    @Override
    public void setCustomName(String name) {
        this.customName = name;
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public boolean isLoaded() {
        return RTGUtil.hasHeat(this.inventory);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.dualCookTime = compound.func_74765_d("CookTime");
        if (compound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74777_a("cookTime", (short)this.dualCookTime);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    public int getDiFurnaceProgressScaled(int i) {
        return this.dualCookTime * i / 3000;
    }

    public boolean canProcess() {
        if (this.inventory.getStackInSlot(0).func_190926_b()) {
            return false;
        }
        ItemStack itemStack = FurnaceRecipes.func_77602_a().func_151395_a(this.inventory.getStackInSlot(0));
        if (itemStack == null || itemStack.func_190926_b()) {
            return false;
        }
        if (this.inventory.getStackInSlot(4).func_190926_b()) {
            return true;
        }
        if (!this.inventory.getStackInSlot(4).func_77969_a(itemStack)) {
            return false;
        }
        if (this.inventory.getStackInSlot(4).func_190916_E() < this.inventory.getSlotLimit(4) && this.inventory.getStackInSlot(4).func_190916_E() < this.inventory.getStackInSlot(4).func_77976_d()) {
            return true;
        }
        return this.inventory.getStackInSlot(4).func_190916_E() < itemStack.func_77976_d();
    }

    private void processItem() {
        if (this.canProcess()) {
            ItemStack itemStack = FurnaceRecipes.func_77602_a().func_151395_a(this.inventory.getStackInSlot(0));
            if (this.inventory.getStackInSlot(4).func_190926_b()) {
                this.inventory.setStackInSlot(4, itemStack.func_77946_l());
            } else if (this.inventory.getStackInSlot(4).func_77969_a(itemStack)) {
                this.inventory.getStackInSlot(4).func_190917_f(itemStack.func_190916_E());
            }
            for (int i = 0; i < 1; ++i) {
                if (this.inventory.getStackInSlot(i).func_190926_b()) {
                    this.inventory.setStackInSlot(i, new ItemStack(this.inventory.getStackInSlot(i).func_77973_b()));
                } else {
                    this.inventory.getStackInSlot(i).func_190918_g(1);
                }
                if (!this.inventory.getStackInSlot(i).func_190926_b()) continue;
                this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
            }
        }
    }

    public boolean hasPower() {
        return this.isLoaded();
    }

    public boolean isProcessing() {
        return this.dualCookTime > 0;
    }

    public void func_73660_a() {
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K) {
            this.heat = RTGUtil.updateRTGs(this.inventory, new int[]{1, 2, 3});
            if (this.hasPower() && this.canProcess()) {
                this.dualCookTime += this.heat;
                if (this.dualCookTime >= 3000) {
                    this.dualCookTime = 0;
                    this.processItem();
                    flag1 = true;
                }
            } else {
                this.dualCookTime = 0;
            }
            boolean trigger = true;
            if (this.hasPower() && this.canProcess() && this.dualCookTime == 0) {
                trigger = false;
            }
            if (trigger) {
                flag1 = true;
                MachineRtgFurnace.updateBlockState(this.dualCookTime > 0, this.field_145850_b, this.field_174879_c);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        int i = e.ordinal();
        return i == 0 ? slots_bottom : (i == 1 ? slots_top : slots_side);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack itemStack, int amount) {
        if (slot < 4 && !(itemStack.func_77973_b() instanceof ItemRTGPellet)) {
            return true;
        }
        return slot == 4;
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack stack) {
        if (0 < i && i < 4 && stack.func_77973_b() instanceof ItemRTGPellet) {
            return true;
        }
        return i == 0;
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack itemStack, int amount) {
        return this.isItemValidForSlot(slot, itemStack);
    }
}

