/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import com.hbm.lib.Library;
import com.hbm.tileentity.TileEntityMachineBase;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityMicrowave
extends TileEntityMachineBase
implements ITickable,
IEnergyUser {
    public long power;
    public static final long maxPower = 50000L;
    public static final int consumption = 50;
    public static final int maxTime = 300;
    public int time;
    public int speed;
    public static final int maxSpeed = 5;

    public TileEntityMicrowave() {
        super(3);
    }

    @Override
    public String getName() {
        return "container.microwave";
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateStandardConnections(this.field_145850_b, this.field_174879_c);
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 2, this.power, 50000L);
            if (this.canProcess()) {
                if (this.speed >= 5) {
                    this.field_145850_b.func_175655_b(this.field_174879_c, false);
                    this.field_145850_b.func_72885_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 7.5f, true, true);
                    return;
                }
                if (this.time >= 300) {
                    this.process();
                    this.time = 0;
                }
                if (this.canProcess()) {
                    this.power -= 50L;
                    this.time += this.speed * 2;
                }
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74768_a("time", this.time);
            data.func_74768_a("speed", this.speed);
            this.networkPack(data, 50);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.power = data.func_74763_f("power");
        this.time = data.func_74762_e("time");
        this.speed = data.func_74762_e("speed");
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.power = compound.func_74763_f("power");
        this.speed = compound.func_74762_e("speed");
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74772_a("power", this.power);
        compound.func_74768_a("speed", this.speed);
        return super.func_189515_b(compound);
    }

    @Override
    public void handleButtonPacket(int value, int meta) {
        if (value == 0) {
            ++this.speed;
        }
        if (value == 1) {
            --this.speed;
        }
        if (this.speed < 0) {
            this.speed = 0;
        }
        if (this.speed > 5) {
            this.speed = 5;
        }
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack stack) {
        return i == 0 && !FurnaceRecipes.func_77602_a().func_151395_a(stack).func_190926_b();
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack itemStack, int amount) {
        return slot == 1;
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        int[] nArray;
        if (e.ordinal() == 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 0;
        }
        return nArray;
    }

    private void process() {
        ItemStack stack = FurnaceRecipes.func_77602_a().func_151395_a(this.inventory.getStackInSlot(0)).func_77946_l();
        if (this.inventory.getStackInSlot(1).func_190926_b()) {
            this.inventory.setStackInSlot(1, stack);
        } else {
            this.inventory.getStackInSlot(1).func_190920_e(this.inventory.getStackInSlot(1).func_190916_E() + stack.func_190916_E());
        }
        this.inventory.getStackInSlot(0).func_190918_g(1);
        this.func_70296_d();
    }

    private boolean canProcess() {
        if (this.speed == 0) {
            return false;
        }
        if (this.power < 50L) {
            return false;
        }
        if (!FurnaceRecipes.func_77602_a().func_151395_a(this.inventory.getStackInSlot(0)).func_190926_b()) {
            ItemStack stack = FurnaceRecipes.func_77602_a().func_151395_a(this.inventory.getStackInSlot(0));
            if (this.inventory.getStackInSlot(1).func_190926_b()) {
                return true;
            }
            if (!stack.func_77969_a(this.inventory.getStackInSlot(1))) {
                return false;
            }
            return stack.func_190916_E() + this.inventory.getStackInSlot(1).func_190916_E() <= stack.func_77976_d();
        }
        return false;
    }

    public long getPowerScaled(int i) {
        return this.power * (long)i / 50000L;
    }

    public int getProgressScaled(int i) {
        return this.time * i / 300;
    }

    public int getSpeedScaled(int i) {
        return this.speed * i / 5;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 50000L;
    }
}

