/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import com.hbm.config.BombConfig;
import com.hbm.entity.effect.EntityBlackHole;
import com.hbm.entity.logic.EntityBalefire;
import com.hbm.entity.logic.EntityNukeExplosionMK5;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.explosion.ExplosionThermo;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.handler.MultiblockHandler;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.CyclotronRecipes;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.Library;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityMachineBase;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityMachineCyclotron
extends TileEntityMachineBase
implements ITickable,
IEnergyUser,
IFluidHandler,
ITankPacketAcceptor {
    public long power;
    public static final long maxPower = 100000000L;
    public int consumption = 1000000;
    public boolean isOn;
    private int age;
    private int countdown;
    private byte plugs;
    public int progress;
    public static final int duration = 690;
    public FluidTank coolant;
    public FluidTank amat;
    private TileEntity teIn1 = null;
    private TileEntity teIn2 = null;
    private TileEntity teIn3 = null;
    private TileEntity teOut1 = null;
    private TileEntity teOut2 = null;
    private TileEntity teOut3 = null;

    public TileEntityMachineCyclotron() {
        super(0);
        this.inventory = new ItemStackHandler(16){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                TileEntityMachineCyclotron.this.func_70296_d();
            }

            public void setStackInSlot(int slot, ItemStack stack) {
                if (stack != null && slot >= 14 && slot <= 15 && stack.func_77973_b() instanceof ItemMachineUpgrade) {
                    TileEntityMachineCyclotron.this.field_145850_b.func_184148_a(null, (double)TileEntityMachineCyclotron.this.field_174879_c.func_177958_n() + 0.5, (double)TileEntityMachineCyclotron.this.field_174879_c.func_177956_o() + 1.5, (double)TileEntityMachineCyclotron.this.field_174879_c.func_177952_p() + 0.5, HBMSoundHandler.upgradePlug, SoundCategory.BLOCKS, 1.5f, 1.0f);
                }
                super.setStackInSlot(slot, stack);
            }
        };
        this.coolant = new FluidTank(32000);
        this.amat = new FluidTank(8000);
    }

    @Override
    public String getName() {
        return "container.cyclotron";
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        int side = e.func_176745_a();
        if (side == 2) {
            return new int[]{6, 7, 8};
        }
        if (side == 3) {
            return new int[]{9, 10, 11, 12};
        }
        if (side == 4) {
            return new int[]{0, 1, 2};
        }
        if (side == 5) {
            return new int[]{3, 4, 5};
        }
        return new int[0];
    }

    private void findContainers() {
        int meta = this.func_145832_p();
        if (meta == 14) {
            this.teIn1 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-3, 0, -1));
            this.teIn2 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-3, 0, 0));
            this.teIn3 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-3, 0, 1));
            this.teOut1 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(3, 0, -1));
            this.teOut2 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(3, 0, 0));
            this.teOut3 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(3, 0, 1));
        }
        if (meta == 12) {
            this.teIn1 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(1, 0, -3));
            this.teIn2 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 0, -3));
            this.teIn3 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-1, 0, -3));
            this.teOut1 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(1, 0, 3));
            this.teOut2 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 0, 3));
            this.teOut3 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-1, 0, 3));
        }
        if (meta == 15) {
            this.teIn1 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(3, 0, 1));
            this.teIn2 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(3, 0, 0));
            this.teIn3 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(3, 0, -1));
            this.teOut1 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-3, 0, 1));
            this.teOut2 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-3, 0, 0));
            this.teOut3 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-3, 0, -1));
        }
        if (meta == 13) {
            this.teIn1 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-1, 0, 3));
            this.teIn2 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 0, 3));
            this.teIn3 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(1, 0, 3));
            this.teOut1 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-1, 0, -3));
            this.teOut2 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 0, -3));
            this.teOut3 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(1, 0, -3));
        }
    }

    private void fillFromContainers(TileEntity tile, int inputSlot, int tagetSlot) {
        TileEntity capte;
        int meta = this.func_145832_p();
        if (tile != null && tile instanceof ICapabilityProvider && (capte = tile).hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, MultiblockHandler.intToEnumFacing(meta).func_176746_e())) {
            IItemHandler cap = (IItemHandler)capte.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, MultiblockHandler.intToEnumFacing(meta).func_176746_e());
            if (tile instanceof TileEntityMachineBase) {
                int[] slots = ((TileEntityMachineBase)tile).getAccessibleSlotsFromSide(MultiblockHandler.intToEnumFacing(meta).func_176746_e());
                this.tryFillAssemblerCap(cap, slots, (TileEntityMachineBase)tile, inputSlot, tagetSlot);
            } else {
                int[] slots = new int[cap.getSlots()];
                for (int i = 0; i < slots.length; ++i) {
                    slots[i] = i;
                }
                this.tryFillAssemblerCap(cap, slots, null, inputSlot, tagetSlot);
            }
        }
    }

    public static boolean isItemATarget(Item item) {
        return item == ModItems.part_lithium || item == ModItems.part_beryllium || item == ModItems.part_carbon || item == ModItems.part_copper || item == ModItems.part_plutonium;
    }

    public boolean tryFillAssemblerCap(IItemHandler container, int[] allowedSlots, TileEntityMachineBase te, int inputSlot, int targetSlot) {
        if (allowedSlots.length < 1) {
            return false;
        }
        int inputAmount = this.inventory.getStackInSlot(inputSlot).func_77976_d() - this.inventory.getStackInSlot(inputSlot).func_190916_E();
        int targetAmount = this.inventory.getStackInSlot(targetSlot).func_77976_d() - this.inventory.getStackInSlot(targetSlot).func_190916_E();
        RecipesCommon.AStack inputItem = new RecipesCommon.NbtComparableStack(this.inventory.getStackInSlot(inputSlot).func_77946_l()).singulize();
        RecipesCommon.AStack targetItem = new RecipesCommon.NbtComparableStack(this.inventory.getStackInSlot(targetSlot).func_77946_l()).singulize();
        int inputDelta = inputAmount;
        int targetDelta = targetAmount;
        for (int slot : allowedSlots) {
            ItemStack compareStack;
            if (container.getStackInSlot(slot) == null || container.getStackInSlot(slot).func_190926_b()) continue;
            ItemStack stack = container.getStackInSlot(slot).func_77946_l();
            if (this.inventory.getStackInSlot(inputSlot) == null || this.inventory.getStackInSlot(inputSlot).func_190926_b()) {
                if (TileEntityMachineCyclotron.isItemATarget(stack.func_77973_b())) {
                    inputDelta = this.moveItem(container, inputSlot, slot, inputDelta, te);
                    continue;
                }
            } else {
                compareStack = stack.func_77946_l();
                compareStack.func_190920_e(1);
                if (inputDelta > 0 && inputItem.isApplicable(compareStack)) {
                    inputDelta = this.moveItem(container, inputSlot, slot, inputDelta, te);
                    continue;
                }
            }
            if (this.inventory.getStackInSlot(targetSlot) == null || this.inventory.getStackInSlot(targetSlot).func_190926_b()) {
                if (TileEntityMachineCyclotron.isItemATarget(stack.func_77973_b())) continue;
                targetDelta = this.moveItem(container, targetSlot, slot, targetDelta, te);
                continue;
            }
            compareStack = stack.func_77946_l();
            compareStack.func_190920_e(1);
            if (targetDelta <= 0 || !targetItem.isApplicable(compareStack)) continue;
            targetDelta = this.moveItem(container, targetSlot, slot, targetDelta, te);
        }
        return true;
    }

    private int moveItem(IItemHandler container, int inventorySlot, int containerSlot, int amount, TileEntityMachineBase te) {
        ItemStack stack = container.getStackInSlot(containerSlot).func_77946_l();
        int foundCount = Math.min(stack.func_190916_E(), amount);
        if (te != null && !te.canExtractItem(containerSlot, stack, foundCount)) {
            return amount;
        }
        if (foundCount > 0) {
            container.extractItem(containerSlot, foundCount, false);
            if (this.inventory.getStackInSlot(inventorySlot) == null || this.inventory.getStackInSlot(inventorySlot).func_190926_b()) {
                stack.func_190920_e(foundCount);
                this.inventory.setStackInSlot(inventorySlot, stack);
            } else {
                this.inventory.getStackInSlot(inventorySlot).func_190917_f(foundCount);
            }
            amount -= foundCount;
        }
        return amount;
    }

    private void exportIntoContainers(TileEntity tile, int slot) {
        TileEntity capte;
        int meta = this.func_145832_p();
        if (tile != null && tile instanceof ICapabilityProvider && (capte = tile).hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, MultiblockHandler.intToEnumFacing(meta).func_176746_e())) {
            IItemHandler cap = (IItemHandler)capte.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, MultiblockHandler.intToEnumFacing(meta).func_176746_e());
            this.tryFillContainerCap(cap, slot);
        }
    }

    public boolean tryFillContainerCap(IItemHandler inv, int slot) {
        int i;
        int size = inv.getSlots();
        for (i = 0; i < size; ++i) {
            if (inv.getStackInSlot(i) == null) continue;
            if (this.inventory.getStackInSlot(slot).func_77973_b() == Items.field_190931_a) {
                return false;
            }
            ItemStack sta1 = inv.getStackInSlot(i).func_77946_l();
            ItemStack sta2 = this.inventory.getStackInSlot(slot).func_77946_l();
            if (sta1 == null || sta2 == null) continue;
            sta1.func_190920_e(1);
            sta2.func_190920_e(1);
            if (!this.isItemAcceptable(sta1, sta2) || inv.getStackInSlot(i).func_190916_E() >= inv.getStackInSlot(i).func_77976_d()) continue;
            this.inventory.getStackInSlot(slot).func_190918_g(1);
            if (this.inventory.getStackInSlot(slot).func_190926_b()) {
                this.inventory.setStackInSlot(slot, ItemStack.field_190927_a);
            }
            ItemStack sta3 = inv.getStackInSlot(i).func_77946_l();
            sta3.func_190920_e(1);
            inv.insertItem(i, sta3, false);
            return true;
        }
        for (i = 0; i < size; ++i) {
            if (this.inventory.getStackInSlot(slot).func_77973_b() == Items.field_190931_a) {
                return false;
            }
            ItemStack sta2 = this.inventory.getStackInSlot(slot).func_77946_l();
            if (inv.getStackInSlot(i).func_77973_b() != Items.field_190931_a || sta2 == null) continue;
            sta2.func_190920_e(1);
            this.inventory.getStackInSlot(slot).func_190918_g(1);
            if (this.inventory.getStackInSlot(slot).func_190926_b()) {
                this.inventory.setStackInSlot(slot, ItemStack.field_190927_a);
            }
            inv.insertItem(i, sta2, false);
            return true;
        }
        return false;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.age;
            if (this.age >= 20) {
                this.age = 0;
            }
            this.updateConnections();
            if (this.age == 9 || this.age == 19) {
                this.fillFluidInit(this.amat);
            }
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 13, this.power, 100000000L);
            FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.coolant, 11, 12);
            if (this.coolant.getFluid() != null && this.coolant.getFluid().getFluid() != ModForgeFluids.coolant) {
                this.coolant.setFluid(null);
            }
            FFUtils.fillFluidContainer((IItemHandlerModifiable)this.inventory, this.amat, 9, 10);
            this.findContainers();
            this.fillFromContainers(this.teIn1, 0, 3);
            this.fillFromContainers(this.teIn2, 1, 4);
            this.fillFromContainers(this.teIn3, 2, 5);
            this.exportIntoContainers(this.teOut1, 6);
            this.exportIntoContainers(this.teOut2, 7);
            this.exportIntoContainers(this.teOut3, 8);
            if (this.isOn) {
                int defConsumption = this.consumption - 100000 * this.getConsumption();
                if (this.canProcess() && this.power >= (long)defConsumption) {
                    this.progress += this.getSpeed();
                    this.power -= (long)defConsumption;
                    if (this.progress >= 690) {
                        this.process();
                        this.progress = 0;
                        this.func_70296_d();
                    }
                    if (this.coolant.getFluidAmount() > 0) {
                        this.countdown = 0;
                        if (this.field_145850_b.field_73012_v.nextInt(3) == 0) {
                            this.coolant.drain(1, true);
                        }
                    } else if (this.field_145850_b.field_73012_v.nextInt(this.getSafety()) == 0) {
                        ++this.countdown;
                        int chance = 7 - Math.min((int)Math.ceil((double)this.countdown / 200.0), 6);
                        if (this.field_145850_b.field_73012_v.nextInt(chance) == 0) {
                            ExplosionLarge.spawnTracers(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 3.25, (double)this.field_174879_c.func_177952_p() + 0.5, 1);
                        }
                        if (this.countdown > 1000) {
                            ExplosionThermo.setEntitiesOnFire(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, 25);
                            ExplosionThermo.scorchLight(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), 7);
                            if (this.countdown % 4 == 0) {
                                ExplosionLarge.spawnBurst(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 3.25, (double)this.field_174879_c.func_177952_p() + 0.5, 18, 1.0);
                            }
                        } else if (this.countdown > 600) {
                            ExplosionThermo.setEntitiesOnFire(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, 10);
                        }
                        if (this.countdown == 1140) {
                            this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, HBMSoundHandler.shutdown, SoundCategory.BLOCKS, 10.0f, 1.0f);
                        }
                        if (this.countdown > 1200) {
                            this.explode();
                        }
                    }
                } else {
                    this.progress = 0;
                }
            } else {
                this.progress = 0;
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74768_a("progress", this.progress);
            data.func_74757_a("isOn", this.isOn);
            data.func_74774_a("plugs", this.plugs);
            this.networkPack(data, 25);
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c, this.coolant, this.amat), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 15.0));
        }
    }

    private void updateConnections() {
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(3, 0, 1), Library.POS_X);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(3, 0, -1), Library.POS_X);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-3, 0, 1), Library.NEG_X);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-3, 0, -1), Library.NEG_X);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(1, 0, 3), Library.POS_Z);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-1, 0, 3), Library.POS_Z);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(1, 0, -3), Library.NEG_Z);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-1, 0, -3), Library.NEG_Z);
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.isOn = data.func_74767_n("isOn");
        this.power = data.func_74763_f("power");
        this.plugs = data.func_74771_c("plugs");
        this.progress = data.func_74762_e("progress");
    }

    @Override
    public void handleButtonPacket(int value, int meta) {
        this.isOn = !this.isOn;
    }

    public boolean isItemAcceptable(ItemStack stack1, ItemStack stack2) {
        if (stack1 != null && stack2 != null && !stack1.func_190926_b() && !stack2.func_190926_b()) {
            if (Library.areItemStacksCompatible(stack1, stack2)) {
                return true;
            }
            int[] ids1 = OreDictionary.getOreIDs((ItemStack)stack1);
            int[] ids2 = OreDictionary.getOreIDs((ItemStack)stack2);
            if (ids1 != null && ids2 != null && ids1.length > 0 && ids2.length > 0) {
                for (int i = 0; i < ids1.length; ++i) {
                    for (int j = 0; j < ids2.length; ++j) {
                        if (ids1[i] != ids2[j]) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void explode() {
        ExplosionLarge.explodeFire(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, 25.0f, true, false, true);
        int rand = this.field_145850_b.field_73012_v.nextInt(10);
        if (rand < 2) {
            this.field_145850_b.func_72838_d((Entity)EntityNukeExplosionMK5.statFac(this.field_145850_b, (int)((double)BombConfig.fatmanRadius * 1.5), (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5).mute());
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("type", "muke");
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 250.0));
            this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, HBMSoundHandler.mukeExplosion, SoundCategory.BLOCKS, 15.0f, 1.0f);
        } else if (rand < 4) {
            EntityBalefire bf = new EntityBalefire(this.field_145850_b).mute();
            bf.field_70165_t = (double)this.field_174879_c.func_177958_n() + 0.5;
            bf.field_70163_u = (double)this.field_174879_c.func_177956_o() + 1.5;
            bf.field_70161_v = (double)this.field_174879_c.func_177952_p() + 0.5;
            bf.destructionRange = (int)((double)BombConfig.fatmanRadius * 1.5);
            this.field_145850_b.func_72838_d((Entity)bf);
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("type", "muke");
            data.func_74757_a("balefire", true);
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 250.0));
            this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, HBMSoundHandler.mukeExplosion, SoundCategory.BLOCKS, 15.0f, 1.0f);
        } else if (rand < 5) {
            EntityBlackHole bl = new EntityBlackHole(this.field_145850_b, 1.5f + this.field_145850_b.field_73012_v.nextFloat());
            bl.field_70165_t = (float)this.field_174879_c.func_177958_n() + 0.5f;
            bl.field_70163_u = (float)this.field_174879_c.func_177956_o() + 1.5f;
            bl.field_70161_v = (float)this.field_174879_c.func_177952_p() + 0.5f;
            this.field_145850_b.func_72838_d((Entity)bl);
        }
    }

    public boolean canProcess() {
        for (int i = 0; i < 3; ++i) {
            ItemStack out;
            Object[] res = CyclotronRecipes.getOutput(this.inventory.getStackInSlot(i + 3), this.inventory.getStackInSlot(i));
            if (res == null || (out = (ItemStack)res[0]) == null) continue;
            if (this.inventory.getStackInSlot(i + 6).func_190926_b()) {
                return true;
            }
            if (!Library.areItemStacksCompatible(out, this.inventory.getStackInSlot(i + 6), false) || this.inventory.getStackInSlot(i + 6).func_190916_E() >= out.func_77976_d()) continue;
            return true;
        }
        return false;
    }

    public void process() {
        for (int i = 0; i < 3; ++i) {
            ItemStack out;
            Object[] res = CyclotronRecipes.getOutput(this.inventory.getStackInSlot(i + 3), this.inventory.getStackInSlot(i));
            if (res == null || (out = (ItemStack)res[0]) == null) continue;
            if (this.inventory.getStackInSlot(i + 6).func_190926_b()) {
                this.amat.fill(new FluidStack(ModForgeFluids.amat, ((Integer)res[1]).intValue()), true);
                this.inventory.getStackInSlot(i).func_190918_g(1);
                this.inventory.getStackInSlot(i + 3).func_190918_g(1);
                this.inventory.setStackInSlot(i + 6, out);
                continue;
            }
            if (this.inventory.getStackInSlot(i + 6).func_77973_b() != out.func_77973_b() || this.inventory.getStackInSlot(i + 6).func_77952_i() != out.func_77952_i() || this.inventory.getStackInSlot(i + 6).func_190916_E() >= out.func_77976_d()) continue;
            this.amat.fill(new FluidStack(ModForgeFluids.amat, ((Integer)res[1]).intValue()), true);
            this.inventory.getStackInSlot(i).func_190918_g(1);
            this.inventory.getStackInSlot(i + 3).func_190918_g(1);
            this.inventory.getStackInSlot(i + 6).func_190917_f(1);
        }
    }

    public int getSpeed() {
        int speed = 1;
        for (int i = 14; i < 16; ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.upgrade_speed_1) {
                ++speed;
                continue;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.upgrade_speed_2) {
                speed += 2;
                continue;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() != ModItems.upgrade_speed_3) continue;
            speed += 3;
        }
        return Math.min(speed, 4);
    }

    public int getConsumption() {
        int speed = 0;
        for (int i = 14; i < 16; ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.upgrade_power_1) {
                ++speed;
                continue;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.upgrade_power_2) {
                speed += 2;
                continue;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() != ModItems.upgrade_power_3) continue;
            speed += 3;
        }
        return Math.min(speed, 3);
    }

    public int getSafety() {
        int speed = 1;
        for (int i = 14; i < 16; ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.upgrade_effect_1) {
                ++speed;
                continue;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.upgrade_effect_2) {
                speed += 2;
                continue;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() != ModItems.upgrade_effect_3) continue;
            speed += 3;
        }
        return Math.min(speed, 4);
    }

    public long getPowerScaled(long i) {
        return this.power * i / 100000000L;
    }

    public int getProgressScaled(int i) {
        return this.progress * i / 690;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.coolant.readFromNBT(compound.func_74775_l("coolant"));
        this.amat.readFromNBT(compound.func_74775_l("amat"));
        this.isOn = compound.func_74767_n("isOn");
        this.countdown = compound.func_74762_e("countdown");
        this.progress = compound.func_74762_e("progress");
        this.plugs = compound.func_74771_c("plugs");
        this.power = compound.func_74763_f("power");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("coolant", (NBTBase)this.coolant.writeToNBT(new NBTTagCompound()));
        compound.func_74782_a("amat", (NBTBase)this.amat.writeToNBT(new NBTTagCompound()));
        compound.func_74757_a("isOn", this.isOn);
        compound.func_74768_a("countdown", this.countdown);
        compound.func_74774_a("plugs", this.plugs);
        compound.func_74768_a("progress", this.progress);
        compound.func_74772_a("power", this.power);
        return super.func_189515_b(compound);
    }

    public void setPlug(int index) {
        this.plugs = (byte)(this.plugs | 1 << index);
        this.func_70296_d();
    }

    public boolean getPlug(int index) {
        return (this.plugs & 1 << index) > 0;
    }

    public static Item getItemForPlug(int i) {
        switch (i) {
            case 0: {
                return ModItems.powder_balefire;
            }
            case 1: {
                return ModItems.book_of_;
            }
            case 2: {
                return ModItems.diamond_gavel;
            }
            case 3: {
                return ModItems.coin_maskman;
            }
        }
        return null;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 2), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 2), (double)(this.field_174879_c.func_177958_n() + 3), (double)(this.field_174879_c.func_177956_o() + 4), (double)(this.field_174879_c.func_177952_p() + 3));
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    public void fillFluidInit(FluidTank tank) {
        this.fillFluid(this.field_174879_c.func_177958_n() + 3, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 1, tank);
        this.fillFluid(this.field_174879_c.func_177958_n() + 3, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 1, tank);
        this.fillFluid(this.field_174879_c.func_177958_n() - 3, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 1, tank);
        this.fillFluid(this.field_174879_c.func_177958_n() - 3, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 1, tank);
        this.fillFluid(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 3, tank);
        this.fillFluid(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 3, tank);
        this.fillFluid(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 3, tank);
        this.fillFluid(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 3, tank);
    }

    public void fillFluid(int x, int y, int z, FluidTank tank) {
        FFUtils.fillFluid(this, tank, this.field_145850_b, new BlockPos(x, y, z), 2000);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.coolant.getTankProperties()[0], this.amat.getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null && resource.getFluid() == ModForgeFluids.coolant) {
            return this.coolant.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.amat.drain(resource, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.amat.drain(maxDrain, doDrain);
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length == 2) {
            this.coolant.readFromNBT(tags[0]);
            this.amat.readFromNBT(tags[1]);
        }
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000000L;
    }
}

