/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.interfaces.ILaserable;
import com.hbm.inventory.DFCRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.tool.ItemKeyPin;
import com.hbm.items.weapon.ItemCrucible;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.packet.AuxParticlePacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.machine.TileEntityLockableBase;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityCrateDesh
extends TileEntityLockableBase
implements ITickable,
ILaserable {
    public ItemStackHandler inventory;
    private String customName;
    private Random rand = new Random();
    public int heatTimer;

    public TileEntityCrateDesh() {
        this.inventory = new ItemStackHandler(104){

            protected void onContentsChanged(int slot) {
                TileEntityCrateDesh.this.func_70296_d();
            }
        };
    }

    @Override
    public boolean canAccess(EntityPlayer player) {
        if (!this.isLocked() || player == null) {
            return true;
        }
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() instanceof ItemKeyPin && ItemKeyPin.getPins(stack) == this.lock) {
            this.field_145850_b.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, HBMSoundHandler.lockOpen, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        if (stack.func_77973_b() == ModItems.key_red) {
            this.field_145850_b.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, HBMSoundHandler.lockOpen, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return this.tryPick(player);
    }

    public String getInventoryName() {
        return this.hasCustomInventoryName() ? this.customName : "container.crateDesh";
    }

    public boolean hasCustomInventoryName() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.heatTimer > 0) {
                --this.heatTimer;
            }
            if (this.heatTimer > 0) {
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), 4), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 50.0));
            }
        }
    }

    @Override
    public void addEnergy(long energy, EnumFacing dir) {
        this.heatTimer = 5;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
            ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(this.inventory.getStackInSlot(i));
            long requiredEnergy = DFCRecipes.getRequiredFlux(this.inventory.getStackInSlot(i));
            if (requiredEnergy > -1L && energy > requiredEnergy && 1.0E-4 > this.rand.nextDouble() * ((double)requiredEnergy / (double)energy)) {
                result = DFCRecipes.getOutput(this.inventory.getStackInSlot(i));
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.crucible && ItemCrucible.getCharges(this.inventory.getStackInSlot(i)) < 3 && energy > 10000000L) {
                ItemCrucible.charge(this.inventory.getStackInSlot(i));
            }
            if (result == null || result.func_190926_b()) continue;
            int size = this.inventory.getStackInSlot(i).func_190916_E();
            if (result.func_190916_E() * size > result.func_77976_d()) continue;
            this.inventory.setStackInSlot(i, result.func_77946_l());
            this.inventory.getStackInSlot(i).func_190920_e(this.inventory.getStackInSlot(i).func_190916_E() * size);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory) : super.getCapability(capability, facing));
    }
}

