/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.DummyBlockBlast;
import com.hbm.handler.RadiationSystemNT;
import com.hbm.interfaces.IAnimatedDoor;
import com.hbm.interfaces.IDoor;
import com.hbm.inventory.control_panel.ControlEvent;
import com.hbm.inventory.control_panel.ControlEventSystem;
import com.hbm.inventory.control_panel.DataValueFloat;
import com.hbm.inventory.control_panel.IControllable;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.TEVaultPacket;
import com.hbm.tileentity.machine.TileEntityDummy;
import com.hbm.tileentity.machine.TileEntityLockableBase;
import java.util.Arrays;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityBlastDoor
extends TileEntityLockableBase
implements ITickable,
IControllable,
IAnimatedDoor {
    public IDoor.DoorState state = IDoor.DoorState.CLOSED;
    public long sysTime;
    private int timer = 0;
    public boolean redstoned = false;

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177981_b(6).func_177982_a(1, 1, 1)).func_186662_g(0.25);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isLocked() && this.field_145850_b.func_175687_A(this.field_174879_c) > 0 || this.field_145850_b.func_175687_A(this.field_174879_c.func_177981_b(6)) > 0) {
                if (!this.redstoned) {
                    this.tryToggle();
                }
                this.redstoned = true;
            } else {
                this.redstoned = false;
            }
            if (this.state.isStationaryState()) {
                this.timer = 0;
            } else {
                ++this.timer;
                if (this.state == IDoor.DoorState.OPENING) {
                    if (this.timer >= 0) {
                        this.removeDummy(this.field_174879_c.func_177981_b(1));
                    }
                    if (this.timer >= 20) {
                        this.removeDummy(this.field_174879_c.func_177981_b(2));
                    }
                    if (this.timer >= 40) {
                        this.removeDummy(this.field_174879_c.func_177981_b(3));
                    }
                    if (this.timer >= 60) {
                        this.removeDummy(this.field_174879_c.func_177981_b(4));
                    }
                    if (this.timer >= 80) {
                        this.removeDummy(this.field_174879_c.func_177981_b(5));
                    }
                } else {
                    if (this.timer >= 20) {
                        this.placeDummy(this.field_174879_c.func_177981_b(5));
                    }
                    if (this.timer >= 40) {
                        this.placeDummy(this.field_174879_c.func_177981_b(4));
                    }
                    if (this.timer >= 60) {
                        this.placeDummy(this.field_174879_c.func_177981_b(3));
                    }
                    if (this.timer >= 80) {
                        this.placeDummy(this.field_174879_c.func_177981_b(2));
                    }
                    if (this.timer >= 100) {
                        this.placeDummy(this.field_174879_c.func_177981_b(1));
                    }
                }
                if (this.timer >= 100) {
                    if (this.state == IDoor.DoorState.OPENING) {
                        this.state = IDoor.DoorState.OPEN;
                        this.broadcastControlEvt();
                        this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), HBMSoundHandler.reactorStop, SoundCategory.BLOCKS, 0.5f, 1.0f);
                    } else if (this.state == IDoor.DoorState.CLOSING) {
                        this.state = IDoor.DoorState.CLOSED;
                        this.broadcastControlEvt();
                        this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), HBMSoundHandler.reactorStop, SoundCategory.BLOCKS, 0.5f, 1.0f);
                        RadiationSystemNT.markChunkForRebuild(this.field_145850_b, this.field_174879_c);
                    }
                }
            }
            PacketDispatcher.wrapper.sendToAllTracking((IMessage)new TEVaultPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.state.ordinal(), 0L, 0), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 150.0));
        }
    }

    public void broadcastControlEvt() {
        ControlEventSystem.get(this.field_145850_b).broadcastToSubscribed(this, ControlEvent.newEvent("door_open_state").setVar("state", new DataValueFloat(this.state.ordinal())));
    }

    public void openNeigh() {
        TileEntity te0 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(1, 0, 0));
        TileEntity te1 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-1, 0, 0));
        TileEntity te2 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 0, 1));
        TileEntity te3 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 0, -1));
        if (te0 instanceof TileEntityBlastDoor && ((TileEntityBlastDoor)te0).state == IDoor.DoorState.CLOSED && (!((TileEntityBlastDoor)te0).isLocked() || ((TileEntityBlastDoor)te0).lock == this.lock)) {
            ((TileEntityBlastDoor)te0).open();
            ((TileEntityBlastDoor)te0).openNeigh();
        }
        if (te1 instanceof TileEntityBlastDoor && ((TileEntityBlastDoor)te1).state == IDoor.DoorState.CLOSED && (!((TileEntityBlastDoor)te1).isLocked() || ((TileEntityBlastDoor)te1).lock == this.lock)) {
            ((TileEntityBlastDoor)te1).open();
            ((TileEntityBlastDoor)te1).openNeigh();
        }
        if (te2 instanceof TileEntityBlastDoor && ((TileEntityBlastDoor)te2).state == IDoor.DoorState.CLOSED && (!((TileEntityBlastDoor)te2).isLocked() || ((TileEntityBlastDoor)te2).lock == this.lock)) {
            ((TileEntityBlastDoor)te2).open();
            ((TileEntityBlastDoor)te2).openNeigh();
        }
        if (te3 instanceof TileEntityBlastDoor && ((TileEntityBlastDoor)te3).state == IDoor.DoorState.CLOSED && (!((TileEntityBlastDoor)te3).isLocked() || ((TileEntityBlastDoor)te3).lock == this.lock)) {
            ((TileEntityBlastDoor)te3).open();
            ((TileEntityBlastDoor)te3).openNeigh();
        }
    }

    @Override
    public void lock() {
        super.lock();
        this.lockNeigh();
    }

    public void closeNeigh() {
        TileEntity te0 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(1, 0, 0));
        TileEntity te1 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-1, 0, 0));
        TileEntity te2 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 0, 1));
        TileEntity te3 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 0, -1));
        if (te0 instanceof TileEntityBlastDoor && ((TileEntityBlastDoor)te0).state == IDoor.DoorState.OPEN && (!((TileEntityBlastDoor)te0).isLocked() || ((TileEntityBlastDoor)te0).lock == this.lock)) {
            ((TileEntityBlastDoor)te0).close();
            ((TileEntityBlastDoor)te0).closeNeigh();
        }
        if (te1 instanceof TileEntityBlastDoor && ((TileEntityBlastDoor)te1).state == IDoor.DoorState.OPEN && (!((TileEntityBlastDoor)te1).isLocked() || ((TileEntityBlastDoor)te1).lock == this.lock)) {
            ((TileEntityBlastDoor)te1).close();
            ((TileEntityBlastDoor)te1).closeNeigh();
        }
        if (te2 instanceof TileEntityBlastDoor && ((TileEntityBlastDoor)te2).state == IDoor.DoorState.OPEN && (!((TileEntityBlastDoor)te2).isLocked() || ((TileEntityBlastDoor)te2).lock == this.lock)) {
            ((TileEntityBlastDoor)te2).close();
            ((TileEntityBlastDoor)te2).closeNeigh();
        }
        if (te3 instanceof TileEntityBlastDoor && ((TileEntityBlastDoor)te3).state == IDoor.DoorState.OPEN && (!((TileEntityBlastDoor)te3).isLocked() || ((TileEntityBlastDoor)te3).lock == this.lock)) {
            ((TileEntityBlastDoor)te3).close();
            ((TileEntityBlastDoor)te3).closeNeigh();
        }
    }

    public void lockNeigh() {
        TileEntity te0 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(1, 0, 0));
        TileEntity te1 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-1, 0, 0));
        TileEntity te2 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 0, 1));
        TileEntity te3 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 0, -1));
        if (te0 instanceof TileEntityBlastDoor && !((TileEntityBlastDoor)te0).isLocked()) {
            ((TileEntityBlastDoor)te0).setPins(this.lock);
            ((TileEntityBlastDoor)te0).lock();
            ((TileEntityBlastDoor)te0).setMod(this.lockMod);
        }
        if (te1 instanceof TileEntityBlastDoor && !((TileEntityBlastDoor)te1).isLocked()) {
            ((TileEntityBlastDoor)te1).setPins(this.lock);
            ((TileEntityBlastDoor)te1).lock();
            ((TileEntityBlastDoor)te1).setMod(this.lockMod);
        }
        if (te2 instanceof TileEntityBlastDoor && !((TileEntityBlastDoor)te2).isLocked()) {
            ((TileEntityBlastDoor)te2).setPins(this.lock);
            ((TileEntityBlastDoor)te2).lock();
            ((TileEntityBlastDoor)te2).setMod(this.lockMod);
        }
        if (te3 instanceof TileEntityBlastDoor && !((TileEntityBlastDoor)te3).isLocked()) {
            ((TileEntityBlastDoor)te3).setPins(this.lock);
            ((TileEntityBlastDoor)te3).lock();
            ((TileEntityBlastDoor)te3).setMod(this.lockMod);
        }
    }

    public boolean tryOpen() {
        if (this.state == IDoor.DoorState.CLOSED) {
            if (!this.field_145850_b.field_72995_K) {
                this.open();
                this.openNeigh();
            }
            return true;
        }
        return false;
    }

    public boolean tryToggle() {
        if (this.state == IDoor.DoorState.CLOSED) {
            return this.tryOpen();
        }
        if (this.state == IDoor.DoorState.OPEN) {
            return this.tryClose();
        }
        return false;
    }

    public boolean tryClose() {
        if (this.state == IDoor.DoorState.OPEN) {
            if (!this.field_145850_b.field_72995_K) {
                this.close();
                this.closeNeigh();
            }
            return true;
        }
        return false;
    }

    public boolean placeDummy(BlockPos pos) {
        if (!this.field_145850_b.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)this.field_145850_b, pos)) {
            return false;
        }
        this.field_145850_b.func_175656_a(pos, ModBlocks.dummy_block_blast.func_176223_P());
        TileEntity te = this.field_145850_b.func_175625_s(pos);
        if (te instanceof TileEntityDummy) {
            TileEntityDummy dummy = (TileEntityDummy)te;
            dummy.target = this.field_174879_c;
        }
        return true;
    }

    public void removeDummy(BlockPos pos) {
        if (this.field_145850_b.func_180495_p(pos).func_177230_c() == ModBlocks.dummy_block_blast) {
            DummyBlockBlast.safeBreak = true;
            this.field_145850_b.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            DummyBlockBlast.safeBreak = false;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.state = IDoor.DoorState.values()[compound.func_74762_e("state")];
        this.sysTime = compound.func_74763_f("sysTime");
        this.timer = compound.func_74762_e("timer");
        this.redstoned = compound.func_74767_n("redstoned");
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("state", this.state.ordinal());
        compound.func_74772_a("sysTime", this.sysTime);
        compound.func_74768_a("timer", this.timer);
        compound.func_74757_a("redstoned", this.redstoned);
        return super.func_189515_b(compound);
    }

    @Override
    public void receiveEvent(BlockPos from, ControlEvent e) {
        if (e.name.equals("door_toggle")) {
            this.tryToggle();
        }
    }

    @Override
    public List<String> getInEvents() {
        return Arrays.asList("door_toggle");
    }

    @Override
    public List<String> getOutEvents() {
        return Arrays.asList("door_open_state");
    }

    public void func_145829_t() {
        super.func_145829_t();
        ControlEventSystem.get(this.field_145850_b).addControllable(this);
    }

    public void func_145843_s() {
        super.func_145843_s();
        ControlEventSystem.get(this.field_145850_b).removeControllable(this);
    }

    @Override
    public BlockPos getControlPos() {
        return this.func_174877_v();
    }

    @Override
    public World getControlWorld() {
        return this.func_145831_w();
    }

    @Override
    public void open() {
        if (this.state == IDoor.DoorState.CLOSED) {
            this.toggle();
        }
    }

    @Override
    public void close() {
        if (this.state == IDoor.DoorState.OPEN) {
            this.toggle();
        }
    }

    @Override
    public IDoor.DoorState getState() {
        return this.state;
    }

    @Override
    public void toggle() {
        if (this.state == IDoor.DoorState.CLOSED) {
            this.state = IDoor.DoorState.OPENING;
            PacketDispatcher.wrapper.sendToAllTracking((IMessage)new TEVaultPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.state.ordinal(), 1L, 0), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 150.0));
            this.closeNeigh();
            this.broadcastControlEvt();
            this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), HBMSoundHandler.reactorStart, SoundCategory.BLOCKS, 0.5f, 0.75f);
            RadiationSystemNT.markChunkForRebuild(this.field_145850_b, this.field_174879_c);
        } else if (this.state == IDoor.DoorState.OPEN) {
            this.state = IDoor.DoorState.CLOSING;
            PacketDispatcher.wrapper.sendToAllTracking((IMessage)new TEVaultPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.state.ordinal(), 1L, 0), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 150.0));
            this.openNeigh();
            this.broadcastControlEvt();
            this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), HBMSoundHandler.reactorStart, SoundCategory.BLOCKS, 0.5f, 0.75f);
            RadiationSystemNT.markChunkForRebuild(this.field_145850_b, this.field_174879_c);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleNewState(IDoor.DoorState newState) {
    }
}

