/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.conductor;

import com.hbm.forgefluid.FFPipeNetworkMk2;
import com.hbm.forgefluid.FFUtils;
import com.hbm.interfaces.IFluidPipeMk2;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.PipeUpdatePacket;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityFFDuctBaseMk2
extends TileEntity
implements IFluidPipeMk2,
IFluidHandler {
    public EnumFacing[] connections = new EnumFacing[6];
    protected Fluid type;
    protected FFPipeNetworkMk2 network = null;
    public TileEntity[] tileentityCache = new TileEntity[6];
    public boolean isBeingDestroyed = false;

    @Override
    public void setType(Fluid f) {
        if (f != this.type) {
            PlayerChunkMapEntry entry;
            this.type = f;
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
            this.field_145850_b.func_190524_a(this.field_174879_c, this.func_145838_q(), this.field_174879_c);
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), state, state, 2);
            TileEntityFFDuctBaseMk2.rebuildNetworks(this.field_145850_b, this.field_174879_c);
            if (this.field_145850_b instanceof WorldServer && (entry = ((WorldServer)this.field_145850_b).func_184164_w().func_187301_b(MathHelper.func_76141_d((float)this.field_174879_c.func_177958_n()) >> 4, MathHelper.func_76141_d((float)this.field_174879_c.func_177952_p()) >> 4)) != null) {
                for (EntityPlayerMP player : entry.getWatchingPlayers()) {
                    player.field_71135_a.func_147359_a((Packet)new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189515_b(new NBTTagCompound())));
                }
            }
            if (!this.field_145850_b.field_72995_K) {
                PacketDispatcher.wrapper.sendToAllTracking((IMessage)new PipeUpdatePacket(this.field_174879_c, 1), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
            }
        }
    }

    @Override
    public Fluid getType() {
        return this.type;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (this.type != null) {
            compound.func_74778_a("fluidType", this.type.getName());
        }
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_74764_b("fluidType")) {
            this.type = FluidRegistry.getFluid((String)compound.func_74779_i("fluidType"));
        }
        super.func_145839_a(compound);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189515_b(new NBTTagCompound()));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        Fluid f = this.type;
        this.func_145839_a(tag);
        if (f == this.type) {
            return;
        }
        for (EnumFacing e : EnumFacing.field_82609_l) {
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(e));
            if (!(te instanceof TileEntityFFDuctBaseMk2)) continue;
            ((TileEntityFFDuctBaseMk2)te).onNeighborChange();
        }
        this.onNeighborChange();
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_73046_m().func_152344_a(() -> {
                this.joinOrMakeNetwork();
                this.onNeighborChange();
            });
        } else {
            this.joinOrMakeNetwork();
            this.onNeighborChange();
        }
    }

    public void onNeighborChange() {
        this.rebuildCache();
        this.updateConnections();
        if (!this.field_145850_b.field_72995_K) {
            PacketDispatcher.wrapper.sendToAllTracking((IMessage)new PipeUpdatePacket(this.field_174879_c), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
        }
    }

    public void onChunkUnload() {
        if (this.network == null) {
            return;
        }
        for (TileEntity te : this.tileentityCache) {
            if (te == null || te instanceof IFluidPipeMk2) continue;
            if (!this.field_145850_b.func_175667_e(te.func_174877_v())) {
                this.network.checkForRemoval(te);
                continue;
            }
            boolean flag = true;
            for (EnumFacing e : EnumFacing.field_82609_l) {
                TileEntity ent;
                BlockPos pos = te.func_174877_v().func_177972_a(e);
                if (!this.field_145850_b.func_175667_e(pos) || !((ent = this.field_145850_b.func_175625_s(pos)) instanceof IFluidPipeMk2) || ((IFluidPipeMk2)ent).getNetwork() != this.network) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            this.network.checkForRemoval(te);
        }
        this.network.checkForRemoval(this);
        for (int i = 0; i < this.tileentityCache.length; ++i) {
            this.tileentityCache[i] = null;
        }
        this.network = null;
    }

    public void func_145843_s() {
        super.func_145843_s();
    }

    public static void breakBlock(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityFFDuctBaseMk2) {
            ((TileEntityFFDuctBaseMk2)te).isBeingDestroyed = true;
        }
        TileEntityFFDuctBaseMk2.rebuildNetworks(world, pos);
    }

    public static void rebuildNetworks(World world, BlockPos pos) {
        TileEntity center = world.func_175625_s(pos);
        for (EnumFacing e : EnumFacing.field_82609_l) {
            IFluidPipeMk2 pipe;
            TileEntity te = world.func_175625_s(pos.func_177972_a(e));
            if (!(te instanceof IFluidPipeMk2) || (pipe = (IFluidPipeMk2)te).getNetwork() == null) continue;
            pipe.getNetwork().destroy();
        }
        if (center instanceof IFluidPipeMk2 && ((IFluidPipeMk2)center).getNetwork() != null) {
            ((IFluidPipeMk2)center).getNetwork().destroy();
        }
        for (EnumFacing e : EnumFacing.field_82609_l) {
            FFPipeNetworkMk2.buildNetwork(world.func_175625_s(pos.func_177972_a(e)));
        }
        FFPipeNetworkMk2.buildNetwork(center);
    }

    @Override
    public void joinOrMakeNetwork() {
        ArrayList<FFPipeNetworkMk2> otherNetworks = new ArrayList<FFPipeNetworkMk2>();
        for (EnumFacing e : EnumFacing.field_82609_l) {
            IFluidPipeMk2 pipe;
            BlockPos offset = this.field_174879_c.func_177972_a(e);
            TileEntity te = this.field_145850_b.func_175625_s(offset);
            if (!(te instanceof IFluidPipeMk2) || (pipe = (IFluidPipeMk2)te).getNetwork() == null || pipe.getNetwork().getType() != this.getType() || otherNetworks.contains(pipe.getNetwork())) continue;
            otherNetworks.add(pipe.getNetwork());
        }
        if (otherNetworks.isEmpty()) {
            this.network = new FFPipeNetworkMk2(this);
            this.network.tryAdd(this);
            return;
        }
        FFPipeNetworkMk2 net = (FFPipeNetworkMk2)otherNetworks.remove(0);
        while (otherNetworks.size() > 0) {
            net = FFPipeNetworkMk2.mergeNetworks(net, (FFPipeNetworkMk2)otherNetworks.remove(0));
        }
        this.network = net;
        net.tryAdd(this);
    }

    protected boolean rebuildCache() {
        boolean changed = false;
        for (EnumFacing e : EnumFacing.field_82609_l) {
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(e));
            if (this.tileentityCache[e.func_176745_a()] == null) {
                if (te == null) continue;
                if (this.network != null) {
                    this.network.tryAdd(te);
                }
                this.tileentityCache[e.func_176745_a()] = te;
                changed = true;
                continue;
            }
            if (te == null) {
                if (this.network != null) {
                    this.network.checkForRemoval(this.tileentityCache[e.func_176745_a()]);
                }
                this.tileentityCache[e.func_176745_a()] = null;
                changed = true;
                continue;
            }
            if (te == this.tileentityCache[e.func_176745_a()]) continue;
            if (this.network != null) {
                this.network.checkForRemoval(this.tileentityCache[e.func_176745_a()]);
                this.network.tryAdd(te);
            }
            this.tileentityCache[e.func_176745_a()] = te;
            changed = true;
        }
        if (this.field_145850_b.field_72995_K) {
            // empty if block
        }
        return changed;
    }

    public void updateConnections() {
        this.connections[0] = FFUtils.checkFluidConnectablesMk2(this.field_145850_b, this.field_174879_c.func_177984_a(), this.getType(), EnumFacing.UP.func_176734_d()) ? EnumFacing.UP : null;
        this.connections[1] = FFUtils.checkFluidConnectablesMk2(this.field_145850_b, this.field_174879_c.func_177977_b(), this.getType(), EnumFacing.DOWN.func_176734_d()) ? EnumFacing.DOWN : null;
        this.connections[2] = FFUtils.checkFluidConnectablesMk2(this.field_145850_b, this.field_174879_c.func_177978_c(), this.getType(), EnumFacing.NORTH.func_176734_d()) ? EnumFacing.NORTH : null;
        this.connections[3] = FFUtils.checkFluidConnectablesMk2(this.field_145850_b, this.field_174879_c.func_177974_f(), this.getType(), EnumFacing.EAST.func_176734_d()) ? EnumFacing.EAST : null;
        this.connections[4] = FFUtils.checkFluidConnectablesMk2(this.field_145850_b, this.field_174879_c.func_177968_d(), this.getType(), EnumFacing.SOUTH.func_176734_d()) ? EnumFacing.SOUTH : null;
        this.connections[5] = FFUtils.checkFluidConnectablesMk2(this.field_145850_b, this.field_174879_c.func_177976_e(), this.getType(), EnumFacing.WEST.func_176734_d()) ? EnumFacing.WEST : null;
    }

    @Override
    public FFPipeNetworkMk2 getNetwork() {
        return this.network;
    }

    @Override
    public void setNetwork(FFPipeNetworkMk2 net) {
        this.network = net;
    }

    @Override
    public boolean isValidForBuilding() {
        return !this.isBeingDestroyed;
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.network != null ? this.network.getTankProperties() : new IFluidTankProperties[]{};
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.network != null ? this.network.fill(resource, doFill) : 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.network != null ? this.network.drain(resource, doDrain) : null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.network != null ? this.network.drain(maxDrain, doDrain) : null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this) : super.getCapability(capability, facing));
    }
}

